/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PipelineOperation;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PRecordQueryInsertPlan;
import com.apple.foundationdb.record.planprotos.PRecordQueryPlan;
import com.apple.foundationdb.record.provider.foundationdb.FDBQueriedRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoredRecord;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.explain.ExplainPlanVisitor;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.MessageHelpers;
import com.apple.foundationdb.record.query.plan.cascades.values.PromoteValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryAbstractDataModificationPlan;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.INTERNAL)
public class RecordQueryInsertPlan
extends RecordQueryAbstractDataModificationPlan {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Record-Query-Insert-Plan");
    public static final Logger LOGGER = LoggerFactory.getLogger(RecordQueryInsertPlan.class);

    protected RecordQueryInsertPlan(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryInsertPlan recordQueryInsertPlanProto) {
        super(serializationContext, Objects.requireNonNull(recordQueryInsertPlanProto.getSuper()));
    }

    private RecordQueryInsertPlan(@Nonnull Quantifier.Physical inner, @Nonnull String recordType, @Nonnull Type.Record targetType, @Nullable MessageHelpers.CoercionTrieNode coercionsTrie, @Nonnull Value computationValue) {
        super(inner, recordType, targetType, null, coercionsTrie, computationValue, RecordQueryInsertPlan.currentModifiedRecordAlias());
    }

    @Override
    public PipelineOperation getPipelineOperation() {
        return PipelineOperation.INSERT;
    }

    @Override
    @Nonnull
    public <M extends Message> CompletableFuture<QueryResult> saveRecordAsync(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nonnull M message, boolean isDryRun) {
        CompletableFuture<FDBStoredRecord<M>> result = isDryRun ? store.dryRunSaveRecordAsync(message, FDBRecordStoreBase.RecordExistenceCheck.ERROR_IF_EXISTS) : store.saveRecordAsync(message, FDBRecordStoreBase.RecordExistenceCheck.ERROR_IF_EXISTS);
        return result.thenApply(fdbStoredRecord -> QueryResult.fromQueriedRecord(FDBQueriedRecord.stored(fdbStoredRecord)));
    }

    @Override
    @Nonnull
    public RecordQueryInsertPlan translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        Verify.verify(translatedQuantifiers.size() == 1);
        Value translatedComputationValue = this.getComputationValue().translateCorrelations(translationMap);
        return new RecordQueryInsertPlan(Iterables.getOnlyElement(translatedQuantifiers).narrow(Quantifier.Physical.class), this.getTargetRecordType(), this.getTargetType(), this.getCoercionTrie(), translatedComputationValue);
    }

    @Override
    @Nonnull
    public RecordQueryInsertPlan withChild(@Nonnull Reference childRef) {
        return new RecordQueryInsertPlan(Quantifier.physical(childRef, this.getInner().getAlias()), this.getTargetRecordType(), this.getTargetType(), this.getCoercionTrie(), this.getComputationValue());
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return Objects.hash(BASE_HASH.hashCode(), super.computeHashCodeWithoutChildren());
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, BASE_HASH, super.planHash(mode));
    }

    @Nonnull
    public String toString() {
        return ExplainPlanVisitor.toStringForDebugging(this);
    }

    @Override
    @Nonnull
    public PlannerGraph rewritePlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        PlannerGraph graphForTarget = PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.DataNodeWithInfo(NodeInfo.BASE_DATA, this.getResultType(), ImmutableList.of(this.getTargetRecordType())), ImmutableList.of());
        return PlannerGraph.fromNodeInnerAndTargetForModifications(new PlannerGraph.ModificationOperatorNodeWithInfo(this, NodeInfo.MODIFICATION_OPERATOR, ImmutableList.of("INSERT"), ImmutableMap.of()), Iterables.getOnlyElement(childGraphs), graphForTarget);
    }

    @Override
    @Nonnull
    public PRecordQueryInsertPlan toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryInsertPlan.newBuilder().setSuper(this.toRecordQueryAbstractModificationPlanProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PRecordQueryPlan toRecordQueryPlanProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryPlan.newBuilder().setInsertPlan(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static RecordQueryInsertPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryInsertPlan recordQueryInsertPlanProto) {
        return new RecordQueryInsertPlan(serializationContext, recordQueryInsertPlanProto);
    }

    @Nonnull
    public static RecordQueryInsertPlan insertPlan(@Nonnull Quantifier.Physical inner, @Nonnull String recordType, @Nonnull Type.Record targetType, @Nonnull Value computationValue) {
        return new RecordQueryInsertPlan(inner, recordType, targetType, PromoteValue.computePromotionsTrie(targetType, inner.getFlowedObjectType(), null), computationValue);
    }

    public static class Deserializer
    implements PlanDeserializer<PRecordQueryInsertPlan, RecordQueryInsertPlan> {
        @Override
        @Nonnull
        public Class<PRecordQueryInsertPlan> getProtoMessageClass() {
            return PRecordQueryInsertPlan.class;
        }

        @Override
        @Nonnull
        public RecordQueryInsertPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryInsertPlan recordQueryInsertPlanProto) {
            return RecordQueryInsertPlan.fromProto(serializationContext, recordQueryInsertPlanProto);
        }
    }
}

