/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.planprotos.PRecordQueryIntersectionOnValuesPlan;
import com.apple.foundationdb.record.planprotos.PRecordQueryPlan;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.FinalMemoizer;
import com.apple.foundationdb.record.query.plan.cascades.OrderingPart;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifiers;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.DefaultValueSimplificationRuleSet;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIntersectionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithComparisonKeyValues;
import com.apple.foundationdb.record.query.plan.plans.RecordQuerySetPlan;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RecordQueryIntersectionOnValuesPlan
extends RecordQueryIntersectionPlan
implements RecordQueryPlanWithComparisonKeyValues {
    @Nullable
    private final List<OrderingPart.ProvidedOrderingPart> comparisonKeyOrderingParts;

    protected RecordQueryIntersectionOnValuesPlan(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryIntersectionOnValuesPlan recordQueryIntersectionOnValuesPlanProto) {
        super(serializationContext, Objects.requireNonNull(recordQueryIntersectionOnValuesPlanProto.getSuper()));
        this.comparisonKeyOrderingParts = null;
    }

    private RecordQueryIntersectionOnValuesPlan(@Nonnull List<Quantifier.Physical> quantifiers, @Nullable List<OrderingPart.ProvidedOrderingPart> comparisonKeyOrderingParts, @Nonnull List<? extends Value> comparisonKeyValues, boolean reverse) {
        super(quantifiers, new RecordQuerySetPlan.ComparisonKeyFunction.OnValues(Quantifier.current(), comparisonKeyValues), reverse);
        this.comparisonKeyOrderingParts = comparisonKeyOrderingParts == null ? null : ImmutableList.copyOf(comparisonKeyOrderingParts);
    }

    @Override
    @Nonnull
    public RecordQuerySetPlan.ComparisonKeyFunction.OnValues getComparisonKeyFunction() {
        return (RecordQuerySetPlan.ComparisonKeyFunction.OnValues)super.getComparisonKeyFunction();
    }

    @Override
    @Nonnull
    public List<? extends Value> getRequiredValues(@Nonnull CorrelationIdentifier newBaseAlias, @Nonnull Type inputType) {
        DefaultValueSimplificationRuleSet ruleSet = DefaultValueSimplificationRuleSet.instance();
        return this.getComparisonKeyValues().stream().map(comparisonKeyValue -> comparisonKeyValue.rebase(AliasMap.ofAliases(Quantifier.current(), newBaseAlias)).simplify(ruleSet, EvaluationContext.empty(), AliasMap.emptyMap(), this.getCorrelatedTo())).collect(ImmutableList.toImmutableList());
    }

    @Override
    @Nonnull
    public Set<KeyExpression> getRequiredFields() {
        throw new RecordCoreException("this plan does not support this getRequiredFields()", new Object[0]);
    }

    @Override
    @Nonnull
    public List<OrderingPart.ProvidedOrderingPart> getComparisonKeyOrderingParts() {
        return Objects.requireNonNull(this.comparisonKeyOrderingParts);
    }

    @Override
    @Nonnull
    public List<? extends Value> getComparisonKeyValues() {
        return this.getComparisonKeyFunction().getComparisonKeyValues();
    }

    @Override
    @Nonnull
    public Set<Type> getDynamicTypes() {
        return this.getComparisonKeyValues().stream().flatMap(comparisonKeyValue -> comparisonKeyValue.getDynamicTypes().stream()).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    @Nonnull
    public RecordQueryIntersectionOnValuesPlan translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        return new RecordQueryIntersectionOnValuesPlan(Quantifiers.narrow(Quantifier.Physical.class, translatedQuantifiers), this.comparisonKeyOrderingParts, this.getComparisonKeyValues(), this.isReverse());
    }

    @Override
    @Nonnull
    public RecordQueryIntersectionOnValuesPlan withChildrenReferences(@Nonnull List<? extends Reference> newChildren) {
        return new RecordQueryIntersectionOnValuesPlan(newChildren.stream().map(Quantifier::physical).collect(ImmutableList.toImmutableList()), this.comparisonKeyOrderingParts, this.getComparisonKeyValues(), this.isReverse());
    }

    @Override
    public RecordQueryIntersectionOnValuesPlan strictlySorted(@Nonnull FinalMemoizer memoizer) {
        List<Quantifier.Physical> quantifiers = Quantifiers.fromPlans(this.getChildren().stream().map(p -> memoizer.memoizePlan(p.strictlySorted(memoizer))).collect(Collectors.toList()));
        return new RecordQueryIntersectionOnValuesPlan(quantifiers, this.comparisonKeyOrderingParts, this.getComparisonKeyValues(), this.reverse);
    }

    @Override
    @Nonnull
    public PRecordQueryIntersectionOnValuesPlan toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryIntersectionOnValuesPlan.newBuilder().setSuper(this.toRecordQueryIntersectionPlan(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PRecordQueryPlan toRecordQueryPlanProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryPlan.newBuilder().setIntersectionOnValuesPlan(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static RecordQueryIntersectionOnValuesPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryIntersectionOnValuesPlan recordQueryIntersectionOnValuesPlanProto) {
        return new RecordQueryIntersectionOnValuesPlan(serializationContext, recordQueryIntersectionOnValuesPlanProto);
    }

    @Nonnull
    public static RecordQueryIntersectionOnValuesPlan intersection(@Nonnull List<Quantifier.Physical> quantifiers, @Nonnull List<OrderingPart.ProvidedOrderingPart> comparisonKeyOrderingParts, boolean isReverse) {
        return new RecordQueryIntersectionOnValuesPlan(quantifiers, comparisonKeyOrderingParts, OrderingPart.ProvidedOrderingPart.comparisonKeyValues(comparisonKeyOrderingParts, isReverse), isReverse);
    }

    public static class Deserializer
    implements PlanDeserializer<PRecordQueryIntersectionOnValuesPlan, RecordQueryIntersectionOnValuesPlan> {
        @Override
        @Nonnull
        public Class<PRecordQueryIntersectionOnValuesPlan> getProtoMessageClass() {
            return PRecordQueryIntersectionOnValuesPlan.class;
        }

        @Override
        @Nonnull
        public RecordQueryIntersectionOnValuesPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryIntersectionOnValuesPlan recordQueryIntersectionOnValuesPlanProto) {
            return RecordQueryIntersectionOnValuesPlan.fromProto(serializationContext, recordQueryIntersectionOnValuesPlanProto);
        }
    }
}

