/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.planprotos.PRecordQueryIntersectionPlan;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.cursors.IntersectionCursor;
import com.apple.foundationdb.record.query.plan.AvailableFields;
import com.apple.foundationdb.record.query.plan.HeuristicPlanner;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.OrderingPart;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifiers;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.debug.Debugger;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.apple.foundationdb.record.query.plan.cascades.explain.ExplainPlanVisitor;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.plans.QueryPlan;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIntersectionOnKeyExpressionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIntersectionOnValuesPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithChildren;
import com.apple.foundationdb.record.query.plan.plans.RecordQuerySetPlan;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.INTERNAL)
public abstract class RecordQueryIntersectionPlan
extends AbstractRelationalExpressionWithChildren
implements RecordQueryPlanWithChildren,
RecordQuerySetPlan {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Record-Query-Intersection-Plan");
    public static final Logger LOGGER = LoggerFactory.getLogger(RecordQueryIntersectionPlan.class);
    @Nonnull
    private final List<Quantifier.Physical> quantifiers;
    @Nonnull
    private final RecordQuerySetPlan.ComparisonKeyFunction comparisonKeyFunction;
    protected final boolean reverse;
    @Nonnull
    private final Supplier<Value> resultValueSupplier;

    protected RecordQueryIntersectionPlan(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryIntersectionPlan recordQueryIntersectionPlanProto) {
        Verify.verify(recordQueryIntersectionPlanProto.hasReverse());
        ImmutableList.Builder quantifiersBuilder = ImmutableList.builder();
        for (int i = 0; i < recordQueryIntersectionPlanProto.getQuantifiersCount(); ++i) {
            quantifiersBuilder.add(Quantifier.Physical.fromProto(serializationContext, recordQueryIntersectionPlanProto.getQuantifiers(i)));
        }
        this.quantifiers = quantifiersBuilder.build();
        this.comparisonKeyFunction = RecordQuerySetPlan.ComparisonKeyFunction.fromComparisonKeyFunctionProto(serializationContext, Objects.requireNonNull(recordQueryIntersectionPlanProto.getComparisonKeyFunction()));
        this.reverse = recordQueryIntersectionPlanProto.getReverse();
        this.resultValueSupplier = Suppliers.memoize(this::computeResultValue);
    }

    protected RecordQueryIntersectionPlan(@Nonnull List<Quantifier.Physical> quantifiers, @Nonnull RecordQuerySetPlan.ComparisonKeyFunction comparisonKeyFunction, boolean reverse) {
        this.quantifiers = ImmutableList.copyOf(quantifiers);
        this.comparisonKeyFunction = comparisonKeyFunction;
        this.reverse = reverse;
        this.resultValueSupplier = Suppliers.memoize(this::computeResultValue);
    }

    @Nonnull
    public RecordQuerySetPlan.ComparisonKeyFunction getComparisonKeyFunction() {
        return this.comparisonKeyFunction;
    }

    @Override
    @Nonnull
    public <M extends Message> RecordCursor<QueryResult> executePlan(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        ExecuteProperties childExecuteProperties = executeProperties.clearSkipAndLimit();
        return IntersectionCursor.create(this.comparisonKeyFunction.apply(store, context), this.reverse, this.quantifiers.stream().map(Quantifier.Physical::getRangesOverPlan).map(childPlan -> childContinuation -> childPlan.executePlan(store, context, (byte[])childContinuation, childExecuteProperties)).collect(Collectors.toList()), continuation, store.getTimer()).skipThenLimit(executeProperties.getSkip(), executeProperties.getReturnedRowLimit());
    }

    @Override
    public boolean isReverse() {
        return this.reverse;
    }

    @Nonnull
    private Stream<RecordQueryPlan> getChildStream() {
        return this.quantifiers.stream().map(Quantifier.Physical::getRangesOverPlan);
    }

    @Override
    @Nonnull
    public List<RecordQueryPlan> getChildren() {
        return this.quantifiers.stream().map(Quantifier.Physical::getRangesOverPlan).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    public List<? extends Quantifier> getQuantifiers() {
        return this.quantifiers;
    }

    @Nonnull
    public String toString() {
        return ExplainPlanVisitor.toStringForDebugging(this);
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        return ImmutableSet.of();
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        return this.resultValueSupplier.get();
    }

    @Nonnull
    protected Value computeResultValue() {
        return RecordQuerySetPlan.mergeValues(this.quantifiers);
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap equivalencesMap) {
        if (this == otherExpression) {
            return true;
        }
        if (this.getClass() != otherExpression.getClass()) {
            return false;
        }
        RecordQueryIntersectionPlan other = (RecordQueryIntersectionPlan)otherExpression;
        return this.reverse == other.reverse && this.comparisonKeyFunction.equals(other.comparisonKeyFunction);
    }

    @Override
    @Nonnull
    public AvailableFields getAvailableFields() {
        return AvailableFields.intersection(this.quantifiers.stream().map(child -> child.getRangesOverPlan().getAvailableFields()).collect(Collectors.toList()));
    }

    public boolean equals(Object other) {
        return this.structuralEquals(other);
    }

    public int hashCode() {
        return this.structuralHashCode();
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return Objects.hash(this.comparisonKeyFunction, this.reverse);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: {
                return PlanHashable.planHash(mode, this.getQueryPlanChildren()) + this.comparisonKeyFunction.planHash(mode) + (this.reverse ? 1 : 0);
            }
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.getQueryPlanChildren(), this.comparisonKeyFunction, this.reverse);
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    @Override
    public void logPlanStructure(StoreTimer timer) {
        timer.increment(FDBStoreTimer.Counts.PLAN_INTERSECTION);
        for (Quantifier.Physical quantifier : this.quantifiers) {
            quantifier.getRangesOverPlan().logPlanStructure(timer);
        }
    }

    @Override
    public int getComplexity() {
        return 1 + this.getChildStream().mapToInt(QueryPlan::getComplexity).sum();
    }

    @Override
    public int getRelationalChildCount() {
        return this.quantifiers.size();
    }

    @Override
    public int maxCardinality(@Nonnull RecordMetaData metaData) {
        return this.getChildStream().map(p -> p.maxCardinality(metaData)).min(Integer::compare).orElse(Integer.MAX_VALUE);
    }

    @Override
    public boolean isStrictlySorted() {
        return this.getChildren().stream().allMatch(QueryPlan::isStrictlySorted);
    }

    @Override
    @Nonnull
    public PlannerGraph rewritePlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        return PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.OperatorNodeWithInfo(this, NodeInfo.INTERSECTION_OPERATOR, ImmutableList.of("COMPARE BY {{comparisonKeyFunction}}"), ImmutableMap.of("comparisonKeyFunction", Attribute.gml(this.comparisonKeyFunction.toString()))), childGraphs);
    }

    @Nonnull
    protected PRecordQueryIntersectionPlan toRecordQueryIntersectionPlan(@Nonnull PlanSerializationContext serializationContext) {
        PRecordQueryIntersectionPlan.Builder builder = PRecordQueryIntersectionPlan.newBuilder();
        for (Quantifier.Physical quantifier : this.quantifiers) {
            builder.addQuantifiers(quantifier.toProto(serializationContext));
        }
        builder.setComparisonKeyFunction(this.comparisonKeyFunction.toComparisonKeyFunctionProto(serializationContext)).setReverse(this.reverse);
        return builder.build();
    }

    @Nonnull
    public static RecordQueryIntersectionOnKeyExpressionPlan fromQuantifiers(@Nonnull List<Quantifier.Physical> quantifiers, @Nonnull KeyExpression comparisonKey) {
        return new RecordQueryIntersectionOnKeyExpressionPlan(quantifiers, comparisonKey, Quantifiers.isReversed(quantifiers));
    }

    @Nonnull
    public static RecordQueryIntersectionOnValuesPlan fromQuantifiers(@Nonnull List<Quantifier.Physical> quantifiers, @Nonnull List<OrderingPart.ProvidedOrderingPart> comparisonKeyOrderingParts, boolean isReverse) {
        return RecordQueryIntersectionOnValuesPlan.intersection(quantifiers, comparisonKeyOrderingParts, isReverse);
    }

    @Nonnull
    @HeuristicPlanner
    public static RecordQueryIntersectionOnKeyExpressionPlan from(@Nonnull RecordQueryPlan left, @Nonnull RecordQueryPlan right, @Nonnull KeyExpression comparisonKey) {
        Debugger.verifyHeuristicPlanner();
        if (left.isReverse() != right.isReverse()) {
            throw new RecordCoreArgumentException("left plan and right plan for union do not have same value for reverse field", new Object[0]);
        }
        ImmutableList<Reference> childRefs = ImmutableList.of(Reference.plannedOf(left), Reference.plannedOf(right));
        return new RecordQueryIntersectionOnKeyExpressionPlan(Quantifiers.fromPlans(childRefs), comparisonKey, left.isReverse());
    }

    @Nonnull
    @HeuristicPlanner
    public static RecordQueryIntersectionOnKeyExpressionPlan from(@Nonnull List<? extends RecordQueryPlan> children, @Nonnull KeyExpression comparisonKey) {
        Debugger.verifyHeuristicPlanner();
        if (children.size() < 2) {
            throw new RecordCoreArgumentException("fewer than two children given to union plan", new Object[0]);
        }
        boolean firstReverse = children.get(0).isReverse();
        if (!children.stream().allMatch(child -> child.isReverse() == firstReverse)) {
            throw new RecordCoreArgumentException("children of union plan do all have same value for reverse field", new Object[0]);
        }
        ImmutableList.Builder childRefsBuilder = ImmutableList.builder();
        for (RecordQueryPlan recordQueryPlan : children) {
            childRefsBuilder.add(Reference.plannedOf(recordQueryPlan));
        }
        return new RecordQueryIntersectionOnKeyExpressionPlan(Quantifiers.fromPlans(childRefsBuilder.build()), comparisonKey, firstReverse);
    }
}

