/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PipelineOperation;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.RecordScanLimiter;
import com.apple.foundationdb.record.planprotos.PRecordQueryPlan;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.query.plan.AvailableFields;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.apple.foundationdb.record.query.plan.cascades.explain.ExplainPlanVisitor;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithoutChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.values.QueriedValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithNoChildren;
import com.apple.foundationdb.tuple.Tuple;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Message;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class RecordQueryLoadByKeysPlan
extends AbstractRelationalExpressionWithoutChildren
implements RecordQueryPlanWithNoChildren {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Record-Query-Load-By-Keys-Plan");
    @Nonnull
    private final KeysSource keysSource;

    public RecordQueryLoadByKeysPlan(@Nonnull KeysSource keysSource) {
        this.keysSource = keysSource;
    }

    public RecordQueryLoadByKeysPlan(@Nonnull List<Tuple> primaryKeys) {
        this(new PrimaryKeysKeySource(primaryKeys));
    }

    public RecordQueryLoadByKeysPlan(@Nonnull String parameter) {
        this(new ParameterKeySource(parameter));
    }

    @Override
    @Nonnull
    public <M extends Message> RecordCursor<QueryResult> executePlan(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        RecordScanLimiter recordScanLimiter = executeProperties.getState().getRecordScanLimiter();
        return RecordCursor.fromList(store.getExecutor(), this.getKeysSource().getPrimaryKeys(context), continuation).mapPipelined(key -> {
            if (recordScanLimiter != null) {
                recordScanLimiter.tryRecordScan();
            }
            return store.loadRecordAsync((Tuple)key);
        }, store.getPipelineSize(PipelineOperation.KEY_TO_RECORD)).filter(Objects::nonNull).map(store::queriedRecord).skipThenLimit(executeProperties.getSkip(), executeProperties.getReturnedRowLimit()).map(QueryResult::fromQueriedRecord);
    }

    @Override
    public boolean isReverse() {
        return false;
    }

    @Override
    public boolean hasRecordScan() {
        return false;
    }

    @Override
    public boolean hasFullRecordScan() {
        return false;
    }

    @Override
    public boolean hasIndexScan(@Nonnull String indexName) {
        return false;
    }

    @Nonnull
    public KeysSource getKeysSource() {
        return this.keysSource;
    }

    @Override
    @Nonnull
    public Set<String> getUsedIndexes() {
        return new HashSet<String>();
    }

    @Override
    public int maxCardinality(@Nonnull RecordMetaData metaData) {
        return this.keysSource.maxCardinality();
    }

    @Override
    @Nonnull
    public AvailableFields getAvailableFields() {
        return AvailableFields.ALL_FIELDS;
    }

    @Override
    public boolean hasLoadBykeys() {
        return true;
    }

    @Nonnull
    public String toString() {
        return ExplainPlanVisitor.toStringForDebugging(this);
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        return ImmutableSet.of();
    }

    @Override
    @Nonnull
    public RecordQueryLoadByKeysPlan translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        return this;
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        return new QueriedValue();
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap equivalencesMap) {
        if (this == otherExpression) {
            return true;
        }
        if (this.getClass() != otherExpression.getClass()) {
            return false;
        }
        return Objects.equals(this.getKeysSource(), ((RecordQueryLoadByKeysPlan)otherExpression).getKeysSource());
    }

    public boolean equals(Object other) {
        return this.structuralEquals(other);
    }

    public int hashCode() {
        return this.structuralHashCode();
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return Objects.hash(this.getKeysSource());
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: {
                return this.getKeysSource().planHash(mode);
            }
            case FOR_CONTINUATION: {
                return PlanHashable.planHash(mode, BASE_HASH, this.getKeysSource());
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    @Override
    public void logPlanStructure(StoreTimer timer) {
        timer.increment(FDBStoreTimer.Counts.PLAN_LOAD_BY_KEYS);
    }

    @Override
    public int getComplexity() {
        return 1;
    }

    @Override
    @Nonnull
    public PlannerGraph rewritePlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        return PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.OperatorNodeWithInfo(this, NodeInfo.LOAD_BY_KEYS_OPERATOR, ImmutableList.of("BY KEYS {{keysSource}}"), ImmutableMap.of("keysSource", Attribute.gml(this.getKeysSource().toString()))), childGraphs);
    }

    @Override
    @Nonnull
    public Message toProto(@Nonnull PlanSerializationContext serializationContext) {
        throw new RecordCoreException("serialization of this plan is not supported", new Object[0]);
    }

    @Override
    @Nonnull
    public PRecordQueryPlan toRecordQueryPlanProto(@Nonnull PlanSerializationContext serializationContext) {
        throw new RecordCoreException("serialization of this plan is not supported", new Object[0]);
    }

    public static interface KeysSource
    extends PlanHashable {
        public List<Tuple> getPrimaryKeys(@Nonnull EvaluationContext var1);

        public int maxCardinality();
    }

    private static class PrimaryKeysKeySource
    implements KeysSource {
        private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Primary-Keys-Key-Source");
        private final List<Tuple> primaryKeys;

        public PrimaryKeysKeySource(List<Tuple> primaryKeys) {
            this.primaryKeys = primaryKeys;
        }

        @Override
        public List<Tuple> getPrimaryKeys(@Nonnull EvaluationContext context) {
            return this.primaryKeys;
        }

        @Override
        public int maxCardinality() {
            return this.primaryKeys.size();
        }

        public String toString() {
            return this.primaryKeys.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PrimaryKeysKeySource that = (PrimaryKeysKeySource)o;
            return Objects.equals(this.primaryKeys, that.primaryKeys);
        }

        public int hashCode() {
            return Objects.hash(this.primaryKeys);
        }

        @Override
        public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
            switch (mode.getKind()) {
                case LEGACY: {
                    return this.hashCode();
                }
                case FOR_CONTINUATION: {
                    return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.primaryKeys);
                }
            }
            throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
        }
    }

    private static class ParameterKeySource
    implements KeysSource {
        private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Parameter-Key-Source");
        private final String parameter;

        public ParameterKeySource(String parameter) {
            this.parameter = parameter;
        }

        @Override
        public List<Tuple> getPrimaryKeys(@Nonnull EvaluationContext context) {
            return (List)context.getBinding(this.parameter);
        }

        @Override
        public int maxCardinality() {
            return Integer.MAX_VALUE;
        }

        public String toString() {
            return "$" + this.parameter;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParameterKeySource that = (ParameterKeySource)o;
            return Objects.equals(this.parameter, that.parameter);
        }

        public int hashCode() {
            return Objects.hash(this.parameter);
        }

        @Override
        public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
            switch (mode.getKind()) {
                case LEGACY: {
                    return this.hashCode();
                }
                case FOR_CONTINUATION: {
                    return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.parameter);
                }
            }
            throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
        }
    }
}

