/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.Bindings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.planprotos.PRecordQueryMapPlan;
import com.apple.foundationdb.record.planprotos.PRecordQueryPlan;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.FinalMemoizer;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.apple.foundationdb.record.query.plan.cascades.explain.ExplainPlanVisitor;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithChild;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class RecordQueryMapPlan
extends AbstractRelationalExpressionWithChildren
implements RecordQueryPlanWithChild {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Record-Query-Map-Plan");
    @Nonnull
    private final Quantifier.Physical inner;
    @Nonnull
    private final Value resultValue;

    public RecordQueryMapPlan(@Nonnull Quantifier.Physical inner, @Nonnull Value resultValue) {
        this.inner = inner;
        this.resultValue = resultValue;
    }

    @Override
    @Nonnull
    public <M extends Message> RecordCursor<QueryResult> executePlan(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        return this.getChild().executePlan(store, context, continuation, executeProperties).map(innerResult -> {
            EvaluationContext nestedContext = context.withBinding(Bindings.Internal.CORRELATION, this.inner.getAlias(), innerResult);
            return innerResult.withComputed(this.resultValue.eval(store, nestedContext));
        });
    }

    @Override
    public RecordQueryPlan getChild() {
        return this.inner.getRangesOverPlan();
    }

    @Override
    @Nonnull
    public RecordQueryPlanWithChild withChild(@Nonnull Reference childRef) {
        return new RecordQueryMapPlan(Quantifier.physical(childRef, this.inner.getAlias()), this.resultValue);
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        return this.resultValue.getCorrelatedTo();
    }

    @Override
    @Nonnull
    public RecordQueryMapPlan translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        Verify.verify(translatedQuantifiers.size() == 1);
        Value translatedResultValue = this.resultValue.translateCorrelations(translationMap, shouldSimplifyValues);
        return new RecordQueryMapPlan(Iterables.getOnlyElement(translatedQuantifiers).narrow(Quantifier.Physical.class), translatedResultValue);
    }

    @Override
    public boolean isReverse() {
        return this.getChild().isReverse();
    }

    @Override
    public boolean isStrictlySorted() {
        return false;
    }

    @Override
    public RecordQueryMapPlan strictlySorted(@Nonnull FinalMemoizer memoizer) {
        return this;
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        return this.resultValue;
    }

    @Nonnull
    public String toString() {
        return ExplainPlanVisitor.toStringForDebugging(this);
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap aliasMap) {
        if (this == otherExpression) {
            return true;
        }
        if (this.getClass() != otherExpression.getClass()) {
            return false;
        }
        return this.semanticEqualsForResults(otherExpression, aliasMap);
    }

    public boolean equals(Object other) {
        return this.structuralEquals(other);
    }

    public int hashCode() {
        return this.structuralHashCode();
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return Objects.hash(this.getResultValue());
    }

    @Override
    public void logPlanStructure(StoreTimer timer) {
    }

    @Override
    public int getComplexity() {
        return this.getChild().getComplexity();
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: 
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.getChild(), this.getResultValue());
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    @Override
    @Nonnull
    public List<? extends Quantifier> getQuantifiers() {
        return ImmutableList.of(this.inner);
    }

    @Nonnull
    public Quantifier.Physical getInner() {
        return this.inner;
    }

    @Override
    @Nonnull
    public PlannerGraph rewritePlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        return PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.OperatorNodeWithInfo(this, NodeInfo.VALUE_COMPUTATION_OPERATOR, ImmutableList.of("MAP {{expr}}"), ImmutableMap.of("expr", Attribute.gml(this.getResultValue().toString()))), childGraphs);
    }

    @Override
    @Nonnull
    public PRecordQueryMapPlan toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryMapPlan.newBuilder().setInner(this.inner.toProto(serializationContext)).setResultValue(this.resultValue.toValueProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PRecordQueryPlan toRecordQueryPlanProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryPlan.newBuilder().setMapPlan(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static RecordQueryMapPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryMapPlan mapPlanProto) {
        return new RecordQueryMapPlan(Quantifier.Physical.fromProto(serializationContext, Objects.requireNonNull(mapPlanProto.getInner())), Value.fromValueProto(serializationContext, Objects.requireNonNull(mapPlanProto.getResultValue())));
    }

    public static class Deserializer
    implements PlanDeserializer<PRecordQueryMapPlan, RecordQueryMapPlan> {
        @Override
        @Nonnull
        public Class<PRecordQueryMapPlan> getProtoMessageClass() {
            return PRecordQueryMapPlan.class;
        }

        @Override
        @Nonnull
        public RecordQueryMapPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryMapPlan recordQueryMapPlanProto) {
            return RecordQueryMapPlan.fromProto(serializationContext, recordQueryMapPlanProto);
        }
    }
}

