/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.EvaluationContextBuilder;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.planprotos.PRecordQueryMultiIntersectionOnValuesPlan;
import com.apple.foundationdb.record.planprotos.PRecordQueryPlan;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.cursors.IntersectionMultiCursor;
import com.apple.foundationdb.record.query.plan.HeuristicPlanner;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.FinalMemoizer;
import com.apple.foundationdb.record.query.plan.cascades.OrderingPart;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifiers;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIntersectionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithComparisonKeyValues;
import com.apple.foundationdb.record.query.plan.plans.RecordQuerySetPlan;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RecordQueryMultiIntersectionOnValuesPlan
extends RecordQueryIntersectionPlan
implements RecordQueryPlanWithComparisonKeyValues {
    @Nullable
    private final List<OrderingPart.ProvidedOrderingPart> comparisonKeyOrderingParts;
    @Nonnull
    private final Value resultValue;

    protected RecordQueryMultiIntersectionOnValuesPlan(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryMultiIntersectionOnValuesPlan recordQueryMultiIntersectionOnValuesPlanProto) {
        super(serializationContext, Objects.requireNonNull(recordQueryMultiIntersectionOnValuesPlanProto.getSuper()));
        this.comparisonKeyOrderingParts = null;
        this.resultValue = Value.fromValueProto(serializationContext, recordQueryMultiIntersectionOnValuesPlanProto.getResultValue());
    }

    private RecordQueryMultiIntersectionOnValuesPlan(@Nonnull List<Quantifier.Physical> quantifiers, @Nullable List<OrderingPart.ProvidedOrderingPart> comparisonKeyOrderingParts, @Nonnull List<? extends Value> comparisonKeyValues, @Nonnull Value resultValue, boolean reverse) {
        super(quantifiers, new RecordQuerySetPlan.ComparisonKeyFunction.OnValues(Quantifier.current(), comparisonKeyValues), reverse);
        this.comparisonKeyOrderingParts = comparisonKeyOrderingParts == null ? null : ImmutableList.copyOf(comparisonKeyOrderingParts);
        this.resultValue = resultValue;
    }

    @Override
    @Nonnull
    public RecordQuerySetPlan.ComparisonKeyFunction.OnValues getComparisonKeyFunction() {
        return (RecordQuerySetPlan.ComparisonKeyFunction.OnValues)super.getComparisonKeyFunction();
    }

    @Override
    @Nonnull
    public List<? extends Value> getRequiredValues(@Nonnull CorrelationIdentifier newBaseAlias, @Nonnull Type inputType) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    @HeuristicPlanner
    public Set<KeyExpression> getRequiredFields() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public List<OrderingPart.ProvidedOrderingPart> getComparisonKeyOrderingParts() {
        return Objects.requireNonNull(this.comparisonKeyOrderingParts);
    }

    @Override
    @Nonnull
    public List<? extends Value> getComparisonKeyValues() {
        return this.getComparisonKeyFunction().getComparisonKeyValues();
    }

    @Override
    @Nonnull
    public Set<Type> getDynamicTypes() {
        return Streams.concat(this.getComparisonKeyValues().stream(), Stream.of(this.resultValue)).flatMap(comparisonKeyValue -> comparisonKeyValue.getDynamicTypes().stream()).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    @Nonnull
    protected Value computeResultValue() {
        return this.resultValue;
    }

    @Override
    @Nonnull
    public <M extends Message> RecordCursor<QueryResult> executePlan(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        List<? extends Quantifier> quantifiers = this.getQuantifiers();
        ExecuteProperties childExecuteProperties = executeProperties.clearSkipAndLimit();
        return IntersectionMultiCursor.create(this.getComparisonKeyFunction().apply(store, context), this.reverse, quantifiers.stream().map(physical -> ((Quantifier.Physical)physical).getRangesOverPlan()).map(childPlan -> childContinuation -> childPlan.executePlan(store, context, (byte[])childContinuation, childExecuteProperties)).collect(ImmutableList.toImmutableList()), continuation, store.getTimer()).map(multiResult -> {
            Verify.verify(this.getQuantifiers().size() == multiResult.size());
            EvaluationContextBuilder childEvaluationContextBuilder = context.childBuilder();
            for (int i = 0; i < quantifiers.size(); ++i) {
                childEvaluationContextBuilder.setBinding(((Quantifier)quantifiers.get(i)).getAlias(), multiResult.get(i));
            }
            EvaluationContext childEvaluationContext = childEvaluationContextBuilder.build(context.getTypeRepository());
            return QueryResult.ofComputed(this.getResultValue().eval(store, childEvaluationContext));
        }).skipThenLimit(executeProperties.getSkip(), executeProperties.getReturnedRowLimit());
    }

    @Override
    @Nonnull
    public RecordQueryMultiIntersectionOnValuesPlan translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        return new RecordQueryMultiIntersectionOnValuesPlan(Quantifiers.narrow(Quantifier.Physical.class, translatedQuantifiers), this.comparisonKeyOrderingParts, this.getComparisonKeyValues(), this.resultValue, this.isReverse());
    }

    @Override
    @Nonnull
    public RecordQueryMultiIntersectionOnValuesPlan withChildrenReferences(@Nonnull List<? extends Reference> newChildren) {
        return new RecordQueryMultiIntersectionOnValuesPlan(newChildren.stream().map(Quantifier::physical).collect(ImmutableList.toImmutableList()), this.comparisonKeyOrderingParts, this.getComparisonKeyValues(), this.resultValue, this.isReverse());
    }

    @Override
    @HeuristicPlanner
    public RecordQueryMultiIntersectionOnValuesPlan strictlySorted(@Nonnull FinalMemoizer finalMemoizer) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public PRecordQueryMultiIntersectionOnValuesPlan toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryMultiIntersectionOnValuesPlan.newBuilder().setSuper(this.toRecordQueryIntersectionPlan(serializationContext)).setResultValue(this.resultValue.toValueProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PRecordQueryPlan toRecordQueryPlanProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryPlan.newBuilder().setMultiIntersectionOnValuesPlan(this.toProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PlannerGraph rewritePlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        return PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.OperatorNodeWithInfo(this, NodeInfo.INTERSECTION_OPERATOR, ImmutableList.of("COMPARE BY {{comparisonKeyFunction}}", "RESULT {{resultValue}}"), ImmutableMap.of("comparisonKeyFunction", Attribute.gml(this.getComparisonKeyFunction().toString()), "resultValue", Attribute.gml(this.resultValue.toString()))), childGraphs);
    }

    @Nonnull
    public static RecordQueryMultiIntersectionOnValuesPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryMultiIntersectionOnValuesPlan recordQueryMultiIntersectionOnValuesPlanProto) {
        return new RecordQueryMultiIntersectionOnValuesPlan(serializationContext, recordQueryMultiIntersectionOnValuesPlanProto);
    }

    @Nonnull
    public static RecordQueryMultiIntersectionOnValuesPlan intersection(@Nonnull List<Quantifier.Physical> quantifiers, @Nonnull List<OrderingPart.ProvidedOrderingPart> comparisonKeyOrderingParts, @Nonnull Value resultValue, boolean isReverse) {
        return new RecordQueryMultiIntersectionOnValuesPlan(quantifiers, comparisonKeyOrderingParts, OrderingPart.ProvidedOrderingPart.comparisonKeyValues(comparisonKeyOrderingParts, isReverse), resultValue, isReverse);
    }

    public static class Deserializer
    implements PlanDeserializer<PRecordQueryMultiIntersectionOnValuesPlan, RecordQueryMultiIntersectionOnValuesPlan> {
        @Override
        @Nonnull
        public Class<PRecordQueryMultiIntersectionOnValuesPlan> getProtoMessageClass() {
            return PRecordQueryMultiIntersectionOnValuesPlan.class;
        }

        @Override
        @Nonnull
        public RecordQueryMultiIntersectionOnValuesPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryMultiIntersectionOnValuesPlan recordQueryMultiIntersectionOnValuesPlanProto) {
            return RecordQueryMultiIntersectionOnValuesPlan.fromProto(serializationContext, recordQueryMultiIntersectionOnValuesPlanProto);
        }
    }
}

