/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.GenerateVisitor;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.PlanSerializable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.planprotos.PRecordQueryPlan;
import com.apple.foundationdb.record.provider.foundationdb.FDBQueriedRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.combinatorics.PartiallyOrderedSet;
import com.apple.foundationdb.record.query.combinatorics.TopologicalSort;
import com.apple.foundationdb.record.query.plan.AvailableFields;
import com.apple.foundationdb.record.query.plan.HeuristicPlanner;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.FinalMemoizer;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifiers;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraphRewritable;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.properties.ReferencesAndDependenciesProperty;
import com.apple.foundationdb.record.query.plan.plans.QueryPlan;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.record.query.plan.serialization.PlanSerialization;
import com.apple.foundationdb.record.query.plan.visitor.RecordQueryPlannerSubstitutionVisitor;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.protobuf.Message;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
@GenerateVisitor(stripPrefix="RecordQuery")
public interface RecordQueryPlan
extends QueryPlan<FDBQueriedRecord<Message>>,
PlannerGraphRewritable,
PlanSerializable {
    @Nonnull
    default public <M extends Message> RecordCursor<FDBQueriedRecord<M>> execute(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        return this.executePlan(store, context, continuation, executeProperties).map(QueryResult::getQueriedRecord);
    }

    @Override
    @Nonnull
    default public RecordCursor<FDBQueriedRecord<Message>> execute(@Nonnull FDBRecordStore store, @Nonnull EvaluationContext context, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        return this.execute((FDBRecordStoreBase)store, context, continuation, executeProperties);
    }

    @Nonnull
    default public <M extends Message> RecordCursor<FDBQueriedRecord<M>> execute(@Nonnull FDBRecordStoreBase<M> store) {
        return this.execute(store, EvaluationContext.EMPTY);
    }

    @Nonnull
    default public <M extends Message> RecordCursor<FDBQueriedRecord<M>> execute(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        return this.execute(store, context, null, ExecuteProperties.SERIAL_EXECUTE);
    }

    @Nonnull
    @API(value=API.Status.EXPERIMENTAL)
    public <M extends Message> RecordCursor<QueryResult> executePlan(@Nonnull FDBRecordStoreBase<M> var1, @Nonnull EvaluationContext var2, @Nullable byte[] var3, @Nonnull ExecuteProperties var4);

    @Nonnull
    @API(value=API.Status.UNSTABLE)
    public List<RecordQueryPlan> getChildren();

    @Override
    @Nonnull
    default public List<? extends QueryPlan<?>> getQueryPlanChildren() {
        return this.getChildren();
    }

    @Nonnull
    public AvailableFields getAvailableFields();

    default public RecordQueryPlan strictlySorted(@Nonnull FinalMemoizer memoizer) {
        return this;
    }

    default public boolean canBeMinimized() {
        return false;
    }

    @Nonnull
    default public RecordQueryPlan minimize() {
        PartiallyOrderedSet<Reference> referenceDependencyOrder = ReferencesAndDependenciesProperty.referencesAndDependencies().evaluate(this);
        List<Reference> references = TopologicalSort.anyTopologicalOrderPermutation(referenceDependencyOrder).orElseThrow(() -> new RecordCoreException("graph has cycles", new Object[0]));
        IdentityHashMap<Reference, Reference> minimizationCache = Maps.newIdentityHashMap();
        for (Reference reference : references) {
            RecordQueryPlan plan = reference.getOnlyElementAsPlan();
            RecordQueryPlan minimizedPlan = RecordQueryPlan.minimizePlanOverMinimizedReferences(minimizationCache, reference.getOnlyElementAsPlan());
            if (minimizedPlan == plan) continue;
            minimizationCache.put(reference, Reference.plannedOf(minimizedPlan));
        }
        return RecordQueryPlan.minimizePlanOverMinimizedReferences(minimizationCache, this);
    }

    @Nonnull
    default public RecordQueryPlan minimize(@Nonnull List<Quantifier.Physical> newQuantifiers) {
        throw new UnsupportedOperationException("RecordQueryPlan by default cannot be minimized");
    }

    @Nonnull
    private static RecordQueryPlan minimizePlanOverMinimizedReferences(@Nonnull Map<Reference, Reference> minimizationCache, @Nonnull RecordQueryPlan plan) {
        boolean allMinimizedChildrenSame = true;
        ImmutableList.Builder newQuantifiersBuilder = ImmutableList.builder();
        for (Quantifier quantifier : plan.getQuantifiers()) {
            Quantifier.Physical physicalQuantifier = quantifier.narrow(Quantifier.Physical.class);
            Reference childReference = physicalQuantifier.getRangesOver();
            Reference translatedChildReference = minimizationCache.get(childReference);
            if (translatedChildReference != null) {
                newQuantifiersBuilder.add(physicalQuantifier.overNewReference(translatedChildReference));
                allMinimizedChildrenSame = false;
                continue;
            }
            newQuantifiersBuilder.add(physicalQuantifier);
        }
        if (plan.canBeMinimized()) {
            return plan.minimize((List<Quantifier.Physical>)((Object)newQuantifiersBuilder.build()));
        }
        if (allMinimizedChildrenSame) {
            return plan;
        }
        return (RecordQueryPlan)plan.withQuantifiers((List<? extends Quantifier>)((Object)newQuantifiersBuilder.build()));
    }

    @Nonnull
    @HeuristicPlanner
    default public RecordQueryPlan accept(@Nonnull RecordQueryPlannerSubstitutionVisitor visitor) {
        for (Quantifier quantifier : this.getQuantifiers()) {
            RecordQueryPlan modifiedChild;
            if (!(quantifier instanceof Quantifier.Physical)) {
                throw new RecordCoreException("quantifiers of RecordQueryPlans must be physical", new Object[0]);
            }
            Reference childGroup = quantifier.getRangesOver();
            RecordQueryPlan child = childGroup.getOnlyElementAsPlan();
            if (child == (modifiedChild = child.accept(visitor))) continue;
            childGroup.replace(modifiedChild);
        }
        return visitor.postVisit(this);
    }

    @API(value=API.Status.EXPERIMENTAL)
    default public int structuralHashCode() {
        return Objects.hash(this.getQuantifiers(), this.hashCodeWithoutChildren());
    }

    @API(value=API.Status.EXPERIMENTAL)
    default public boolean structuralEquals(@Nullable Object other) {
        return this.structuralEquals(other, AliasMap.emptyMap());
    }

    @API(value=API.Status.EXPERIMENTAL)
    default public boolean structuralEquals(@Nullable Object other, @Nonnull AliasMap equivalenceMap) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        RelationalExpression otherExpression = (RelationalExpression)other;
        Verify.verify(this.canCorrelate() == otherExpression.canCorrelate());
        List<Quantifier.Physical> quantifiers = Quantifiers.narrow(Quantifier.Physical.class, this.getQuantifiers());
        List<Quantifier.Physical> otherQuantifiers = Quantifiers.narrow(Quantifier.Physical.class, otherExpression.getQuantifiers());
        if (quantifiers.size() != otherQuantifiers.size()) {
            return false;
        }
        Iterable<AliasMap> boundCorrelatedReferencesIterable = this.enumerateUnboundCorrelatedTo(equivalenceMap, otherExpression);
        for (AliasMap boundCorrelatedReferencesMap : boundCorrelatedReferencesIterable) {
            int i;
            AliasMap.Builder boundCorrelatedToBuilder = boundCorrelatedReferencesMap.toBuilder();
            for (i = 0; i < quantifiers.size(); ++i) {
                AliasMap boundCorrelatedToMap = boundCorrelatedToBuilder.build();
                Quantifier.Physical quantifier = quantifiers.get(i);
                Quantifier.Physical otherQuantifier = otherQuantifiers.get(i);
                if (quantifier.structuralHashCode() != otherQuantifier.structuralHashCode() || !quantifier.structuralEquals(otherQuantifier, boundCorrelatedToMap)) break;
                boundCorrelatedToBuilder.put(quantifier.getAlias(), otherQuantifier.getAlias());
            }
            if (i != quantifiers.size() || !this.equalsWithoutChildren(otherExpression, boundCorrelatedToBuilder.build())) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public Message toProto(@Nonnull PlanSerializationContext var1);

    @Nonnull
    public PRecordQueryPlan toRecordQueryPlanProto(@Nonnull PlanSerializationContext var1);

    @Nonnull
    public static RecordQueryPlan fromRecordQueryPlanProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryPlan recordQueryPlanProto) {
        return (RecordQueryPlan)PlanSerialization.dispatchFromProtoContainer(serializationContext, recordQueryPlanProto);
    }
}

