/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpressionWithChildren;
import com.apple.foundationdb.record.query.plan.plans.QueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public interface RecordQueryPlanWithChildren
extends RecordQueryPlan,
RelationalExpressionWithChildren {
    @Override
    default public boolean hasRecordScan() {
        return this.getChildren().stream().anyMatch(QueryPlan::hasRecordScan);
    }

    @Override
    default public boolean hasFullRecordScan() {
        return this.getChildren().stream().anyMatch(QueryPlan::hasFullRecordScan);
    }

    @Override
    default public boolean hasIndexScan(@Nonnull String indexName) {
        return this.getChildren().stream().anyMatch(p -> p.hasIndexScan(indexName));
    }

    @Override
    @Nonnull
    default public Set<String> getUsedIndexes() {
        HashSet<String> result = new HashSet<String>();
        for (RecordQueryPlan child : this.getChildren()) {
            result.addAll(child.getUsedIndexes());
        }
        return result;
    }

    @Override
    default public boolean hasLoadBykeys() {
        return this.getChildren().stream().anyMatch(QueryPlan::hasLoadBykeys);
    }
}

