/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.ScanComparisons;
import com.apple.foundationdb.record.query.plan.cascades.ComparisonRanges;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public interface RecordQueryPlanWithComparisons
extends RecordQueryPlan {
    default public boolean hasComparisons() {
        return this.hasComparisonRanges() || this.hasScanComparisons();
    }

    default public Set<Comparisons.Comparison> getComparisons() {
        Preconditions.checkArgument(this.hasComparisonRanges() || this.hasScanComparisons());
        if (this.hasComparisonRanges()) {
            ComparisonRanges comparisonRanges = this.getComparisonRanges();
            ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
            comparisonRanges.getRanges().forEach(comparisonRange -> {
                if (comparisonRange.isEquality()) {
                    resultBuilder.add(comparisonRange.getEqualityComparison());
                } else if (comparisonRange.isInequality()) {
                    resultBuilder.addAll(comparisonRange.getInequalityComparisons());
                }
            });
            return resultBuilder.build();
        }
        ScanComparisons scanComparisons = this.getScanComparisons();
        return ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(scanComparisons.getEqualityComparisons())).addAll(scanComparisons.getInequalityComparisons())).build();
    }

    @Nonnull
    public ScanComparisons getScanComparisons();

    default public boolean hasScanComparisons() {
        return true;
    }

    @Nonnull
    public ComparisonRanges getComparisonRanges();

    default public boolean hasComparisonRanges() {
        return true;
    }
}

