/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.IndexScanType;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.provider.foundationdb.FDBQueriedRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.FinalMemoizer;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFetchFromPartialRecordPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithMatchCandidate;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public interface RecordQueryPlanWithIndex
extends RecordQueryPlan,
RecordQueryPlanWithMatchCandidate {
    @Nonnull
    public String getIndexName();

    @Nonnull
    public IndexScanType getScanType();

    @Override
    @Nonnull
    public RecordQueryPlanWithIndex translateCorrelations(@Nonnull TranslationMap var1, boolean var2, @Nonnull List<? extends Quantifier> var3);

    @Nonnull
    public <M extends Message> RecordCursor<IndexEntry> executeEntries(@Nonnull FDBRecordStoreBase<M> var1, @Nonnull EvaluationContext var2, @Nullable byte[] var3, @Nonnull ExecuteProperties var4);

    @Override
    @Nonnull
    default public <M extends Message> RecordCursor<QueryResult> executePlan(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext evaluationContext, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        Function<byte[], RecordCursor<IndexEntry>> entryCursorFunction = nestedContinuation -> this.executeEntries(store, evaluationContext, (byte[])nestedContinuation, executeProperties);
        return this.fetchIndexRecords(store, evaluationContext, entryCursorFunction, continuation, executeProperties).map(QueryResult::fromQueriedRecord);
    }

    @Nonnull
    default public <M extends Message> RecordCursor<FDBQueriedRecord<M>> fetchIndexRecords(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext evaluationContext, @Nonnull Function<byte[], RecordCursor<IndexEntry>> entryCursorFunction, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        return this.getFetchIndexRecords().fetchIndexRecords(store, entryCursorFunction.apply(continuation), executeProperties);
    }

    @Nonnull
    public RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords getFetchIndexRecords();

    @Override
    default public RecordQueryPlanWithIndex strictlySorted(@Nonnull FinalMemoizer memoizer) {
        return this;
    }

    @Override
    @Nonnull
    default public PlannerGraph rewritePlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        Verify.verify(childGraphs.isEmpty());
        return this.createIndexPlannerGraph(this, NodeInfo.INDEX_SCAN_OPERATOR, ImmutableList.of(), ImmutableMap.of());
    }

    @Nonnull
    public PlannerGraph createIndexPlannerGraph(@Nonnull RecordQueryPlan var1, @Nonnull NodeInfo var2, @Nonnull List<String> var3, @Nonnull Map<String, Attribute> var4);

    default public boolean allowedForCoveringIndexPlan() {
        return true;
    }
}

