/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.Bindings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PRecordQueryPlan;
import com.apple.foundationdb.record.planprotos.PRecordQueryPredicatesFilterPlan;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.expressions.AsyncBoolean;
import com.apple.foundationdb.record.query.plan.AvailableFields;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.apple.foundationdb.record.query.plan.cascades.explain.ExplainPlanVisitor;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpressionWithPredicates;
import com.apple.foundationdb.record.query.plan.cascades.predicates.AndPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFilterPlanBase;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithChild;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class RecordQueryPredicatesFilterPlan
extends RecordQueryFilterPlanBase
implements RelationalExpressionWithPredicates {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Record-Query-Predicate-Filter-Plan");
    @Nonnull
    private final List<QueryPredicate> predicates;
    @Nonnull
    private final QueryPredicate conjunctedPredicate;

    protected RecordQueryPredicatesFilterPlan(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryPredicatesFilterPlan recordQueryPredicatesFilterPlanProto) {
        super(serializationContext, Objects.requireNonNull(recordQueryPredicatesFilterPlanProto.getSuper()));
        ImmutableList.Builder predicatesBuilder = ImmutableList.builder();
        for (int i = 0; i < recordQueryPredicatesFilterPlanProto.getPredicatesCount(); ++i) {
            predicatesBuilder.add(QueryPredicate.fromQueryPredicateProto(serializationContext, recordQueryPredicatesFilterPlanProto.getPredicates(i)));
        }
        this.predicates = predicatesBuilder.build();
        this.conjunctedPredicate = AndPredicate.and(this.predicates);
    }

    public RecordQueryPredicatesFilterPlan(@Nonnull Quantifier.Physical inner, @Nonnull Iterable<? extends QueryPredicate> predicates) {
        super(inner);
        this.predicates = ImmutableList.copyOf(predicates);
        this.conjunctedPredicate = AndPredicate.and(this.predicates);
    }

    @Override
    @Nonnull
    public List<? extends QueryPredicate> getPredicates() {
        return this.predicates;
    }

    @Nonnull
    public QueryPredicate getConjunctedPredicate() {
        return this.conjunctedPredicate;
    }

    @Override
    protected boolean hasAsyncFilter() {
        return false;
    }

    @Override
    @Nullable
    protected <M extends Message> Boolean evalFilter(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nonnull QueryResult queryResult) {
        EvaluationContext nestedContext = context.withBinding(Bindings.Internal.CORRELATION, this.getInner().getAlias(), queryResult);
        return this.conjunctedPredicate.eval(store, nestedContext);
    }

    @Override
    @Nullable
    protected <M extends Message> CompletableFuture<Boolean> evalFilterAsync(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nonnull QueryResult queryResult) {
        EvaluationContext nestedContext = context.withBinding(Bindings.Internal.CORRELATION, this.getInner().getAlias(), queryResult);
        return new AsyncBoolean<M, QueryPredicate>(false, this.getPredicates(), predicate -> CompletableFuture.completedFuture(predicate.eval(store, nestedContext)), store).eval();
    }

    @Override
    @Nonnull
    public AvailableFields getAvailableFields() {
        return AvailableFields.ALL_FIELDS;
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        return this.predicates.stream().flatMap(queryPredicate -> queryPredicate.getCorrelatedTo().stream()).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    @Nonnull
    public RecordQueryPredicatesFilterPlan translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        ImmutableList translatedPredicates = this.predicates.stream().map(queryPredicate -> queryPredicate.translateCorrelations(translationMap, shouldSimplifyValues)).collect(ImmutableList.toImmutableList());
        return new RecordQueryPredicatesFilterPlan(Iterables.getOnlyElement(translatedQuantifiers).narrow(Quantifier.Physical.class), translatedPredicates);
    }

    @Override
    @Nonnull
    public RecordQueryPlanWithChild withChild(@Nonnull Reference childRef) {
        return new RecordQueryPredicatesFilterPlan(Quantifier.physical(childRef, this.getInner().getAlias()), this.getPredicates());
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        return this.getInner().getFlowedObjectValue();
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap equivalencesMap) {
        if (this == otherExpression) {
            return true;
        }
        if (this.getClass() != otherExpression.getClass()) {
            return false;
        }
        RecordQueryPredicatesFilterPlan otherPlan = (RecordQueryPredicatesFilterPlan)otherExpression;
        List<? extends QueryPredicate> otherPredicates = otherPlan.getPredicates();
        if (this.predicates.size() != otherPredicates.size()) {
            return false;
        }
        return Streams.zip(this.predicates.stream(), otherPredicates.stream(), (queryPredicate, otherQueryPredicate) -> queryPredicate.semanticEquals(otherQueryPredicate, equivalencesMap)).allMatch(isSame -> isSame);
    }

    @Nonnull
    public String toString() {
        return ExplainPlanVisitor.toStringForDebugging(this);
    }

    public boolean equals(Object other) {
        return this.structuralEquals(other);
    }

    public int hashCode() {
        return this.structuralHashCode();
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return Objects.hash(this.conjunctedPredicate);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: {
                return this.getInnerPlan().planHash(mode) + this.conjunctedPredicate.planHash(mode);
            }
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.getInnerPlan(), this.conjunctedPredicate);
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    @Override
    @Nonnull
    public PlannerGraph rewritePlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        return PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.OperatorNodeWithInfo(this, NodeInfo.PREDICATE_FILTER_OPERATOR, ImmutableList.of("WHERE {{pred}}"), ImmutableMap.of("pred", Attribute.gml(this.conjunctedPredicate.toString()))), childGraphs);
    }

    @Override
    @Nonnull
    public PRecordQueryPredicatesFilterPlan toProto(@Nonnull PlanSerializationContext serializationContext) {
        PRecordQueryPredicatesFilterPlan.Builder builder = PRecordQueryPredicatesFilterPlan.newBuilder().setSuper(this.toRecordQueryFilterPlanBaseProto(serializationContext));
        for (QueryPredicate predicate : this.predicates) {
            builder.addPredicates(predicate.toQueryPredicateProto(serializationContext));
        }
        return builder.build();
    }

    @Override
    @Nonnull
    public PRecordQueryPlan toRecordQueryPlanProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryPlan.newBuilder().setPredicatesFilterPlan(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static RecordQueryPredicatesFilterPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryPredicatesFilterPlan recordQueryPredicatesFilterPlanProto) {
        return new RecordQueryPredicatesFilterPlan(serializationContext, recordQueryPredicatesFilterPlanProto);
    }

    public static class Deserializer
    implements PlanDeserializer<PRecordQueryPredicatesFilterPlan, RecordQueryPredicatesFilterPlan> {
        @Override
        @Nonnull
        public Class<PRecordQueryPredicatesFilterPlan> getProtoMessageClass() {
            return PRecordQueryPredicatesFilterPlan.class;
        }

        @Override
        @Nonnull
        public RecordQueryPredicatesFilterPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryPredicatesFilterPlan recordQueryPredicatesFilterPlanProto) {
            return RecordQueryPredicatesFilterPlan.fromProto(serializationContext, recordQueryPredicatesFilterPlanProto);
        }
    }
}

