/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.cursors.RangeCursor;
import com.apple.foundationdb.record.planprotos.PRecordQueryPlan;
import com.apple.foundationdb.record.planprotos.PRecordQueryRangePlan;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.AvailableFields;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.FinalMemoizer;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.apple.foundationdb.record.query.plan.cascades.explain.ExplainPlanVisitor;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithoutChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.QueriedValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithNoChildren;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class RecordQueryRangePlan
extends AbstractRelationalExpressionWithoutChildren
implements RecordQueryPlanWithNoChildren {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Record-Query-Range-Plan");
    private final Value exclusiveLimitValue;

    public RecordQueryRangePlan(Value exclusiveLimitValue) {
        this.exclusiveLimitValue = exclusiveLimitValue;
    }

    public Value getExclusiveLimitValue() {
        return this.exclusiveLimitValue;
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        return new QueriedValue(Type.primitiveType(Type.TypeCode.INT));
    }

    @Override
    @Nonnull
    public <M extends Message> RecordCursor<QueryResult> executePlan(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        int exclusiveLimit = (Integer)Verify.verifyNotNull(this.exclusiveLimitValue.eval(store, context));
        return new RangeCursor(store.getExecutor(), exclusiveLimit, continuation).map(QueryResult::ofComputed);
    }

    @Override
    public boolean isReverse() {
        return false;
    }

    @Override
    public boolean hasRecordScan() {
        return false;
    }

    @Override
    public boolean hasFullRecordScan() {
        return false;
    }

    @Override
    public boolean hasIndexScan(@Nonnull String indexName) {
        return false;
    }

    @Override
    @Nonnull
    public Set<String> getUsedIndexes() {
        return ImmutableSet.of();
    }

    @Override
    public boolean isStrictlySorted() {
        return true;
    }

    @Override
    public RecordQueryRangePlan strictlySorted(@Nonnull FinalMemoizer memoizer) {
        return this;
    }

    @Override
    @Nonnull
    public AvailableFields getAvailableFields() {
        return AvailableFields.ALL_FIELDS;
    }

    @Override
    public boolean hasLoadBykeys() {
        return false;
    }

    @Nonnull
    public String toString() {
        return ExplainPlanVisitor.toStringForDebugging(this);
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        return this.exclusiveLimitValue.getCorrelatedTo();
    }

    @Override
    @Nonnull
    public RelationalExpression translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        Verify.verify(translatedQuantifiers.isEmpty());
        if (translationMap.definesOnlyIdentities()) {
            return this;
        }
        Value translatedExclusiveLimitValue = this.exclusiveLimitValue.translateCorrelations(translationMap, shouldSimplifyValues);
        if (translatedExclusiveLimitValue == this.exclusiveLimitValue) {
            return this;
        }
        return new RecordQueryRangePlan(translatedExclusiveLimitValue);
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap aliasMap) {
        if (this == otherExpression) {
            return true;
        }
        if (this.getClass() != otherExpression.getClass()) {
            return false;
        }
        RecordQueryRangePlan other = (RecordQueryRangePlan)otherExpression;
        return this.exclusiveLimitValue.semanticEquals((Object)other, aliasMap);
    }

    public boolean equals(Object other) {
        return this.structuralEquals(other);
    }

    public int hashCode() {
        return this.structuralHashCode();
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return Objects.hash(this.exclusiveLimitValue);
    }

    @Override
    public void logPlanStructure(StoreTimer timer) {
    }

    @Override
    public int getComplexity() {
        return 1;
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: 
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.exclusiveLimitValue);
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    @Override
    @Nonnull
    public List<? extends Quantifier> getQuantifiers() {
        return ImmutableList.of();
    }

    @Override
    @Nonnull
    public PlannerGraph rewritePlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        Verify.verify(childGraphs.isEmpty());
        PlannerGraph.DataNodeWithInfo dataNodeWithInfo = new PlannerGraph.DataNodeWithInfo(NodeInfo.TEMPORARY_BUFFER_DATA, this.exclusiveLimitValue.getResultType(), ImmutableList.of("range: 0 <= i < {{exclusiveLimit}}"), ImmutableMap.of("exclusiveLimit", Attribute.gml(this.exclusiveLimitValue)));
        return PlannerGraph.fromNodeAndChildGraphs(dataNodeWithInfo, childGraphs);
    }

    @Override
    @Nonnull
    public PRecordQueryRangePlan toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryRangePlan.newBuilder().setExclusiveLimitValue(this.exclusiveLimitValue.toValueProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PRecordQueryPlan toRecordQueryPlanProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryPlan.newBuilder().setRangePlan(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static RecordQueryRangePlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryRangePlan recordQueryRangePlanProto) {
        return new RecordQueryRangePlan(Value.fromValueProto(serializationContext, Objects.requireNonNull(recordQueryRangePlanProto.getExclusiveLimitValue())));
    }

    public static class Deserializer
    implements PlanDeserializer<PRecordQueryRangePlan, RecordQueryRangePlan> {
        @Override
        @Nonnull
        public Class<PRecordQueryRangePlan> getProtoMessageClass() {
            return PRecordQueryRangePlan.class;
        }

        @Override
        @Nonnull
        public RecordQueryRangePlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryRangePlan recordQueryRangePlanProto) {
            return RecordQueryRangePlan.fromProto(serializationContext, recordQueryRangePlanProto);
        }
    }
}

