/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.Bindings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.cursors.RecursiveCursor;
import com.apple.foundationdb.record.planprotos.PRecordQueryPlan;
import com.apple.foundationdb.record.planprotos.PRecordQueryRecursiveDfsJoinPlan;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.AvailableFields;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifiers;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.apple.foundationdb.record.query.plan.cascades.explain.ExplainPlanVisitor;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithChildren;
import com.apple.foundationdb.record.query.plan.plans.RecordQuerySetPlan;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class RecordQueryRecursiveDfsJoinPlan
extends AbstractRelationalExpressionWithChildren
implements RecordQueryPlanWithChildren {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Record-Query-Recursive-Plan");
    @Nonnull
    private final Quantifier.Physical rootQuantifier;
    @Nonnull
    private final Quantifier.Physical childQuantifier;
    @Nonnull
    private final CorrelationIdentifier priorValueCorrelation;
    @Nonnull
    private final Value resultValue;

    public RecordQueryRecursiveDfsJoinPlan(@Nonnull Quantifier.Physical rootQuantifier, @Nonnull Quantifier.Physical childQuantifier, @Nonnull CorrelationIdentifier priorValueCorrelation) {
        this.rootQuantifier = rootQuantifier;
        this.childQuantifier = childQuantifier;
        this.priorValueCorrelation = priorValueCorrelation;
        this.resultValue = RecordQuerySetPlan.mergeValues(ImmutableList.of(rootQuantifier, childQuantifier));
    }

    @Nonnull
    public Quantifier.Physical getRootQuantifier() {
        return this.rootQuantifier;
    }

    @Nonnull
    public Quantifier.Physical getChildQuantifier() {
        return this.childQuantifier;
    }

    @Override
    @Nonnull
    public <M extends Message> RecordCursor<QueryResult> executePlan(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        ExecuteProperties nestedExecuteProperties = executeProperties.clearSkipAndLimit();
        return RecursiveCursor.create(rootContinuation -> this.rootQuantifier.getRangesOverPlan().executePlan(store, context, (byte[])rootContinuation, nestedExecuteProperties), (parentResult, depth, innerContinuation) -> {
            EvaluationContext childContext = context.withBinding(Bindings.Internal.CORRELATION.bindingName(this.priorValueCorrelation.getId()), parentResult);
            return this.childQuantifier.getRangesOverPlan().executePlan(store, childContext, innerContinuation, nestedExecuteProperties);
        }, null, continuation).skipThenLimit(executeProperties.getSkip(), executeProperties.getReturnedRowLimit()).map(RecursiveCursor.RecursiveValue::getValue);
    }

    @Override
    public int getRelationalChildCount() {
        return 2;
    }

    @Override
    public boolean canCorrelate() {
        return true;
    }

    @Override
    @Nonnull
    public List<RecordQueryPlan> getChildren() {
        return ImmutableList.of(this.rootQuantifier.getRangesOverPlan(), this.childQuantifier.getRangesOverPlan());
    }

    @Override
    @Nonnull
    public AvailableFields getAvailableFields() {
        return AvailableFields.NO_FIELDS;
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedTo() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Streams.concat(this.rootQuantifier.getCorrelatedTo().stream(), this.childQuantifier.getCorrelatedTo().stream()).filter(alias -> !alias.equals(this.priorValueCorrelation)).forEach(builder::add);
        return builder.build();
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        return this.resultValue.getCorrelatedTo();
    }

    @Override
    public boolean isReverse() {
        return Quantifiers.isReversed(Quantifiers.narrow(Quantifier.Physical.class, this.getQuantifiers()));
    }

    @Override
    public boolean isStrictlySorted() {
        return true;
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        return this.resultValue;
    }

    @Nonnull
    public String toString() {
        return ExplainPlanVisitor.toStringForDebugging(this);
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap aliasMap) {
        if (this == otherExpression) {
            return true;
        }
        if (this.getClass() != otherExpression.getClass()) {
            return false;
        }
        return this.semanticEqualsForResults(otherExpression, aliasMap);
    }

    public boolean equals(Object other) {
        return this.structuralEquals(other);
    }

    @Override
    public boolean structuralEquals(@Nullable Object other, @Nonnull AliasMap equivalenceMap) {
        if (this == other) {
            return true;
        }
        if (other == null || other.getClass() != RecordQueryRecursiveDfsJoinPlan.class) {
            return false;
        }
        RecordQueryRecursiveDfsJoinPlan otherExpression = (RecordQueryRecursiveDfsJoinPlan)other;
        for (AliasMap boundCorrelatedReferencesMap : this.enumerateUnboundCorrelatedTo(equivalenceMap, otherExpression)) {
            AliasMap.Builder boundCorrelatedToBuilder = boundCorrelatedReferencesMap.toBuilder();
            boundCorrelatedToBuilder.put(this.getPriorValueCorrelation(), otherExpression.getPriorValueCorrelation());
            if (this.getRootQuantifier().structuralHashCode() != otherExpression.getRootQuantifier().structuralHashCode() || !this.getRootQuantifier().structuralEquals(otherExpression.getRootQuantifier(), boundCorrelatedToBuilder.build())) continue;
            boundCorrelatedToBuilder.put(this.getRootQuantifier().getAlias(), otherExpression.getRootQuantifier().getAlias());
            if (this.getChildQuantifier().structuralHashCode() != otherExpression.getChildQuantifier().structuralHashCode() || !this.getChildQuantifier().structuralEquals(otherExpression.getChildQuantifier(), boundCorrelatedToBuilder.build())) continue;
            boundCorrelatedToBuilder.put(this.getChildQuantifier().getAlias(), otherExpression.getChildQuantifier().getAlias());
            if (!this.equalsWithoutChildren(otherExpression, boundCorrelatedToBuilder.build())) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.structuralHashCode();
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return Objects.hash(this.getResultValue());
    }

    @Override
    @Nonnull
    public RelationalExpression translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        Verify.verify(translatedQuantifiers.size() == 2);
        Verify.verify(!translationMap.containsSourceAlias(this.priorValueCorrelation));
        return new RecordQueryRecursiveDfsJoinPlan(translatedQuantifiers.get(0).narrow(Quantifier.Physical.class), translatedQuantifiers.get(1).narrow(Quantifier.Physical.class), this.priorValueCorrelation);
    }

    @Override
    public void logPlanStructure(StoreTimer timer) {
    }

    @Override
    public int getComplexity() {
        return this.rootQuantifier.getRangesOverPlan().getComplexity() * this.childQuantifier.getRangesOverPlan().getComplexity();
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: 
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.getChildren(), this.getResultValue());
            }
        }
        throw new UnsupportedOperationException("Hash kind " + mode.name() + " is not supported");
    }

    @Override
    @Nonnull
    public List<? extends Quantifier> getQuantifiers() {
        return ImmutableList.of(this.rootQuantifier, this.childQuantifier);
    }

    @Override
    @Nonnull
    public PlannerGraph rewritePlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        return PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.OperatorNodeWithInfo(this, NodeInfo.NESTED_LOOP_JOIN_OPERATOR, ImmutableList.of("RECURSIVE {{expr}}"), ImmutableMap.of("expr", Attribute.gml(this.getResultValue().toString()))), childGraphs, this.getQuantifiers());
    }

    @Override
    @Nonnull
    public PRecordQueryRecursiveDfsJoinPlan toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryRecursiveDfsJoinPlan.newBuilder().setRootQuantifier(this.rootQuantifier.toProto(serializationContext)).setChildQuantifier(this.childQuantifier.toProto(serializationContext)).setPriorValueCorrelation(this.priorValueCorrelation.getId()).build();
    }

    @Override
    @Nonnull
    public PRecordQueryPlan toRecordQueryPlanProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryPlan.newBuilder().setRecursiveDfsJoinPlan(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static RecordQueryRecursiveDfsJoinPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryRecursiveDfsJoinPlan recordQueryRecursivePlanProto) {
        return new RecordQueryRecursiveDfsJoinPlan(Quantifier.Physical.fromProto(serializationContext, Objects.requireNonNull(recordQueryRecursivePlanProto.getRootQuantifier())), Quantifier.Physical.fromProto(serializationContext, Objects.requireNonNull(recordQueryRecursivePlanProto.getChildQuantifier())), CorrelationIdentifier.of(Objects.requireNonNull(recordQueryRecursivePlanProto.getPriorValueCorrelation())));
    }

    @Nonnull
    public CorrelationIdentifier getPriorValueCorrelation() {
        return this.priorValueCorrelation;
    }

    public static class Deserializer
    implements PlanDeserializer<PRecordQueryRecursiveDfsJoinPlan, RecordQueryRecursiveDfsJoinPlan> {
        @Override
        @Nonnull
        public Class<PRecordQueryRecursiveDfsJoinPlan> getProtoMessageClass() {
            return PRecordQueryRecursiveDfsJoinPlan.class;
        }

        @Override
        @Nonnull
        public RecordQueryRecursiveDfsJoinPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryRecursiveDfsJoinPlan recordQueryRecursivePlanProto) {
            return RecordQueryRecursiveDfsJoinPlan.fromProto(serializationContext, recordQueryRecursivePlanProto);
        }
    }
}

