/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.Bindings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.cursors.RecursiveUnionCursor;
import com.apple.foundationdb.record.planprotos.PRecordQueryPlan;
import com.apple.foundationdb.record.planprotos.PRecordQueryRecursiveLevelUnionPlan;
import com.apple.foundationdb.record.planprotos.PTempTable;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.query.plan.AvailableFields;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.TempTable;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.QueryPlan;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithChildren;
import com.apple.foundationdb.record.query.plan.plans.RecordQuerySetPlan;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class RecordQueryRecursiveLevelUnionPlan
extends AbstractRelationalExpressionWithChildren
implements RecordQueryPlanWithChildren {
    @Nonnull
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Recursive-Union-Query-Plan");
    @Nonnull
    private final Quantifier.Physical initialStateQuantifier;
    @Nonnull
    private final Quantifier.Physical recursiveStateQuantifier;
    @Nonnull
    private final CorrelationIdentifier tempTableScanAlias;
    @Nonnull
    private final CorrelationIdentifier tempTableInsertAlias;
    @Nonnull
    private final Value resultValue;
    @Nonnull
    private final Supplier<List<RecordQueryPlan>> computeChildren;
    @Nonnull
    private final Supplier<Integer> computeComplexitySupplier;

    public RecordQueryRecursiveLevelUnionPlan(@Nonnull Quantifier.Physical initialStateQuantifier, @Nonnull Quantifier.Physical recursiveStateQuantifier, @Nonnull CorrelationIdentifier tempTableScanAlias, @Nonnull CorrelationIdentifier tempTableInsertAlias) {
        this.initialStateQuantifier = initialStateQuantifier;
        this.recursiveStateQuantifier = recursiveStateQuantifier;
        this.tempTableScanAlias = tempTableScanAlias;
        this.tempTableInsertAlias = tempTableInsertAlias;
        this.resultValue = RecordQuerySetPlan.mergeValues(ImmutableList.of(initialStateQuantifier, recursiveStateQuantifier));
        this.computeChildren = Suppliers.memoize(this::computeChildren);
        this.computeComplexitySupplier = Suppliers.memoize(this::computeComplexity);
    }

    @Override
    public int getRelationalChildCount() {
        return 2;
    }

    @Nonnull
    private RecordQueryPlan getInitialStatePlan() {
        return this.initialStateQuantifier.getRangesOverPlan();
    }

    @Nonnull
    private RecordQueryPlan getRecursiveStatePlan() {
        return this.recursiveStateQuantifier.getRangesOverPlan();
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedTo() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Streams.concat(this.initialStateQuantifier.getCorrelatedTo().stream(), this.recursiveStateQuantifier.getCorrelatedTo().stream()).filter(alias -> !alias.equals(this.tempTableInsertAlias) && !alias.equals(this.tempTableScanAlias)).forEach(builder::add);
        return builder.build();
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        return ImmutableSet.of();
    }

    @Override
    @Nonnull
    public <M extends Message> RecordCursor<QueryResult> executePlan(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        Descriptors.Descriptor type = this.getInnerTypeDescriptor(context);
        ExecuteProperties childExecuteProperties = executeProperties.clearSkipAndLimit();
        RecursiveStateManagerImpl recursiveStateManager = new RecursiveStateManagerImpl((initialContinuation, evaluationContext) -> this.getInitialStatePlan().executePlan(store, (EvaluationContext)evaluationContext, initialContinuation == null ? null : initialContinuation.toByteArray(), childExecuteProperties), (recursiveContinuation, evaluationContext) -> this.getRecursiveStatePlan().executePlan(store, (EvaluationContext)evaluationContext, recursiveContinuation == null ? null : recursiveContinuation.toByteArray(), childExecuteProperties), context, this.tempTableScanAlias, this.tempTableInsertAlias, proto -> TempTable.from(proto, type), store.getContext().getTempTableFactory(), continuation);
        return new RecursiveUnionCursor<QueryResult>(recursiveStateManager, store.getExecutor()).skipThenLimit(executeProperties.getSkip(), executeProperties.getReturnedRowLimit());
    }

    @Nullable
    private Descriptors.Descriptor getInnerTypeDescriptor(@Nonnull EvaluationContext context) {
        Type innerType = this.getResultValue().getResultType();
        Descriptors.Descriptor typeDescriptor = Objects.requireNonNull(innerType).isRecord() ? context.getTypeRepository().getMessageDescriptor(innerType) : null;
        return typeDescriptor;
    }

    @Override
    @Nonnull
    public List<RecordQueryPlan> getChildren() {
        return this.computeChildren.get();
    }

    @Nonnull
    private List<RecordQueryPlan> computeChildren() {
        return ImmutableList.of(this.getInitialStatePlan(), this.getRecursiveStatePlan());
    }

    @Override
    @Nonnull
    public AvailableFields getAvailableFields() {
        return AvailableFields.ALL_FIELDS;
    }

    @Override
    @Nonnull
    public PRecordQueryRecursiveLevelUnionPlan toProto(@Nonnull PlanSerializationContext serializationContext) {
        PRecordQueryRecursiveLevelUnionPlan.Builder builder = PRecordQueryRecursiveLevelUnionPlan.newBuilder().setInitialStateQuantifier(this.initialStateQuantifier.toProto(serializationContext)).setRecursiveStateQuantifier(this.recursiveStateQuantifier.toProto(serializationContext)).setInitialTempTableAlias(this.tempTableScanAlias.getId()).setRecursiveTempTableAlias(this.tempTableInsertAlias.getId());
        return builder.build();
    }

    @Nonnull
    public static RecordQueryRecursiveLevelUnionPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryRecursiveLevelUnionPlan recordQueryUnorderedDistinctPlanProto) {
        Quantifier.Physical initialStateQuantifier = Quantifier.Physical.fromProto(serializationContext, recordQueryUnorderedDistinctPlanProto.getInitialStateQuantifier());
        Quantifier.Physical recursiveStateQuantifier = Quantifier.Physical.fromProto(serializationContext, recordQueryUnorderedDistinctPlanProto.getRecursiveStateQuantifier());
        return new RecordQueryRecursiveLevelUnionPlan(initialStateQuantifier, recursiveStateQuantifier, CorrelationIdentifier.of(recordQueryUnorderedDistinctPlanProto.getInitialTempTableAlias()), CorrelationIdentifier.of(recordQueryUnorderedDistinctPlanProto.getRecursiveTempTableAlias()));
    }

    @Override
    @Nonnull
    public PRecordQueryPlan toRecordQueryPlanProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryPlan.newBuilder().setRecursiveLevelUnionPlan(this.toProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PlannerGraph rewritePlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        return PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.OperatorNodeWithInfo(this, NodeInfo.RECURSIVE_UNION_OPERATOR), childGraphs);
    }

    @Override
    public boolean isReverse() {
        return false;
    }

    @Override
    public void logPlanStructure(StoreTimer timer) {
        timer.increment(FDBStoreTimer.Counts.PLAN_RECURSIVE_UNION);
        this.getInitialStatePlan().logPlanStructure(timer);
        this.getRecursiveStatePlan().logPlanStructure(timer);
    }

    @Override
    public int getComplexity() {
        return this.computeComplexitySupplier.get();
    }

    private int computeComplexity() {
        return 1 + this.getChildren().stream().map(QueryPlan::getComplexity).reduce(1, Integer::sum);
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        return this.resultValue;
    }

    @Override
    @Nonnull
    public List<? extends Quantifier> getQuantifiers() {
        return ImmutableList.of(this.initialStateQuantifier, this.recursiveStateQuantifier);
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap equivalences) {
        if (this == otherExpression) {
            return true;
        }
        if (!(otherExpression instanceof RecordQueryRecursiveLevelUnionPlan)) {
            return false;
        }
        RecordQueryRecursiveLevelUnionPlan otherRecursiveUnionQueryPlan = (RecordQueryRecursiveLevelUnionPlan)otherExpression;
        return this.tempTableScanAlias.equals(otherRecursiveUnionQueryPlan.tempTableScanAlias) && this.tempTableInsertAlias.equals(otherRecursiveUnionQueryPlan.tempTableInsertAlias);
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return Objects.hash(this.tempTableInsertAlias, this.tempTableInsertAlias);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode hashMode) {
        return PlanHashable.objectsPlanHash(hashMode, BASE_HASH, this.getChildren());
    }

    @Override
    @Nonnull
    public RelationalExpression translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        Verify.verify(translatedQuantifiers.size() == 2);
        Verify.verify(!translationMap.containsSourceAlias(this.tempTableScanAlias));
        Verify.verify(!translationMap.containsSourceAlias(this.tempTableInsertAlias));
        Quantifier.Physical translatedInitialQuantifier = translatedQuantifiers.get(0).narrow(Quantifier.Physical.class);
        Quantifier.Physical translatedRecursiveQuantifier = translatedQuantifiers.get(1).narrow(Quantifier.Physical.class);
        return new RecordQueryRecursiveLevelUnionPlan(translatedInitialQuantifier, translatedRecursiveQuantifier, this.tempTableScanAlias, this.tempTableInsertAlias);
    }

    @Nonnull
    public CorrelationIdentifier getTempTableScanAlias() {
        return this.tempTableScanAlias;
    }

    @Nonnull
    public CorrelationIdentifier getTempTableInsertAlias() {
        return this.tempTableInsertAlias;
    }

    private static final class RecursiveStateManagerImpl
    implements RecursiveUnionCursor.RecursiveStateManager<QueryResult> {
        private boolean isInitialState;
        @Nonnull
        private TempTable recursiveUnionTempTable;
        @Nonnull
        private final BiFunction<ByteString, EvaluationContext, RecordCursor<QueryResult>> recursiveCursorCreator;
        @Nonnull
        private final EvaluationContext baseContext;
        @Nonnull
        private final CorrelationIdentifier insertTempTableAlias;
        @Nonnull
        private final CorrelationIdentifier scanTempTableAlias;
        @Nonnull
        private RecordCursor<QueryResult> activeCursor;
        @Nonnull
        private EvaluationContext overridenEvaluationContext;

        RecursiveStateManagerImpl(@Nonnull BiFunction<ByteString, EvaluationContext, RecordCursor<QueryResult>> initialCursorCreator, @Nonnull BiFunction<ByteString, EvaluationContext, RecordCursor<QueryResult>> recursiveCursorCreator, @Nonnull EvaluationContext baseContext, @Nonnull CorrelationIdentifier scanTempTableAlias, @Nonnull CorrelationIdentifier insertTempTableAlias, @Nonnull Function<PTempTable, TempTable> tempTableDeserializer, @Nonnull TempTable.Factory tempTableFactory, @Nullable byte[] continuationBytes) {
            this.recursiveCursorCreator = recursiveCursorCreator;
            this.baseContext = baseContext;
            this.insertTempTableAlias = insertTempTableAlias;
            this.scanTempTableAlias = scanTempTableAlias;
            this.overridenEvaluationContext = RecursiveStateManagerImpl.withEmptyTempTable(baseContext, insertTempTableAlias, tempTableFactory);
            if (continuationBytes == null) {
                this.isInitialState = true;
                this.recursiveUnionTempTable = tempTableFactory.createTempTable();
                this.overridenEvaluationContext = RecursiveStateManagerImpl.withTempTable(this.overridenEvaluationContext, scanTempTableAlias, this.recursiveUnionTempTable);
                this.activeCursor = initialCursorCreator.apply(null, this.overridenEvaluationContext);
            } else {
                RecursiveUnionCursor.Continuation continuation = RecursiveUnionCursor.Continuation.from(continuationBytes, tempTableDeserializer);
                this.isInitialState = continuation.isInitialState();
                this.recursiveUnionTempTable = continuation.getTempTable();
                this.overridenEvaluationContext = RecursiveStateManagerImpl.withTempTable(this.overridenEvaluationContext, scanTempTableAlias, this.recursiveUnionTempTable);
                this.activeCursor = this.isInitialState ? initialCursorCreator.apply(continuation.getActiveStateContinuation().toByteString(), this.overridenEvaluationContext) : recursiveCursorCreator.apply(continuation.getActiveStateContinuation().toByteString(), this.overridenEvaluationContext);
            }
        }

        @Override
        public void notifyCursorIsExhausted() {
            if (this.isInitialState) {
                this.isInitialState = false;
            }
            this.overridenEvaluationContext = this.flipBuffers(this.overridenEvaluationContext);
            this.activeCursor = this.recursiveCursorCreator.apply(null, this.overridenEvaluationContext);
        }

        @Override
        public boolean canTransitionToNewStep() {
            return !this.recursiveUnionTempTable.isEmpty();
        }

        @Override
        @Nonnull
        public RecordCursor<QueryResult> getActiveStateCursor() {
            return this.activeCursor;
        }

        @Override
        @Nonnull
        public TempTable getRecursiveUnionTempTable() {
            return this.recursiveUnionTempTable;
        }

        @Override
        public boolean isInitialState() {
            return this.isInitialState;
        }

        @Nonnull
        private EvaluationContext flipBuffers(@Nonnull EvaluationContext evaluationContext) {
            TempTable insertTempTable = this.getTempTable(evaluationContext, this.insertTempTableAlias);
            TempTable scanTempTable = this.getTempTable(evaluationContext, this.scanTempTableAlias);
            if (this.recursiveUnionTempTable == insertTempTable) {
                this.recursiveUnionTempTable = scanTempTable;
                insertTempTable.clear();
                return RecursiveStateManagerImpl.withTempTable(RecursiveStateManagerImpl.withTempTable(this.baseContext, this.insertTempTableAlias, insertTempTable), this.scanTempTableAlias, scanTempTable);
            }
            this.recursiveUnionTempTable = insertTempTable;
            scanTempTable.clear();
            return RecursiveStateManagerImpl.withTempTable(RecursiveStateManagerImpl.withTempTable(this.baseContext, this.insertTempTableAlias, scanTempTable), this.scanTempTableAlias, insertTempTable);
        }

        @Nonnull
        private TempTable getTempTable(@Nonnull EvaluationContext evaluationContext, @Nonnull CorrelationIdentifier alias) {
            return (TempTable)evaluationContext.getBinding(Bindings.Internal.CORRELATION, alias);
        }

        @Nonnull
        private static EvaluationContext withTempTable(@Nonnull EvaluationContext context, @Nonnull CorrelationIdentifier key, @Nonnull TempTable value) {
            return context.withBinding(Bindings.Internal.CORRELATION.bindingName(key.getId()), value);
        }

        @Nonnull
        private static EvaluationContext withEmptyTempTable(@Nonnull EvaluationContext context, @Nonnull CorrelationIdentifier key, @Nonnull TempTable.Factory tempTableFactory) {
            return context.childBuilder().setBinding(Bindings.Internal.CORRELATION.bindingName(key.getId()), (Object)tempTableFactory.createTempTable()).build(context.getTypeRepository());
        }
    }

    public static final class Deserializer
    implements PlanDeserializer<PRecordQueryRecursiveLevelUnionPlan, RecordQueryRecursiveLevelUnionPlan> {
        @Override
        @Nonnull
        public Class<PRecordQueryRecursiveLevelUnionPlan> getProtoMessageClass() {
            return PRecordQueryRecursiveLevelUnionPlan.class;
        }

        @Override
        @Nonnull
        public RecordQueryRecursiveLevelUnionPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryRecursiveLevelUnionPlan recordQueryUnorderedDistinctPlanProto) {
            return RecordQueryRecursiveLevelUnionPlan.fromProto(serializationContext, recordQueryUnorderedDistinctPlanProto);
        }
    }
}

