/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.planprotos.PRecordQueryPlan;
import com.apple.foundationdb.record.planprotos.PRecordQueryScanPlan;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.query.plan.AvailableFields;
import com.apple.foundationdb.record.query.plan.ScanComparisons;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.ComparisonRanges;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.FinalMemoizer;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.WithPrimaryKeyMatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.apple.foundationdb.record.query.plan.cascades.explain.ExplainPlanVisitor;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraphRewritable;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithoutChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.QueriedValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithComparisons;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithMatchCandidate;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithNoChildren;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Message;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class RecordQueryScanPlan
extends AbstractRelationalExpressionWithoutChildren
implements RecordQueryPlanWithNoChildren,
RecordQueryPlanWithComparisons,
PlannerGraphRewritable,
RecordQueryPlanWithMatchCandidate {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Record-Query-Scan-Plan");
    @Nullable
    private final Set<String> recordTypes;
    @Nonnull
    private final Type flowedType;
    @Nullable
    private final KeyExpression commonPrimaryKey;
    @Nonnull
    private final ScanComparisons comparisons;
    private final boolean reverse;
    private final boolean strictlySorted;
    @Nonnull
    private final Optional<? extends WithPrimaryKeyMatchCandidate> matchCandidateOptional;
    @Nonnull
    private final Supplier<ComparisonRanges> comparisonRangesSupplier;

    public RecordQueryScanPlan(@Nonnull ScanComparisons comparisons, boolean reverse) {
        this(null, (Type)new Type.Any(), null, comparisons, reverse, false, Optional.empty());
    }

    public RecordQueryScanPlan(@Nullable Set<String> recordTypes, @Nonnull Type flowedType, @Nullable KeyExpression commonPrimaryKey, @Nonnull ScanComparisons comparisons, boolean reverse, boolean strictlySorted) {
        this(recordTypes, flowedType, commonPrimaryKey, comparisons, reverse, strictlySorted, Optional.empty());
    }

    public RecordQueryScanPlan(@Nullable Set<String> recordTypes, @Nonnull Type flowedType, @Nullable KeyExpression commonPrimaryKey, @Nonnull ScanComparisons comparisons, boolean reverse, boolean strictlySorted, @Nonnull WithPrimaryKeyMatchCandidate matchCandidate) {
        this(recordTypes, flowedType, commonPrimaryKey, comparisons, reverse, strictlySorted, Optional.of(matchCandidate));
    }

    @VisibleForTesting
    public RecordQueryScanPlan(@Nullable Set<String> recordTypes, @Nonnull Type flowedType, @Nullable KeyExpression commonPrimaryKey, @Nonnull ScanComparisons comparisons, boolean reverse, boolean strictlySorted, @Nonnull Optional<? extends WithPrimaryKeyMatchCandidate> matchCandidateOptional) {
        this.recordTypes = recordTypes == null ? null : ImmutableSet.copyOf(recordTypes);
        this.flowedType = flowedType;
        this.commonPrimaryKey = commonPrimaryKey;
        this.comparisons = comparisons;
        this.reverse = reverse;
        this.strictlySorted = strictlySorted;
        this.matchCandidateOptional = matchCandidateOptional;
        this.comparisonRangesSupplier = Suppliers.memoize(this::computeComparisonRanges);
    }

    @Override
    @Nonnull
    public <M extends Message> RecordCursor<QueryResult> executePlan(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        TupleRange range = this.comparisons.toTupleRange(store, context);
        return store.scanRecords(range.getLow(), range.getHigh(), range.getLowEndpoint(), range.getHighEndpoint(), continuation, executeProperties.asScanProperties(this.reverse)).map(store::queriedRecord).map(QueryResult::fromQueriedRecord);
    }

    @Nullable
    public Set<String> getRecordTypes() {
        return this.recordTypes;
    }

    @Nullable
    public KeyExpression getCommonPrimaryKey() {
        return this.commonPrimaryKey;
    }

    @Override
    @Nonnull
    public ScanComparisons getScanComparisons() {
        return this.comparisons;
    }

    @Override
    @Nonnull
    public ComparisonRanges getComparisonRanges() {
        return this.comparisonRangesSupplier.get();
    }

    @Nonnull
    private ComparisonRanges computeComparisonRanges() {
        return ComparisonRanges.from(this.comparisons);
    }

    @Override
    public boolean isReverse() {
        return this.reverse;
    }

    @Override
    public boolean hasRecordScan() {
        return true;
    }

    @Override
    public boolean hasFullRecordScan() {
        return this.comparisons.isEmpty();
    }

    @Override
    public boolean hasIndexScan(@Nonnull String indexName) {
        return false;
    }

    @Override
    @Nonnull
    public Set<String> getUsedIndexes() {
        return new HashSet<String>();
    }

    @Override
    public int maxCardinality(@Nonnull RecordMetaData metaData) {
        if (this.comparisons.isEquality() && metaData.getRecordTypes().values().stream().allMatch(t2 -> t2.getPrimaryKey().getColumnSize() <= this.comparisons.size())) {
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isStrictlySorted() {
        return this.strictlySorted;
    }

    @Override
    public RecordQueryScanPlan strictlySorted(@Nonnull FinalMemoizer memoizer) {
        return new RecordQueryScanPlan(this.recordTypes, this.flowedType, this.commonPrimaryKey, this.comparisons, this.reverse, true, this.matchCandidateOptional);
    }

    @Nonnull
    public Optional<? extends WithPrimaryKeyMatchCandidate> getMatchCandidateMaybe() {
        return this.matchCandidateOptional;
    }

    @Override
    @Nonnull
    public AvailableFields getAvailableFields() {
        return AvailableFields.ALL_FIELDS;
    }

    @Override
    public boolean hasLoadBykeys() {
        return false;
    }

    @Nonnull
    public String toString() {
        return ExplainPlanVisitor.toStringForDebugging(this);
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        return this.comparisons.getCorrelatedTo();
    }

    @Override
    @Nonnull
    public RecordQueryScanPlan translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        Verify.verify(translatedQuantifiers.isEmpty());
        if (translationMap.definesOnlyIdentities()) {
            return this;
        }
        ScanComparisons translatedComparisons = this.comparisons.translateCorrelations(translationMap, shouldSimplifyValues);
        if (translatedComparisons == this.comparisons) {
            return this;
        }
        return new RecordQueryScanPlan(this.recordTypes, this.flowedType, this.commonPrimaryKey, translatedComparisons, this.reverse, this.strictlySorted, this.matchCandidateOptional);
    }

    @Override
    public boolean canBeMinimized() {
        return this.matchCandidateOptional.isPresent();
    }

    @Override
    @Nonnull
    public RecordQueryPlan minimize(@Nonnull List<Quantifier.Physical> newQuantifiers) {
        Verify.verify(newQuantifiers.isEmpty());
        return new RecordQueryScanPlan(this.recordTypes, this.flowedType, this.commonPrimaryKey, this.comparisons, this.reverse, this.strictlySorted, Optional.empty());
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        return new QueriedValue(this.flowedType);
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap equivalencesMap) {
        if (this == otherExpression) {
            return true;
        }
        if (this.getClass() != otherExpression.getClass()) {
            return false;
        }
        RecordQueryScanPlan that = (RecordQueryScanPlan)otherExpression;
        return Objects.equals(this.recordTypes, that.recordTypes) && this.flowedType.equals(otherExpression.getResultValue().getResultType()) && Objects.equals(this.commonPrimaryKey, that.commonPrimaryKey) && this.reverse == that.reverse && Objects.equals(this.comparisons, that.comparisons);
    }

    public boolean equals(Object other) {
        return this.structuralEquals(other);
    }

    public int hashCode() {
        return this.structuralHashCode();
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return Objects.hash(this.recordTypes, this.flowedType, this.commonPrimaryKey, this.comparisons, this.reverse);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: {
                return this.comparisons.planHash(mode) + (this.reverse ? 1 : 0);
            }
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.comparisons, this.reverse, this.recordTypes, this.commonPrimaryKey);
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    @Override
    public void logPlanStructure(StoreTimer timer) {
        timer.increment(FDBStoreTimer.Counts.PLAN_SCAN);
    }

    @Override
    public int getComplexity() {
        return 1;
    }

    @Override
    @Nonnull
    public PlannerGraph rewritePlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        Verify.verify(childGraphs.isEmpty());
        TupleRange tupleRange = this.comparisons.toTupleRangeWithoutContext();
        ImmutableList.Builder detailsBuilder = ImmutableList.builder();
        ImmutableMap.Builder<String, Attribute.GmlAttribute> additionalAttributes = ImmutableMap.builder();
        if (tupleRange != null) {
            detailsBuilder.add("range: " + tupleRange.getLowEndpoint().toString(false) + "{{low}}, {{high}}" + tupleRange.getHighEndpoint().toString(true));
            additionalAttributes.put("low", Attribute.gml(tupleRange.getLow() == null ? "-\u221e" : tupleRange.getLow().toString()));
            additionalAttributes.put("high", Attribute.gml(tupleRange.getHigh() == null ? "\u221e" : tupleRange.getHigh().toString()));
        } else {
            detailsBuilder.add("comparisons: {{comparisons}}");
            additionalAttributes.put("comparisons", Attribute.gml(this.comparisons.toString()));
        }
        if (this.reverse) {
            detailsBuilder.add("direction: {{direction}}");
            additionalAttributes.put("direction", Attribute.gml("reversed"));
        }
        PlannerGraph.DataNodeWithInfo dataNodeWithInfo = this.getRecordTypes() == null ? new PlannerGraph.DataNodeWithInfo(NodeInfo.BASE_DATA, this.getResultType(), ImmutableList.of("ALL")) : new PlannerGraph.DataNodeWithInfo(NodeInfo.BASE_DATA, this.getResultType(), ImmutableList.of("record types: {{types}}"), ImmutableMap.of("types", Attribute.gml(this.getRecordTypes().stream().map(Attribute::gml).collect(ImmutableList.toImmutableList()))));
        return PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.OperatorNodeWithInfo(this, NodeInfo.SCAN_OPERATOR, (List<String>)((Object)detailsBuilder.build()), additionalAttributes.build()), ImmutableList.of(PlannerGraph.fromNodeAndChildGraphs(dataNodeWithInfo, childGraphs)));
    }

    @Override
    @Nonnull
    public PRecordQueryScanPlan toProto(@Nonnull PlanSerializationContext serializationContext) {
        PRecordQueryScanPlan.Builder builder = PRecordQueryScanPlan.newBuilder();
        builder.setHasRecordTypes(this.recordTypes != null);
        if (this.recordTypes != null) {
            for (String recordType : this.recordTypes) {
                builder.addRecordTypes(recordType);
            }
        }
        builder.setFlowedType(this.flowedType.toTypeProto(serializationContext));
        if (this.commonPrimaryKey != null) {
            builder.setCommonPrimaryKey(this.commonPrimaryKey.toKeyExpression());
        }
        builder.setComparisons(this.comparisons.toProto(serializationContext));
        builder.setReverse(this.reverse);
        builder.setStrictlySorted(this.strictlySorted);
        return builder.build();
    }

    @Override
    @Nonnull
    public PRecordQueryPlan toRecordQueryPlanProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryPlan.newBuilder().setScanPlan(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static RecordQueryScanPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryScanPlan recordQueryScanPlanProto) {
        ImmutableCollection recordTypes;
        Verify.verify(recordQueryScanPlanProto.hasReverse());
        Verify.verify(recordQueryScanPlanProto.hasStrictlySorted());
        Verify.verify(recordQueryScanPlanProto.hasHasRecordTypes());
        if (recordQueryScanPlanProto.getHasRecordTypes()) {
            ImmutableSet.Builder recordTypesBuilder = ImmutableSet.builder();
            for (int i = 0; i < recordQueryScanPlanProto.getRecordTypesCount(); ++i) {
                recordTypesBuilder.add(recordQueryScanPlanProto.getRecordTypes(i));
            }
            recordTypes = recordTypesBuilder.build();
        } else {
            recordTypes = null;
        }
        KeyExpression commonPrimaryKey = recordQueryScanPlanProto.hasCommonPrimaryKey() ? KeyExpression.fromProto(recordQueryScanPlanProto.getCommonPrimaryKey()) : null;
        return new RecordQueryScanPlan((Set<String>)((Object)recordTypes), Type.fromTypeProto(serializationContext, Objects.requireNonNull(recordQueryScanPlanProto.getFlowedType())), commonPrimaryKey, ScanComparisons.fromProto(serializationContext, Objects.requireNonNull(recordQueryScanPlanProto.getComparisons())), recordQueryScanPlanProto.getReverse(), recordQueryScanPlanProto.getStrictlySorted(), Optional.empty());
    }

    public static class Deserializer
    implements PlanDeserializer<PRecordQueryScanPlan, RecordQueryScanPlan> {
        @Override
        @Nonnull
        public Class<PRecordQueryScanPlan> getProtoMessageClass() {
            return PRecordQueryScanPlan.class;
        }

        @Override
        @Nonnull
        public RecordQueryScanPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryScanPlan recordQueryScanPlanProto) {
            return RecordQueryScanPlan.fromProto(serializationContext, recordQueryScanPlanProto);
        }
    }
}

