/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.EvaluationContextBuilder;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.IsolationLevel;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.metadata.IndexAggregateFunction;
import com.apple.foundationdb.record.planprotos.PRecordQueryPlan;
import com.apple.foundationdb.record.planprotos.PRecordQueryScoreForRankPlan;
import com.apple.foundationdb.record.planprotos.PScoreForRank;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.indexes.RankedSetIndexHelper;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.AvailableFields;
import com.apple.foundationdb.record.query.plan.HeuristicPlanner;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.debug.Debugger;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.apple.foundationdb.record.query.plan.cascades.explain.ExplainPlanVisitor;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.values.QueriedValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.planning.BindingFunction;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithChild;
import com.apple.foundationdb.tuple.Tuple;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.protobuf.Message;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class RecordQueryScoreForRankPlan
extends AbstractRelationalExpressionWithChildren
implements RecordQueryPlanWithChild {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Record-Query-Score-For-Rank-Plan");
    @Nonnull
    private final Quantifier.Physical inner;
    @Nonnull
    private final List<ScoreForRank> ranks;

    @HeuristicPlanner
    public RecordQueryScoreForRankPlan(@Nonnull RecordQueryPlan plan, @Nonnull List<ScoreForRank> ranks) {
        this(Quantifier.physical(Reference.plannedOf(Debugger.verifyHeuristicPlanner(plan))), ranks);
    }

    private RecordQueryScoreForRankPlan(@Nonnull Quantifier.Physical inner, @Nonnull List<ScoreForRank> ranks) {
        this.inner = inner;
        this.ranks = ranks;
    }

    private <M extends Message> CompletableFuture<Tuple> bindScore(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, ScoreForRank scoreForRank, @Nonnull IsolationLevel isolationLevel) {
        Tuple operand = Tuple.fromList(scoreForRank.comparisons.stream().map(c -> c.getComparand(store, context)).collect(Collectors.toList()));
        return store.evaluateAggregateFunction(context, Collections.emptyList(), scoreForRank.function, TupleRange.allOf(operand), isolationLevel);
    }

    private <M extends Message> CompletableFuture<EvaluationContext> bindScores(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nonnull IsolationLevel isolationLevel) {
        List scores = this.ranks.stream().map(r -> this.bindScore(store, context, (ScoreForRank)r, isolationLevel)).collect(Collectors.toList());
        return AsyncUtil.whenAll(scores).thenApply(vignore -> {
            EvaluationContextBuilder builder = context.childBuilder();
            for (int i = 0; i < scores.size(); ++i) {
                ScoreForRank rank = this.ranks.get(i);
                Tuple score = (Tuple)store.getContext().joinNow((CompletableFuture)scores.get(i));
                Object binding = score == null ? null : (score == RankedSetIndexHelper.COMPARISON_SKIPPED_SCORE ? Comparisons.COMPARISON_SKIPPED_BINDING : rank.bindingFunction.apply(score));
                builder.setBinding(rank.bindingName, binding);
            }
            return builder.build(context.getTypeRepository());
        });
    }

    @Override
    @Nonnull
    public <M extends Message> RecordCursor<QueryResult> executePlan(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        return RecordCursor.mapFuture(store.getExecutor(), this.bindScores(store, context, executeProperties.getIsolationLevel()), continuation, (innerContext, innerContinuation) -> this.getChild().executePlan(store, (EvaluationContext)innerContext, (byte[])innerContinuation, executeProperties));
    }

    @Nonnull
    public List<ScoreForRank> getRanks() {
        return this.ranks;
    }

    @Override
    @Nonnull
    public RecordQueryPlan getChild() {
        return this.inner.getRangesOverPlan();
    }

    @Override
    @Nonnull
    @API(value=API.Status.EXPERIMENTAL)
    public List<? extends Quantifier> getQuantifiers() {
        return ImmutableList.of(this.inner);
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        return new QueriedValue();
    }

    @Override
    @Nonnull
    public AvailableFields getAvailableFields() {
        return AvailableFields.ALL_FIELDS;
    }

    @Override
    public boolean isReverse() {
        return this.getChild().isReverse();
    }

    public String toString() {
        return ExplainPlanVisitor.toStringForDebugging(this);
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        return ImmutableSet.of();
    }

    @Override
    @Nonnull
    public RecordQueryScoreForRankPlan translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        return new RecordQueryScoreForRankPlan((Quantifier.Physical)Iterables.getOnlyElement(translatedQuantifiers), this.getRanks());
    }

    @Override
    @Nonnull
    public RecordQueryPlanWithChild withChild(@Nonnull Reference childRef) {
        return new RecordQueryScoreForRankPlan(Quantifier.physical(childRef, this.inner.getAlias()), this.getRanks());
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap equivalencesMap) {
        if (this == otherExpression) {
            return true;
        }
        if (this.getClass() != otherExpression.getClass()) {
            return false;
        }
        return this.ranks.equals(((RecordQueryScoreForRankPlan)otherExpression).ranks);
    }

    public boolean equals(Object other) {
        return this.structuralEquals(other);
    }

    public int hashCode() {
        return this.structuralHashCode();
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return Objects.hash(this.ranks);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: {
                return this.getChild().planHash(mode) + PlanHashable.planHash(mode, this.ranks);
            }
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.getChild(), this.ranks);
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    @Override
    public void logPlanStructure(StoreTimer timer) {
        timer.increment(FDBStoreTimer.Counts.PLAN_SCORE_FOR_RANK);
        this.getChild().logPlanStructure(timer);
    }

    @Override
    public int getComplexity() {
        return 1 + this.getChild().getComplexity();
    }

    @Override
    @Nonnull
    public PlannerGraph rewritePlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        PlannerGraph.OperatorNodeWithInfo root = new PlannerGraph.OperatorNodeWithInfo(this, NodeInfo.NESTED_LOOP_JOIN_OPERATOR);
        PlannerGraph graphForInner = Iterables.getOnlyElement(childGraphs);
        PlannerGraph.DataNodeWithInfo valuesNode = new PlannerGraph.DataNodeWithInfo(NodeInfo.VALUES_DATA, this.getResultType(), ImmutableList.of("VALUES({{values}}"), ImmutableMap.of("values", Attribute.gml(Objects.requireNonNull(this.getRanks()).stream().map(ScoreForRank::callToString).map(Attribute::gml).collect(ImmutableList.toImmutableList()))));
        PlannerGraph.Edge fromValuesEdge = new PlannerGraph.Edge();
        return (PlannerGraph)PlannerGraph.builder(root).addGraph(graphForInner).addNode(valuesNode).addEdge(valuesNode, root, fromValuesEdge).addEdge((PlannerGraph.Node)graphForInner.getRoot(), root, new PlannerGraph.Edge(ImmutableSet.of(fromValuesEdge))).build();
    }

    @Override
    @Nonnull
    public PRecordQueryScoreForRankPlan toProto(@Nonnull PlanSerializationContext serializationContext) {
        PRecordQueryScoreForRankPlan.Builder builder = PRecordQueryScoreForRankPlan.newBuilder().setInner(this.inner.toProto(serializationContext));
        for (ScoreForRank rank : this.ranks) {
            builder.addRanks(rank.toProto(serializationContext));
        }
        return builder.build();
    }

    @Override
    @Nonnull
    public PRecordQueryPlan toRecordQueryPlanProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryPlan.newBuilder().setScoreForRankPlan(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static RecordQueryScoreForRankPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryScoreForRankPlan recordQueryScoreForRankPlanProto) {
        ImmutableList.Builder ranksBuilder = ImmutableList.builder();
        for (int i = 0; i < recordQueryScoreForRankPlanProto.getRanksCount(); ++i) {
            ranksBuilder.add(ScoreForRank.fromProto(serializationContext, recordQueryScoreForRankPlanProto.getRanks(i)));
        }
        return new RecordQueryScoreForRankPlan(Quantifier.Physical.fromProto(serializationContext, Objects.requireNonNull(recordQueryScoreForRankPlanProto.getInner())), (List<ScoreForRank>)((Object)ranksBuilder.build()));
    }

    public static class ScoreForRank
    implements PlanHashable,
    PlanSerializable {
        private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Score-For-Rank");
        @Nonnull
        private final String bindingName;
        @Nonnull
        private final BindingFunction bindingFunction;
        @Nonnull
        private final IndexAggregateFunction function;
        @Nonnull
        private final List<Comparisons.Comparison> comparisons;

        public ScoreForRank(@Nonnull String bindingName, @Nonnull BindingFunction bindingFunction, @Nonnull IndexAggregateFunction function, @Nonnull List<Comparisons.Comparison> comparisons) {
            this.bindingName = bindingName;
            this.bindingFunction = bindingFunction;
            this.function = function;
            this.comparisons = comparisons;
        }

        @Nonnull
        public String getBindingName() {
            return this.bindingName;
        }

        @Nonnull
        public List<Comparisons.Comparison> getComparisons() {
            return this.comparisons;
        }

        public String toString() {
            return this.bindingName + " = " + this.callToString();
        }

        public String callToString() {
            return this.function.getIndex() + "." + this.function.getName() + this.comparisons.stream().map(Comparisons.Comparison::typelessString).collect(Collectors.joining(", ", "(", ")"));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ScoreForRank that = (ScoreForRank)o;
            return Objects.equals(this.bindingName, that.bindingName) && Objects.equals((Object)this.bindingFunction, (Object)that.bindingFunction) && Objects.equals(this.function, that.function) && Objects.equals(this.comparisons, that.comparisons);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.bindingName, this.bindingFunction, this.function, this.comparisons});
        }

        @Override
        public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
            switch (mode.getKind()) {
                case LEGACY: {
                    return this.bindingName.hashCode() + this.function.getName().hashCode() + PlanHashable.planHash(mode, this.comparisons);
                }
                case FOR_CONTINUATION: {
                    return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.bindingName, this.function.getName(), this.comparisons);
                }
            }
            throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
        }

        @Override
        @Nonnull
        public PScoreForRank toProto(@Nonnull PlanSerializationContext serializationContext) {
            PScoreForRank.Builder builder = PScoreForRank.newBuilder().setBindingName(this.bindingName).setBindingFunction(this.bindingFunction.toProto(serializationContext)).setFunction(this.function.toProto(serializationContext));
            for (Comparisons.Comparison comparison : this.comparisons) {
                builder.addComparisons(comparison.toComparisonProto(serializationContext));
            }
            return builder.build();
        }

        @Nonnull
        public static ScoreForRank fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PScoreForRank scoreForRankProto) {
            ImmutableList.Builder comparisonsBuilder = ImmutableList.builder();
            for (int i = 0; i < scoreForRankProto.getComparisonsCount(); ++i) {
                comparisonsBuilder.add(Comparisons.Comparison.fromComparisonProto(serializationContext, scoreForRankProto.getComparisons(i)));
            }
            return new ScoreForRank(Objects.requireNonNull(scoreForRankProto.getBindingName()), BindingFunction.fromProto(serializationContext, Objects.requireNonNull(scoreForRankProto.getBindingFunction())), IndexAggregateFunction.fromProto(serializationContext, Objects.requireNonNull(scoreForRankProto.getFunction())), (List<Comparisons.Comparison>)((Object)comparisonsBuilder.build()));
        }
    }

    public static class Deserializer
    implements PlanDeserializer<PRecordQueryScoreForRankPlan, RecordQueryScoreForRankPlan> {
        @Override
        @Nonnull
        public Class<PRecordQueryScoreForRankPlan> getProtoMessageClass() {
            return PRecordQueryScoreForRankPlan.class;
        }

        @Override
        @Nonnull
        public RecordQueryScoreForRankPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryScoreForRankPlan recordQueryScoreForRankPlanProto) {
            return RecordQueryScoreForRankPlan.fromProto(serializationContext, recordQueryScoreForRankPlanProto);
        }
    }
}

