/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.RecordCursorProto;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.RecordCursorVisitor;
import com.apple.foundationdb.record.planprotos.PRecordQueryPlan;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.query.plan.HeuristicPlanner;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifiers;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.debug.Debugger;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.apple.foundationdb.record.query.plan.cascades.explain.ExplainPlanVisitor;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.PlanSelector;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryChooserPlanBase;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RelativeProbabilityPlanSelector;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.ZeroCopyByteString;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordQuerySelectorPlan
extends RecordQueryChooserPlanBase {
    public static final Logger LOGGER = LoggerFactory.getLogger(RecordQuerySelectorPlan.class);
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Record-Query-Selector-Plan");
    @Nonnull
    private final PlanSelector planSelector;

    private RecordQuerySelectorPlan(@Nonnull List<Quantifier.Physical> quantifiers, @Nonnull PlanSelector planSelector) {
        super(quantifiers);
        this.planSelector = planSelector;
    }

    public static RecordQuerySelectorPlan from(@Nonnull List<? extends RecordQueryPlan> children, @Nonnull List<Integer> relativePlanProbabilities) {
        if (children.size() != relativePlanProbabilities.size()) {
            throw new RecordCoreArgumentException("Number of plans and number of relative probabilities should be the same", new Object[0]);
        }
        return RecordQuerySelectorPlan.from(children, new RelativeProbabilityPlanSelector(relativePlanProbabilities));
    }

    @HeuristicPlanner
    public static RecordQuerySelectorPlan from(@Nonnull List<? extends RecordQueryPlan> children, @Nonnull PlanSelector planSelector) {
        Debugger.verifyHeuristicPlanner();
        if (children.isEmpty()) {
            throw new RecordCoreArgumentException("Selector plan should have at least one plan", new Object[0]);
        }
        ImmutableList.Builder childRefsBuilder = ImmutableList.builder();
        for (RecordQueryPlan recordQueryPlan : children) {
            childRefsBuilder.add(Reference.plannedOf(recordQueryPlan));
        }
        return new RecordQuerySelectorPlan(Quantifiers.fromPlans(childRefsBuilder.build()), planSelector);
    }

    @Override
    @Nonnull
    public <M extends Message> RecordCursor<QueryResult> executePlan(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        SelectorContinuation selectorContinuation = new SelectorContinuation(continuation);
        int selectedPlanIndex = this.selectPlanIndex(selectorContinuation);
        RecordQueryPlan selectedPlan = this.getChild(selectedPlanIndex);
        RecordCursor<QueryResult> innerCursor = selectedPlan.executePlan(store, context, selectorContinuation.getInnerContinuation(), executeProperties);
        return new SelectorPlanCursor(selectedPlanIndex, innerCursor, store.getTimer());
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.getChildren(), this.isReverse(), this.planSelector);
    }

    public String toString() {
        return ExplainPlanVisitor.toStringForDebugging(this);
    }

    @Override
    public void logPlanStructure(StoreTimer timer) {
        timer.increment(FDBStoreTimer.Counts.PLAN_SELECTOR);
        for (Quantifier.Physical quantifier : this.quantifiers) {
            quantifier.getRangesOverPlan().logPlanStructure(timer);
        }
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap equivalences) {
        if (this == otherExpression) {
            return true;
        }
        if (this.getClass() != otherExpression.getClass()) {
            return false;
        }
        RecordQuerySelectorPlan other = (RecordQuerySelectorPlan)otherExpression;
        return this.isReverse() == other.isReverse() && this.planSelector.equals(other.planSelector);
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return Objects.hash(this.isReverse(), this.planSelector);
    }

    @Override
    @Nonnull
    public PlannerGraph rewritePlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        return PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.OperatorNodeWithInfo(this, NodeInfo.SELECTOR_OPERATOR, List.of("SELECT BY {{planSelector}}"), Map.of("planSelector", Attribute.gml(this.planSelector.toString()))), childGraphs);
    }

    @Override
    @Nonnull
    public RecordQuerySelectorPlan translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        return new RecordQuerySelectorPlan(Quantifiers.narrow(Quantifier.Physical.class, translatedQuantifiers), this.planSelector);
    }

    private int selectPlanIndex(SelectorContinuation continuation) {
        if (!continuation.isEmpty()) {
            return (int)continuation.getSelectedPlanIndex();
        }
        return this.planSelector.selectPlan(this.getChildren());
    }

    @Override
    @Nonnull
    public Message toProto(@Nonnull PlanSerializationContext serializationContext) {
        throw new RecordCoreException("serialization of this plan is not supported", new Object[0]);
    }

    @Override
    @Nonnull
    public PRecordQueryPlan toRecordQueryPlanProto(@Nonnull PlanSerializationContext serializationContext) {
        throw new RecordCoreException("serialization of this plan is not supported", new Object[0]);
    }

    private static class SelectorContinuation
    implements RecordCursorContinuation {
        private long selectedPlanIndex;
        @Nullable
        private ByteString innerContinuation = null;
        private boolean isEnd;
        @Nullable
        private RecordCursorProto.SelectorPlanContinuation cachedProto;

        public SelectorContinuation(byte[] rawBytes) {
            try {
                if (rawBytes != null) {
                    RecordCursorProto.SelectorPlanContinuation continuation = RecordCursorProto.SelectorPlanContinuation.parseFrom(rawBytes);
                    if (continuation.hasSelectedPlan()) {
                        this.selectedPlanIndex = continuation.getSelectedPlan();
                    }
                    if (continuation.hasInnerContinuation()) {
                        this.innerContinuation = continuation.getInnerContinuation();
                    }
                }
            }
            catch (InvalidProtocolBufferException ex) {
                throw new RecordCoreException("error parsing continuation", ex).addLogInfo("raw_bytes", (Object)ByteArrayUtil2.loggable(rawBytes));
            }
        }

        public SelectorContinuation(long selectedPlanIndex, @Nullable byte[] innerContinuation, boolean isEnd) {
            this.selectedPlanIndex = selectedPlanIndex;
            this.isEnd = isEnd;
            this.innerContinuation = innerContinuation != null ? ZeroCopyByteString.wrap(innerContinuation) : null;
        }

        private RecordCursorProto.SelectorPlanContinuation toProto() {
            if (this.cachedProto == null) {
                this.cachedProto = RecordCursorProto.SelectorPlanContinuation.newBuilder().setSelectedPlan(this.selectedPlanIndex).setInnerContinuation(this.innerContinuation).build();
            }
            return this.cachedProto;
        }

        @Override
        @Nonnull
        public ByteString toByteString() {
            if (this.isEnd()) {
                return ByteString.EMPTY;
            }
            return this.toProto().toByteString();
        }

        @Override
        @Nullable
        public byte[] toBytes() {
            if (this.isEnd()) {
                return null;
            }
            return this.toProto().toByteArray();
        }

        @Override
        public boolean isEnd() {
            return this.isEnd;
        }

        public boolean isEmpty() {
            return this.innerContinuation == null;
        }

        public long getSelectedPlanIndex() {
            return this.selectedPlanIndex;
        }

        @Nullable
        public byte[] getInnerContinuation() {
            return this.innerContinuation == null ? null : this.innerContinuation.toByteArray();
        }
    }

    private static class SelectorPlanCursor
    implements RecordCursor<QueryResult> {
        private final long selectedPlanIndex;
        @Nonnull
        private final RecordCursor<QueryResult> inner;
        @Nullable
        FDBStoreTimer timer;

        public SelectorPlanCursor(long selectedPlanIndex, @Nonnull RecordCursor<QueryResult> inner, @Nullable FDBStoreTimer timer) {
            this.inner = inner;
            this.selectedPlanIndex = selectedPlanIndex;
            this.timer = timer;
        }

        @Override
        @Nonnull
        public CompletableFuture<RecordCursorResult<QueryResult>> onNext() {
            return this.inner.onNext().thenApply(this::calculateCursorResult);
        }

        @Override
        public void close() {
            this.inner.close();
        }

        @Override
        public boolean isClosed() {
            return this.inner.isClosed();
        }

        @Override
        @Nonnull
        public Executor getExecutor() {
            return this.inner.getExecutor();
        }

        @Override
        public boolean accept(@Nonnull RecordCursorVisitor visitor) {
            if (visitor.visitEnter(this)) {
                this.inner.accept(visitor);
            }
            return visitor.visitLeave(this);
        }

        private RecordCursorResult<QueryResult> calculateCursorResult(RecordCursorResult<QueryResult> innerResult) {
            long startTime = System.nanoTime();
            if (innerResult.hasNext()) {
                SelectorContinuation continuation = new SelectorContinuation(this.selectedPlanIndex, innerResult.getContinuation().toBytes(), false);
                this.logTimer(startTime);
                return RecordCursorResult.withNextValue(innerResult.get(), continuation);
            }
            SelectorContinuation continuation = new SelectorContinuation(this.selectedPlanIndex, innerResult.getContinuation().toBytes(), innerResult.getContinuation().isEnd());
            this.logTimer(startTime);
            return RecordCursorResult.withoutNextValue(continuation, innerResult.getNoNextReason());
        }

        private void logTimer(long startTime) {
            if (this.timer != null) {
                this.timer.record(FDBStoreTimer.Events.QUERY_SELECTOR, System.nanoTime() - startTime);
            }
        }
    }
}

