/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.record.Bindings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.planprotos.PComparisonKeyFunction;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.OrderingPart;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.DerivedValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.explain.DefaultExplainFormatter;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.TranslateValueFunction;
import com.apple.foundationdb.record.query.plan.serialization.PlanSerialization;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public interface RecordQuerySetPlan
extends RecordQueryPlan {
    @Nonnull
    public Set<KeyExpression> getRequiredFields();

    @Nonnull
    default public List<? extends Value> getRequiredValues(@Nonnull CorrelationIdentifier baseAlias, @Nonnull Type inputType) {
        return Value.fromKeyExpressions(this.getRequiredFields(), baseAlias, inputType);
    }

    @Nonnull
    default public TranslateValueFunction pushValueFunction(List<TranslateValueFunction> dependentFunctions) {
        Verify.verify(!dependentFunctions.isEmpty());
        return (value, sourceAlias, targetAlias) -> {
            Value previousPushedValue = null;
            AliasMap equivalencesMap = null;
            for (TranslateValueFunction dependentFunction : dependentFunctions) {
                Optional<Value> pushedValueOptional = dependentFunction.translateValue(value, sourceAlias, targetAlias);
                if (pushedValueOptional.isEmpty()) {
                    return Optional.empty();
                }
                if (previousPushedValue == null) {
                    previousPushedValue = pushedValueOptional.get();
                    equivalencesMap = AliasMap.emptyMap();
                    continue;
                }
                if (previousPushedValue.semanticEquals((Object)pushedValueOptional.get(), equivalencesMap)) continue;
                return Optional.empty();
            }
            return Optional.ofNullable(previousPushedValue);
        };
    }

    @Nonnull
    default public Set<CorrelationIdentifier> tryPushValues(@Nonnull List<TranslateValueFunction> dependentFunctions, @Nonnull List<? extends Quantifier> quantifiers, @Nonnull Iterable<? extends Value> values, @Nonnull CorrelationIdentifier sourceAlias) {
        Verify.verify(!dependentFunctions.isEmpty());
        Verify.verify(dependentFunctions.size() == quantifiers.size());
        Set candidatesAliases = quantifiers.stream().map(Quantifier::getAlias).collect(Collectors.toSet());
        CorrelationIdentifier targetAlias = Quantifier.uniqueId();
        for (Value value : values) {
            AliasMap equivalencesMap = AliasMap.emptyMap();
            Value previousPushedValue = null;
            for (int i = 0; i < dependentFunctions.size(); ++i) {
                TranslateValueFunction dependentFunction = dependentFunctions.get(i);
                Quantifier quantifier = quantifiers.get(i);
                if (!candidatesAliases.contains(quantifier.getAlias())) continue;
                Optional<Value> pushedValueOptional = dependentFunction.translateValue(value, sourceAlias, targetAlias);
                if (pushedValueOptional.isEmpty()) {
                    candidatesAliases.remove(quantifier.getAlias());
                    continue;
                }
                if (previousPushedValue == null) {
                    previousPushedValue = pushedValueOptional.get();
                    continue;
                }
                if (previousPushedValue.semanticEquals((Object)pushedValueOptional.get(), equivalencesMap)) continue;
                return ImmutableSet.of();
            }
        }
        return ImmutableSet.copyOf(candidatesAliases);
    }

    @Nonnull
    public RecordQuerySetPlan withChildrenReferences(@Nonnull List<? extends Reference> var1);

    default public boolean isDynamic() {
        return false;
    }

    public static boolean resolveComparisonDirection(@Nonnull Iterable<OrderingPart.ProvidedOrderingPart> providedOrderingParts) {
        int numAscending = 0;
        int numDescending = 0;
        block5: for (OrderingPart.ProvidedOrderingPart providedOrderingPart : providedOrderingParts) {
            OrderingPart.ProvidedSortOrder sortOrder = (OrderingPart.ProvidedSortOrder)providedOrderingPart.getSortOrder();
            switch (sortOrder) {
                case ASCENDING: 
                case ASCENDING_NULLS_LAST: {
                    ++numAscending;
                    continue block5;
                }
                case DESCENDING: 
                case DESCENDING_NULLS_FIRST: {
                    ++numDescending;
                    continue block5;
                }
                case FIXED: 
                case CHOOSE: {
                    continue block5;
                }
            }
            throw new RecordCoreException("unexpected sort order", new Object[0]);
        }
        if (numAscending == 0 && numDescending == 0) {
            return false;
        }
        return numDescending > numAscending;
    }

    public static List<OrderingPart.ProvidedOrderingPart> adjustFixedBindings(@Nonnull Iterable<OrderingPart.ProvidedOrderingPart> providedOrderingParts, boolean isReverse) {
        return Streams.stream(providedOrderingParts).map(providedOrderingPart -> {
            if (providedOrderingPart.getSortOrder() != OrderingPart.ProvidedSortOrder.FIXED) {
                return providedOrderingPart;
            }
            return new OrderingPart.ProvidedOrderingPart(providedOrderingPart.getValue(), isReverse ? OrderingPart.ProvidedSortOrder.DESCENDING : OrderingPart.ProvidedSortOrder.ASCENDING);
        }).collect(ImmutableList.toImmutableList());
    }

    public static Value mergeValues(@Nonnull Iterable<? extends Quantifier> quantifiers) {
        Type resultType = Streams.stream(quantifiers).filter(quantifier -> !(quantifier instanceof Quantifier.Existential)).findFirst().map(Quantifier::getFlowedObjectType).orElseThrow(() -> new RecordCoreException("cannot resolve result type", new Object[0]));
        return new DerivedValue(Streams.stream(quantifiers).map(Quantifier::getFlowedObjectValue).collect(ImmutableList.toImmutableList()), resultType);
    }

    public static interface ComparisonKeyFunction
    extends PlanHashable,
    PlanSerializable {
        @Nonnull
        public <M extends Message> Function<QueryResult, List<Object>> apply(@Nonnull FDBRecordStoreBase<M> var1, @Nonnull EvaluationContext var2);

        @Nonnull
        public ExplainTokensWithPrecedence explain();

        @Nonnull
        public PComparisonKeyFunction toComparisonKeyFunctionProto(@Nonnull PlanSerializationContext var1);

        @Nonnull
        public static ComparisonKeyFunction fromComparisonKeyFunctionProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PComparisonKeyFunction comparisonKeyFunctionProto) {
            return (ComparisonKeyFunction)PlanSerialization.dispatchFromProtoContainer(serializationContext, comparisonKeyFunctionProto);
        }

        public static class OnValues
        implements ComparisonKeyFunction {
            @Nonnull
            private final CorrelationIdentifier baseAlias;
            @Nonnull
            private final List<? extends Value> comparisonKeyValues;

            protected OnValues(@Nonnull CorrelationIdentifier baseAlias, @Nonnull List<? extends Value> comparisonKeyValues) {
                this.baseAlias = baseAlias;
                this.comparisonKeyValues = ImmutableList.copyOf(comparisonKeyValues);
            }

            @Nonnull
            public List<? extends Value> getComparisonKeyValues() {
                return this.comparisonKeyValues;
            }

            @Override
            @Nonnull
            public final <M extends Message> Function<QueryResult, List<Object>> apply(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext evaluationContext) {
                return queryResult -> {
                    EvaluationContext nestedContext = evaluationContext.withBinding(Bindings.Internal.CORRELATION, this.baseAlias, queryResult);
                    ArrayList<Object> resultList = Lists.newArrayList();
                    for (Value value : this.comparisonKeyValues) {
                        resultList.add(value.eval(store, nestedContext));
                    }
                    return resultList;
                };
            }

            public int hashCode() {
                return this.comparisonKeyValues.hashCode();
            }

            public boolean equals(Object o) {
                if (o == null) {
                    return false;
                }
                if (o == this) {
                    return true;
                }
                if (o.getClass() != this.getClass()) {
                    return false;
                }
                OnValues other = (OnValues)o;
                return this.comparisonKeyValues.equals(other.comparisonKeyValues);
            }

            public String toString() {
                return this.explain().getExplainTokens().render(DefaultExplainFormatter.forDebugging()).toString();
            }

            @Override
            @Nonnull
            public ExplainTokensWithPrecedence explain() {
                return ExplainTokensWithPrecedence.of(new ExplainTokens().addOpeningParen().addOptionalWhitespace().addSequence(() -> new ExplainTokens().addCommaAndWhiteSpace(), () -> this.comparisonKeyValues.stream().map(Value::explain).map(ExplainTokensWithPrecedence::getExplainTokens).iterator()).addOptionalWhitespace().addClosingParen());
            }

            @Override
            public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
                return PlanHashable.planHash(mode, this.comparisonKeyValues);
            }

            @Override
            @Nonnull
            public PComparisonKeyFunction.POnValues toProto(@Nonnull PlanSerializationContext serializationContext) {
                PComparisonKeyFunction.POnValues.Builder builder = PComparisonKeyFunction.POnValues.newBuilder().setBaseAlias(this.baseAlias.getId());
                for (Value value : this.comparisonKeyValues) {
                    builder.addComparisonKeyValues(value.toValueProto(serializationContext));
                }
                return builder.build();
            }

            @Override
            @Nonnull
            public PComparisonKeyFunction toComparisonKeyFunctionProto(@Nonnull PlanSerializationContext serializationContext) {
                return PComparisonKeyFunction.newBuilder().setOnValues(this.toProto(serializationContext)).build();
            }

            @Nonnull
            public static OnValues fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PComparisonKeyFunction.POnValues onValuesProto) {
                ImmutableList.Builder comparisonKeyValuesBuilder = ImmutableList.builder();
                for (int i = 0; i < onValuesProto.getComparisonKeyValuesCount(); ++i) {
                    comparisonKeyValuesBuilder.add(Value.fromValueProto(serializationContext, onValuesProto.getComparisonKeyValues(i)));
                }
                return new OnValues(CorrelationIdentifier.of(Objects.requireNonNull(onValuesProto.getBaseAlias())), (List<? extends Value>)((Object)comparisonKeyValuesBuilder.build()));
            }

            public static class Deserializer
            implements PlanDeserializer<PComparisonKeyFunction.POnValues, OnValues> {
                @Override
                @Nonnull
                public Class<PComparisonKeyFunction.POnValues> getProtoMessageClass() {
                    return PComparisonKeyFunction.POnValues.class;
                }

                @Override
                @Nonnull
                public OnValues fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PComparisonKeyFunction.POnValues onValuesProto) {
                    return OnValues.fromProto(serializationContext, onValuesProto);
                }
            }
        }

        public static class OnKeyExpression
        implements ComparisonKeyFunction {
            @Nonnull
            private final KeyExpression comparisonKeyExpression;

            protected OnKeyExpression(@Nonnull KeyExpression comparisonKeyExpression) {
                this.comparisonKeyExpression = comparisonKeyExpression;
            }

            @Override
            @Nonnull
            public final <M extends Message> Function<QueryResult, List<Object>> apply(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext evaluationContext) {
                return queryResult -> this.comparisonKeyExpression.evaluateMessageSingleton(null, (Message)queryResult.getMessage()).toTupleAppropriateList();
            }

            @Nonnull
            public KeyExpression getComparisonKey() {
                return this.comparisonKeyExpression;
            }

            public int hashCode() {
                return this.comparisonKeyExpression.hashCode();
            }

            public boolean equals(Object o) {
                if (o == null) {
                    return false;
                }
                if (o == this) {
                    return true;
                }
                if (o.getClass() != this.getClass()) {
                    return false;
                }
                OnKeyExpression other = (OnKeyExpression)o;
                return this.comparisonKeyExpression.equals(other.comparisonKeyExpression);
            }

            public String toString() {
                return this.explain().getExplainTokens().render(DefaultExplainFormatter.forDebugging()).toString();
            }

            @Override
            @Nonnull
            public ExplainTokensWithPrecedence explain() {
                return ExplainTokensWithPrecedence.of(new ExplainTokens().addToString(this.comparisonKeyExpression));
            }

            @Override
            public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
                return this.comparisonKeyExpression.planHash(mode);
            }

            @Override
            @Nonnull
            public PComparisonKeyFunction.POnKeyExpression toProto(@Nonnull PlanSerializationContext serializationContext) {
                return PComparisonKeyFunction.POnKeyExpression.newBuilder().setComparisonKeyExpression(this.comparisonKeyExpression.toKeyExpression()).build();
            }

            @Override
            @Nonnull
            public PComparisonKeyFunction toComparisonKeyFunctionProto(@Nonnull PlanSerializationContext serializationContext) {
                return PComparisonKeyFunction.newBuilder().setOnKeyExpression(this.toProto(serializationContext)).build();
            }

            @Nonnull
            public static OnKeyExpression fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PComparisonKeyFunction.POnKeyExpression onKeyExpressionProto) {
                return new OnKeyExpression(KeyExpression.fromProto(onKeyExpressionProto.getComparisonKeyExpression()));
            }

            public static class Deserializer
            implements PlanDeserializer<PComparisonKeyFunction.POnKeyExpression, OnKeyExpression> {
                @Override
                @Nonnull
                public Class<PComparisonKeyFunction.POnKeyExpression> getProtoMessageClass() {
                    return PComparisonKeyFunction.POnKeyExpression.class;
                }

                @Override
                @Nonnull
                public OnKeyExpression fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PComparisonKeyFunction.POnKeyExpression onKeyExpressionProto) {
                    return OnKeyExpression.fromProto(serializationContext, onKeyExpressionProto);
                }
            }
        }
    }
}

