/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.RecordCursorProto;
import com.apple.foundationdb.record.RecordCursorStartContinuation;
import com.apple.foundationdb.record.cursors.aggregate.AggregateCursor;
import com.apple.foundationdb.record.cursors.aggregate.StreamGrouping;
import com.apple.foundationdb.record.planprotos.PRecordQueryPlan;
import com.apple.foundationdb.record.planprotos.PRecordQueryStreamingAggregationPlan;
import com.apple.foundationdb.record.planprotos.PRecordQueryStreamingAggregationPlan2;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.apple.foundationdb.record.query.plan.cascades.explain.ExplainPlanVisitor;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.GroupByExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.AggregateValue;
import com.apple.foundationdb.record.query.plan.cascades.values.ObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithChild;
import com.apple.foundationdb.record.query.plan.serialization.PlanSerialization;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.INTERNAL)
public class RecordQueryStreamingAggregationPlan
extends AbstractRelationalExpressionWithChildren
implements RecordQueryPlanWithChild {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Record-Query-Streaming-Aggregator-Plan");
    public static final Logger LOGGER = LoggerFactory.getLogger(RecordQueryStreamingAggregationPlan.class);
    @Nonnull
    private final Quantifier.Physical inner;
    @Nonnull
    private final AggregateValue aggregateValue;
    @Nullable
    private final Value groupingKeyValue;
    @Nonnull
    private final CorrelationIdentifier groupingKeyAlias;
    @Nonnull
    private final CorrelationIdentifier aggregateAlias;
    @Nonnull
    private final Value completeResultValue;
    @Nonnull
    private final SerializationMode serializationMode;

    private RecordQueryStreamingAggregationPlan(@Nonnull Quantifier.Physical inner, @Nullable Value groupingKeyValue, @Nonnull AggregateValue aggregateValue, @Nonnull CorrelationIdentifier groupingKeyAlias, @Nonnull CorrelationIdentifier aggregateAlias, @Nonnull Value completeResultValue, @Nonnull SerializationMode serializationMode) {
        this.inner = inner;
        this.groupingKeyValue = groupingKeyValue;
        this.aggregateValue = aggregateValue;
        this.groupingKeyAlias = groupingKeyAlias;
        this.aggregateAlias = aggregateAlias;
        this.completeResultValue = completeResultValue;
        this.serializationMode = serializationMode;
    }

    @Override
    @Nonnull
    public <M extends Message> RecordCursor<QueryResult> executePlan(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        RecordCursorContinuation recordCursorContinuation = RecordCursorStartContinuation.START;
        byte[] innerContinuation = null;
        RecordCursorProto.PartialAggregationResult partialAggregationResult = null;
        if (continuation != null) {
            recordCursorContinuation = AggregateCursor.AggregateCursorContinuation.fromRawBytes(continuation, this.serializationMode);
            innerContinuation = ((AggregateCursor.AggregateCursorContinuation)recordCursorContinuation).getInnerContinuation();
            partialAggregationResult = ((AggregateCursor.AggregateCursorContinuation)recordCursorContinuation).getPartialAggregationResult();
        }
        RecordCursor<QueryResult> innerCursor = this.getInnerPlan().executePlan(store, context, innerContinuation, executeProperties.clearSkipAndLimit());
        StreamGrouping<M> streamGrouping = new StreamGrouping<M>(this.groupingKeyValue, this.aggregateValue, this.completeResultValue, this.groupingKeyAlias, this.aggregateAlias, store, context, this.inner.getAlias(), partialAggregationResult);
        return new AggregateCursor<M>(innerCursor, streamGrouping, recordCursorContinuation, this.serializationMode).skipThenLimit(executeProperties.getSkip(), executeProperties.getReturnedRowLimit());
    }

    @Override
    public boolean isReverse() {
        return this.getInnerPlan().isReverse();
    }

    @Override
    @Nonnull
    public List<? extends Quantifier> getQuantifiers() {
        return ImmutableList.of(this.inner);
    }

    @Nonnull
    public Quantifier.Physical getInner() {
        return this.inner;
    }

    @Override
    @Nonnull
    public Set<Type> getDynamicTypes() {
        return ImmutableSet.copyOf(Iterables.concat(RecordQueryPlanWithChild.super.getDynamicTypes(), this.groupingKeyValue == null ? ImmutableSet.of() : this.groupingKeyValue.getDynamicTypes(), this.aggregateValue.getDynamicTypes()));
    }

    @Nonnull
    public String toString() {
        return ExplainPlanVisitor.toStringForDebugging(this);
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        return ImmutableSet.copyOf(Iterables.concat(this.groupingKeyValue == null ? ImmutableSet.of() : this.groupingKeyValue.getCorrelatedTo(), this.aggregateValue.getCorrelatedTo()));
    }

    @Override
    @Nonnull
    public RecordQueryStreamingAggregationPlan translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        Verify.verify(translatedQuantifiers.size() == 1);
        Value translatedGroupingKeyValue = this.groupingKeyValue == null ? null : this.groupingKeyValue.translateCorrelations(translationMap, shouldSimplifyValues);
        AggregateValue translatedAggregateValue = (AggregateValue)this.aggregateValue.translateCorrelations(translationMap, shouldSimplifyValues);
        return new RecordQueryStreamingAggregationPlan(Iterables.getOnlyElement(translatedQuantifiers).narrow(Quantifier.Physical.class), translatedGroupingKeyValue, translatedAggregateValue, this.groupingKeyAlias, this.aggregateAlias, this.completeResultValue, this.serializationMode);
    }

    @Override
    @Nonnull
    public RecordQueryStreamingAggregationPlan withChild(@Nonnull Reference childRef) {
        return new RecordQueryStreamingAggregationPlan(Quantifier.physical(childRef, this.inner.getAlias()), this.groupingKeyValue, this.aggregateValue, this.groupingKeyAlias, this.aggregateAlias, this.completeResultValue, this.serializationMode);
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        return this.completeResultValue;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        RecordQueryStreamingAggregationPlan otherStreamingAggregationPlan = (RecordQueryStreamingAggregationPlan)other;
        return this.structuralEquals(other) && this.serializationMode == otherStreamingAggregationPlan.getSerializationMode();
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap equivalencesMap) {
        if (this == otherExpression) {
            return true;
        }
        if (this.getClass() != otherExpression.getClass()) {
            return false;
        }
        RecordQueryStreamingAggregationPlan otherStreamingAggregationPlan = (RecordQueryStreamingAggregationPlan)otherExpression;
        if (this.serializationMode != otherStreamingAggregationPlan.getSerializationMode()) {
            return false;
        }
        if (this.groupingKeyValue == null && otherStreamingAggregationPlan.getGroupingValue() != null || this.groupingKeyValue != null && otherStreamingAggregationPlan.getGroupingValue() == null) {
            return false;
        }
        if (this.groupingKeyValue != null && !this.groupingKeyValue.semanticEquals((Object)otherStreamingAggregationPlan.getGroupingValue(), equivalencesMap)) {
            return false;
        }
        if (!this.aggregateValue.semanticEquals((Object)otherStreamingAggregationPlan.getAggregateValue(), equivalencesMap)) {
            return false;
        }
        AliasMap extendedEquivalencesMap = equivalencesMap.toBuilder().put(this.groupingKeyAlias, otherStreamingAggregationPlan.getGroupingKeyAlias()).put(this.aggregateAlias, otherStreamingAggregationPlan.getAggregateAlias()).build();
        return this.semanticEqualsForResults(otherExpression, extendedEquivalencesMap);
    }

    public int hashCode() {
        return this.structuralHashCode();
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return Objects.hash(BASE_HASH, this.groupingKeyValue, this.aggregateValue, this.completeResultValue);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.getInnerPlan(), this.groupingKeyValue, this.aggregateValue, this.completeResultValue);
    }

    @Nonnull
    public SerializationMode getSerializationMode() {
        return this.serializationMode;
    }

    @Nonnull
    public RecordQueryPlan getInnerPlan() {
        return this.inner.getRangesOverPlan();
    }

    @Override
    @Nonnull
    public RecordQueryPlan getChild() {
        return this.getInnerPlan();
    }

    @Override
    public void logPlanStructure(StoreTimer timer) {
        timer.increment(FDBStoreTimer.Counts.PLAN_AGGREGATE);
        this.getInnerPlan().logPlanStructure(timer);
    }

    @Override
    public int getComplexity() {
        return 1 + this.getInnerPlan().getComplexity();
    }

    @Override
    @Nonnull
    public PlannerGraph rewritePlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        if (this.groupingKeyValue != null) {
            return PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.OperatorNodeWithInfo(this, NodeInfo.STREAMING_AGGREGATE_OPERATOR, ImmutableList.of("COLLECT {{agg}}", "GROUP BY {{groupingKey}}"), ImmutableMap.of("agg", Attribute.gml(this.aggregateValue.toString()), "groupingKey", Attribute.gml(this.groupingKeyValue.toString()))), childGraphs);
        }
        return PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.OperatorNodeWithInfo(this, NodeInfo.STREAMING_AGGREGATE_OPERATOR, ImmutableList.of("COLLECT {{agg}}"), ImmutableMap.of("agg", Attribute.gml(this.aggregateValue.toString()))), childGraphs);
    }

    @Nonnull
    public AggregateValue getAggregateValue() {
        return this.aggregateValue;
    }

    @Nonnull
    public CorrelationIdentifier getAggregateAlias() {
        return this.aggregateAlias;
    }

    @Nullable
    public Value getGroupingValue() {
        return this.groupingKeyValue;
    }

    @Nonnull
    public CorrelationIdentifier getGroupingKeyAlias() {
        return this.groupingKeyAlias;
    }

    @Nonnull
    public Value getCompleteResultValue() {
        return this.completeResultValue;
    }

    @Override
    @Nonnull
    public Message toProto(@Nonnull PlanSerializationContext serializationContext) {
        if (this.serializationMode == SerializationMode.TO_OLD) {
            return this.toProtoOld(serializationContext);
        }
        return this.toProtoNew(serializationContext);
    }

    @Override
    @Nonnull
    public PRecordQueryPlan toRecordQueryPlanProto(@Nonnull PlanSerializationContext serializationContext) {
        if (this.serializationMode == SerializationMode.TO_OLD) {
            return PRecordQueryPlan.newBuilder().setStreamingAggregationPlan(this.toProtoOld(serializationContext)).build();
        }
        return PRecordQueryPlan.newBuilder().setStreamingAggregationPlan2(this.toProtoNew(serializationContext)).build();
    }

    @Nonnull
    public static RecordQueryStreamingAggregationPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryStreamingAggregationPlan2 recordQueryStreamingAggregationPlanProto) {
        Quantifier.Physical inner = Quantifier.Physical.fromProto(serializationContext, Objects.requireNonNull(recordQueryStreamingAggregationPlanProto.getInner()));
        AggregateValue aggregateValue = (AggregateValue)Value.fromValueProto(serializationContext, Objects.requireNonNull(recordQueryStreamingAggregationPlanProto.getAggregateValue()));
        Value groupingKeyValue = PlanSerialization.getFieldOrNull(recordQueryStreamingAggregationPlanProto, PRecordQueryStreamingAggregationPlan2::hasGroupingKeyValue, m4 -> Value.fromValueProto(serializationContext, m4.getGroupingKeyValue()));
        CorrelationIdentifier groupingKeyAlias = CorrelationIdentifier.of(Objects.requireNonNull(recordQueryStreamingAggregationPlanProto.getGroupingKeyAlias()));
        CorrelationIdentifier aggregateAlias = CorrelationIdentifier.of(Objects.requireNonNull(recordQueryStreamingAggregationPlanProto.getAggregateAlias()));
        Value completeResultValue = Value.fromValueProto(serializationContext, Objects.requireNonNull(recordQueryStreamingAggregationPlanProto.getCompleteResultValue()));
        return new RecordQueryStreamingAggregationPlan(inner, groupingKeyValue, aggregateValue, groupingKeyAlias, aggregateAlias, completeResultValue, SerializationMode.TO_NEW);
    }

    @Nonnull
    public static RecordQueryStreamingAggregationPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryStreamingAggregationPlan recordQueryStreamingAggregationPlanProto) {
        boolean isCreateDefaultOnEmpty;
        Quantifier.Physical inner = Quantifier.Physical.fromProto(serializationContext, Objects.requireNonNull(recordQueryStreamingAggregationPlanProto.getInner()));
        AggregateValue aggregateValue = (AggregateValue)Value.fromValueProto(serializationContext, Objects.requireNonNull(recordQueryStreamingAggregationPlanProto.getAggregateValue()));
        Value groupingKeyValue = PlanSerialization.getFieldOrNull(recordQueryStreamingAggregationPlanProto, PRecordQueryStreamingAggregationPlan::hasGroupingKeyValue, m4 -> Value.fromValueProto(serializationContext, m4.getGroupingKeyValue()));
        CorrelationIdentifier groupingKeyAlias = CorrelationIdentifier.of(Objects.requireNonNull(recordQueryStreamingAggregationPlanProto.getGroupingKeyAlias()));
        CorrelationIdentifier aggregateAlias = CorrelationIdentifier.of(Objects.requireNonNull(recordQueryStreamingAggregationPlanProto.getAggregateAlias()));
        Value completeResultValue = Value.fromValueProto(serializationContext, Objects.requireNonNull(recordQueryStreamingAggregationPlanProto.getCompleteResultValue()));
        boolean bl = isCreateDefaultOnEmpty = recordQueryStreamingAggregationPlanProto.hasIsCreateDefaultOnEmpty() ? recordQueryStreamingAggregationPlanProto.getIsCreateDefaultOnEmpty() : true;
        if (isCreateDefaultOnEmpty) {
            throw new RecordCoreArgumentException("cannot create streaming aggregate plan with default value on empty", new Object[0]);
        }
        return new RecordQueryStreamingAggregationPlan(inner, groupingKeyValue, aggregateValue, groupingKeyAlias, aggregateAlias, completeResultValue, SerializationMode.TO_OLD);
    }

    @Nonnull
    public static RecordQueryStreamingAggregationPlan ofNested(@Nonnull Quantifier.Physical inner, @Nullable Value groupingKeyValue, @Nonnull AggregateValue aggregateValue, @Nonnull SerializationMode serializationMode) {
        return RecordQueryStreamingAggregationPlan.of(inner, groupingKeyValue, aggregateValue, GroupByExpression::nestedResults, serializationMode);
    }

    @Nonnull
    public static RecordQueryStreamingAggregationPlan ofFlattened(@Nonnull Quantifier.Physical inner, @Nullable Value groupingKeyValue, @Nonnull AggregateValue aggregateValue, @Nonnull SerializationMode serializationMode) {
        return RecordQueryStreamingAggregationPlan.of(inner, groupingKeyValue, aggregateValue, GroupByExpression::flattenedResults, serializationMode);
    }

    @Nonnull
    public static RecordQueryStreamingAggregationPlan of(@Nonnull Quantifier.Physical inner, @Nullable Value groupingKeyValue, @Nonnull AggregateValue aggregateValue, @Nonnull BiFunction<Value, Value, Value> resultValueFunction) {
        CorrelationIdentifier groupingKeyAlias = CorrelationIdentifier.uniqueId();
        CorrelationIdentifier aggregateAlias = CorrelationIdentifier.uniqueId();
        ObjectValue referencedGroupingKeyValue = groupingKeyValue == null ? null : ObjectValue.of(groupingKeyAlias, groupingKeyValue.getResultType());
        ObjectValue referencedAggregateValue = ObjectValue.of(aggregateAlias, aggregateValue.getResultType());
        return new RecordQueryStreamingAggregationPlan(inner, groupingKeyValue, aggregateValue, groupingKeyAlias, aggregateAlias, resultValueFunction.apply(referencedGroupingKeyValue, referencedAggregateValue), SerializationMode.TO_NEW);
    }

    @Nonnull
    public static RecordQueryStreamingAggregationPlan of(@Nonnull Quantifier.Physical inner, @Nullable Value groupingKeyValue, @Nonnull AggregateValue aggregateValue, @Nonnull BiFunction<Value, Value, Value> resultValueFunction, @Nonnull SerializationMode serializationMode) {
        CorrelationIdentifier groupingKeyAlias = CorrelationIdentifier.uniqueId();
        CorrelationIdentifier aggregateAlias = CorrelationIdentifier.uniqueId();
        ObjectValue referencedGroupingKeyValue = groupingKeyValue == null ? null : ObjectValue.of(groupingKeyAlias, groupingKeyValue.getResultType());
        ObjectValue referencedAggregateValue = ObjectValue.of(aggregateAlias, aggregateValue.getResultType());
        return new RecordQueryStreamingAggregationPlan(inner, groupingKeyValue, aggregateValue, groupingKeyAlias, aggregateAlias, resultValueFunction.apply(referencedGroupingKeyValue, referencedAggregateValue), serializationMode);
    }

    @Nonnull
    private PRecordQueryStreamingAggregationPlan toProtoOld(@Nonnull PlanSerializationContext serializationContext) {
        PRecordQueryStreamingAggregationPlan.Builder builder = PRecordQueryStreamingAggregationPlan.newBuilder().setInner(this.inner.toProto(serializationContext)).setAggregateValue(this.aggregateValue.toValueProto(serializationContext));
        if (this.groupingKeyValue != null) {
            builder.setGroupingKeyValue(this.groupingKeyValue.toValueProto(serializationContext));
        }
        builder.setGroupingKeyAlias(this.groupingKeyAlias.getId()).setAggregateAlias(this.aggregateAlias.getId()).setCompleteResultValue(this.completeResultValue.toValueProto(serializationContext)).setIsCreateDefaultOnEmpty(false);
        return builder.build();
    }

    @Nonnull
    private PRecordQueryStreamingAggregationPlan2 toProtoNew(@Nonnull PlanSerializationContext serializationContext) {
        PRecordQueryStreamingAggregationPlan2.Builder builder = PRecordQueryStreamingAggregationPlan2.newBuilder().setInner(this.inner.toProto(serializationContext)).setAggregateValue(this.aggregateValue.toValueProto(serializationContext));
        if (this.groupingKeyValue != null) {
            builder.setGroupingKeyValue(this.groupingKeyValue.toValueProto(serializationContext));
        }
        builder.setGroupingKeyAlias(this.groupingKeyAlias.getId()).setAggregateAlias(this.aggregateAlias.getId()).setCompleteResultValue(this.completeResultValue.toValueProto(serializationContext));
        return builder.build();
    }

    public static enum SerializationMode {
        TO_OLD,
        TO_NEW;

    }

    public static class OldDeserializer
    implements PlanDeserializer<PRecordQueryStreamingAggregationPlan, RecordQueryStreamingAggregationPlan> {
        @Override
        @Nonnull
        public Class<PRecordQueryStreamingAggregationPlan> getProtoMessageClass() {
            return PRecordQueryStreamingAggregationPlan.class;
        }

        @Override
        @Nonnull
        public RecordQueryStreamingAggregationPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryStreamingAggregationPlan recordQueryStreamingAggregationPlanProto) {
            return RecordQueryStreamingAggregationPlan.fromProto(serializationContext, recordQueryStreamingAggregationPlanProto);
        }
    }

    public static class Deserializer
    implements PlanDeserializer<PRecordQueryStreamingAggregationPlan2, RecordQueryStreamingAggregationPlan> {
        @Override
        @Nonnull
        public Class<PRecordQueryStreamingAggregationPlan2> getProtoMessageClass() {
            return PRecordQueryStreamingAggregationPlan2.class;
        }

        @Override
        @Nonnull
        public RecordQueryStreamingAggregationPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryStreamingAggregationPlan2 recordQueryStreamingAggregationPlanProto) {
            return RecordQueryStreamingAggregationPlan.fromProto(serializationContext, recordQueryStreamingAggregationPlanProto);
        }
    }
}

