/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.planprotos.PRecordQueryPlan;
import com.apple.foundationdb.record.planprotos.PRecordQueryTableFunctionPlan;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.AvailableFields;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.FinalMemoizer;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.apple.foundationdb.record.query.plan.cascades.explain.ExplainPlanVisitor;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithoutChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.QueriedValue;
import com.apple.foundationdb.record.query.plan.cascades.values.StreamingValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithNoChildren;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class RecordQueryTableFunctionPlan
extends AbstractRelationalExpressionWithoutChildren
implements RecordQueryPlanWithNoChildren {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Table-Function-Plan");
    @Nonnull
    private final StreamingValue value;

    public RecordQueryTableFunctionPlan(@Nonnull StreamingValue collectionValue) {
        this.value = collectionValue;
    }

    @Override
    @Nonnull
    public <M extends Message> RecordCursor<QueryResult> executePlan(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        return this.value.evalAsStream(store, context, continuation, executeProperties);
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        return this.value.getCorrelatedTo();
    }

    @Override
    @Nonnull
    public RecordQueryTableFunctionPlan translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        Verify.verify(translatedQuantifiers.isEmpty());
        if (translationMap.definesOnlyIdentities()) {
            return this;
        }
        Value translatedValue = this.value.translateCorrelations(translationMap, shouldSimplifyValues);
        if (translatedValue != this.value) {
            return new RecordQueryTableFunctionPlan((StreamingValue)translatedValue);
        }
        return this;
    }

    @Override
    public boolean isReverse() {
        return false;
    }

    @Override
    public RecordQueryTableFunctionPlan strictlySorted(@Nonnull FinalMemoizer memoizer) {
        return this;
    }

    @Override
    public boolean hasRecordScan() {
        return false;
    }

    @Override
    public boolean hasFullRecordScan() {
        return false;
    }

    @Override
    public boolean hasIndexScan(@Nonnull String indexName) {
        return false;
    }

    @Override
    @Nonnull
    public Set<String> getUsedIndexes() {
        return ImmutableSet.of();
    }

    @Override
    public boolean hasLoadBykeys() {
        return false;
    }

    @Override
    @Nonnull
    public AvailableFields getAvailableFields() {
        return AvailableFields.NO_FIELDS;
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        return new QueriedValue(this.value.getResultType());
    }

    @Nonnull
    public StreamingValue getValue() {
        return this.value;
    }

    @Override
    @Nonnull
    public Set<Type> getDynamicTypes() {
        return this.value.getDynamicTypes();
    }

    @Nonnull
    public String toString() {
        return ExplainPlanVisitor.toStringForDebugging(this);
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap equivalencesMap) {
        if (this == otherExpression) {
            return true;
        }
        if (this.getClass() != otherExpression.getClass()) {
            return false;
        }
        RecordQueryTableFunctionPlan otherTableFunctionPlan = (RecordQueryTableFunctionPlan)otherExpression;
        return this.value.semanticEquals((Object)otherTableFunctionPlan.value, equivalencesMap);
    }

    public boolean equals(Object other) {
        return this.structuralEquals(other);
    }

    public int hashCode() {
        return this.structuralHashCode();
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return Objects.hash(this.getResultValue());
    }

    @Override
    public void logPlanStructure(StoreTimer timer) {
    }

    @Override
    public int getComplexity() {
        return 1;
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: 
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.getResultValue());
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    @Override
    @Nonnull
    public PlannerGraph rewritePlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        return PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.OperatorNodeWithInfo(this, NodeInfo.VALUE_COMPUTATION_OPERATOR, ImmutableList.of("TFUNC {{expr}}"), ImmutableMap.of("expr", Attribute.gml(this.value.toString()))), childGraphs);
    }

    @Override
    @Nonnull
    public PRecordQueryTableFunctionPlan toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryTableFunctionPlan.newBuilder().setValue(this.value.toValueProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PRecordQueryPlan toRecordQueryPlanProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryPlan.newBuilder().setTableFunctionPlan(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static RecordQueryTableFunctionPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryTableFunctionPlan recordQueryTableFunctionPlanProto) {
        Value value = Value.fromValueProto(serializationContext, Objects.requireNonNull(recordQueryTableFunctionPlanProto.getValue()));
        if (!(value instanceof StreamingValue)) {
            throw new RecordCoreException("invalid value, expecting streaming value", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.VALUE, value});
        }
        return new RecordQueryTableFunctionPlan((StreamingValue)value);
    }

    public static class Deserializer
    implements PlanDeserializer<PRecordQueryTableFunctionPlan, RecordQueryTableFunctionPlan> {
        @Override
        @Nonnull
        public Class<PRecordQueryTableFunctionPlan> getProtoMessageClass() {
            return PRecordQueryTableFunctionPlan.class;
        }

        @Override
        @Nonnull
        public RecordQueryTableFunctionPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryTableFunctionPlan message) {
            return RecordQueryTableFunctionPlan.fromProto(serializationContext, message);
        }
    }
}

