/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.IndexScanType;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.planprotos.PRecordQueryPlan;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.query.plan.AvailableFields;
import com.apple.foundationdb.record.query.plan.TextScan;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.MatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.apple.foundationdb.record.query.plan.cascades.explain.ExplainPlanVisitor;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithoutChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.values.QueriedValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFetchFromPartialRecordPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithIndex;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithNoChildren;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Message;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class RecordQueryTextIndexPlan
extends AbstractRelationalExpressionWithoutChildren
implements RecordQueryPlanWithIndex,
RecordQueryPlanWithNoChildren {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Record-Query-Text-Index-Plan");
    @Nonnull
    private final String indexName;
    @Nonnull
    private final TextScan textScan;
    private final boolean reverse;

    public RecordQueryTextIndexPlan(@Nonnull String indexName, @Nonnull TextScan textScan, boolean reverse) {
        this.indexName = indexName;
        this.textScan = textScan;
        this.reverse = reverse;
    }

    @Override
    @Nonnull
    public <M extends Message> RecordCursor<IndexEntry> executeEntries(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        return this.textScan.scan(store, context, continuation, executeProperties.asScanProperties(this.reverse));
    }

    @Override
    @Nonnull
    public String getIndexName() {
        return this.indexName;
    }

    @Override
    @Nonnull
    public IndexScanType getScanType() {
        return IndexScanType.BY_TEXT_TOKEN;
    }

    @Nonnull
    public TextScan getTextScan() {
        return this.textScan;
    }

    @Override
    public boolean isReverse() {
        return this.reverse;
    }

    @Override
    public boolean hasRecordScan() {
        return false;
    }

    @Override
    public boolean hasFullRecordScan() {
        return false;
    }

    @Override
    public boolean hasIndexScan(@Nonnull String indexName) {
        return this.indexName.equals(indexName);
    }

    @Override
    @Nonnull
    public Set<String> getUsedIndexes() {
        return Collections.singleton(this.indexName);
    }

    @Override
    public boolean hasLoadBykeys() {
        return false;
    }

    @Override
    public void logPlanStructure(StoreTimer timer) {
        timer.increment(FDBStoreTimer.Counts.PLAN_INDEX);
    }

    @Override
    public int getComplexity() {
        return 1;
    }

    @Override
    @Nonnull
    public AvailableFields getAvailableFields() {
        return AvailableFields.ALL_FIELDS;
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        return ImmutableSet.of();
    }

    @Override
    @Nonnull
    public RecordQueryTextIndexPlan translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        return this;
    }

    @Override
    @Nonnull
    public Optional<? extends MatchCandidate> getMatchCandidateMaybe() {
        return Optional.empty();
    }

    @Override
    @Nonnull
    public RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords getFetchIndexRecords() {
        return RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords.PRIMARY_KEY;
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        return new QueriedValue();
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap equivalencesMap) {
        if (this == otherExpression) {
            return true;
        }
        if (this.getClass() != otherExpression.getClass()) {
            return false;
        }
        RecordQueryTextIndexPlan that = (RecordQueryTextIndexPlan)otherExpression;
        return this.reverse == that.reverse && this.indexName.equals(that.indexName) && this.textScan.equals(that.textScan);
    }

    public boolean equals(Object other) {
        return this.structuralEquals(other);
    }

    public int hashCode() {
        return this.structuralHashCode();
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return Objects.hash(this.indexName, this.textScan, this.reverse);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: {
                return this.indexName.hashCode() + this.textScan.planHash(mode) + (this.reverse ? 1 : 0);
            }
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.indexName, this.textScan, this.reverse);
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    @Nonnull
    public String toString() {
        return ExplainPlanVisitor.toStringForDebugging(this);
    }

    @Override
    @Nonnull
    public PlannerGraph rewritePlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        Verify.verify(childGraphs.isEmpty());
        return this.createIndexPlannerGraph(this, NodeInfo.TEXT_INDEX_SCAN_OPERATOR, ImmutableList.of(), ImmutableMap.of());
    }

    @Override
    @Nonnull
    public PlannerGraph createIndexPlannerGraph(@Nonnull RecordQueryPlan identity, @Nonnull NodeInfo nodeInfo, @Nonnull List<String> additionalDetails, @Nonnull Map<String, Attribute> additionalAttributeMap) {
        ImmutableList.Builder detailsBuilder = ImmutableList.builder();
        ImmutableMap.Builder<String, Attribute> attributeMapBuilder = ImmutableMap.builder();
        detailsBuilder.addAll(additionalDetails);
        detailsBuilder.add(new String[]{"grouping comparisons: {{groupingComparisons}}", "text comparisons: {{textComparisons}}", "suffix comparisons: {{suffixComparisons}}"});
        attributeMapBuilder.putAll(additionalAttributeMap);
        if (this.textScan.getGroupingComparisons() != null) {
            attributeMapBuilder.put("groupingComparisons", Attribute.gml(Objects.requireNonNull(this.textScan.getGroupingComparisons()).toString()));
        } else {
            attributeMapBuilder.put("groupingComparisons", Attribute.gml("none"));
        }
        if (this.textScan.getSuffixComparisons() != null) {
            attributeMapBuilder.put("suffixComparisons", Attribute.gml(Objects.requireNonNull(this.textScan.getSuffixComparisons()).toString()));
        } else {
            attributeMapBuilder.put("suffixComparisons", Attribute.gml("none"));
        }
        attributeMapBuilder.put("textComparisons", Attribute.gml(Objects.requireNonNull(this.textScan.getTextComparison()).toString()));
        PlannerGraph.OperatorNodeWithInfo root = new PlannerGraph.OperatorNodeWithInfo(this, nodeInfo, (List<String>)((Object)detailsBuilder.build()), attributeMapBuilder.build());
        PlannerGraph.DataNodeWithInfo source = new PlannerGraph.DataNodeWithInfo(NodeInfo.INDEX_DATA, this.getResultType(), ImmutableList.of(this.getIndexName()));
        return (PlannerGraph)PlannerGraph.builder(root).addNode(source).addEdge(source, (PlannerGraph.DataNodeWithInfo)((Object)root), new PlannerGraph.Edge()).build();
    }

    @Override
    @Nonnull
    public Message toProto(@Nonnull PlanSerializationContext serializationContext) {
        throw new RecordCoreException("serialization of this plan is not supported", new Object[0]);
    }

    @Override
    @Nonnull
    public PRecordQueryPlan toRecordQueryPlanProto(@Nonnull PlanSerializationContext serializationContext) {
        throw new RecordCoreException("serialization of this plan is not supported", new Object[0]);
    }
}

