/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.planprotos.PRecordQueryPlan;
import com.apple.foundationdb.record.planprotos.PRecordQueryTypeFilterPlan;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.query.plan.HeuristicPlanner;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.debug.Debugger;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.apple.foundationdb.record.query.plan.cascades.explain.ExplainPlanVisitor;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.TypeFilterExpression;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithChild;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.INTERNAL)
public class RecordQueryTypeFilterPlan
extends AbstractRelationalExpressionWithChildren
implements RecordQueryPlanWithChild,
TypeFilterExpression {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Record-Query-Type-Filter-Plan");
    public static final Logger LOGGER = LoggerFactory.getLogger(RecordQueryTypeFilterPlan.class);
    @Nonnull
    private final Quantifier.Physical inner;
    @Nonnull
    private final Collection<String> recordTypes;
    @Nonnull
    private final Type resultType;
    @Nonnull
    private static final Set<StoreTimer.Count> inCounts = ImmutableSet.of(FDBStoreTimer.Counts.QUERY_FILTER_GIVEN, FDBStoreTimer.Counts.QUERY_TYPE_FILTER_PLAN_GIVEN);
    @Nonnull
    private static final Set<StoreTimer.Event> duringEvents = Collections.singleton(FDBStoreTimer.Events.QUERY_TYPE_FILTER);
    @Nonnull
    private static final Set<StoreTimer.Count> successCounts = ImmutableSet.of(FDBStoreTimer.Counts.QUERY_FILTER_PASSED, FDBStoreTimer.Counts.QUERY_TYPE_FILTER_PLAN_PASSED);
    @Nonnull
    private static final Set<StoreTimer.Count> failureCounts = Collections.singleton(FDBStoreTimer.Counts.QUERY_DISCARDED);

    @HeuristicPlanner
    public RecordQueryTypeFilterPlan(@Nonnull RecordQueryPlan inner, @Nonnull Collection<String> recordTypes) {
        this(Quantifier.physical(Reference.plannedOf(Debugger.verifyHeuristicPlanner(inner))), recordTypes, new Type.Any());
    }

    public RecordQueryTypeFilterPlan(@Nonnull Quantifier.Physical inner, @Nonnull Collection<String> recordTypes, @Nonnull Type resultType) {
        this.inner = inner;
        this.recordTypes = recordTypes;
        this.resultType = resultType;
    }

    @Override
    @Nonnull
    public <M extends Message> RecordCursor<QueryResult> executePlan(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        RecordCursor<QueryResult> results = this.getInnerPlan().executePlan(store, context, continuation, executeProperties.clearSkipAndLimit());
        return results.filterInstrumented(result -> this.recordTypes.contains(Objects.requireNonNull(result.getRecordType()).getName()), (StoreTimer)store.getTimer(), inCounts, duringEvents, successCounts, failureCounts).skipThenLimit(executeProperties.getSkip(), executeProperties.getReturnedRowLimit());
    }

    @Override
    public boolean isReverse() {
        return this.getInnerPlan().isReverse();
    }

    @Override
    @Nonnull
    public List<? extends Quantifier> getQuantifiers() {
        return ImmutableList.of(this.inner);
    }

    @Nonnull
    public String toString() {
        return ExplainPlanVisitor.toStringForDebugging(this);
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        return ImmutableSet.of();
    }

    @Override
    @Nonnull
    public RecordQueryTypeFilterPlan translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        return new RecordQueryTypeFilterPlan(Iterables.getOnlyElement(translatedQuantifiers).narrow(Quantifier.Physical.class), this.getRecordTypes(), this.resultType);
    }

    @Override
    @Nonnull
    public RecordQueryPlanWithChild withChild(@Nonnull Reference childRef) {
        return new RecordQueryTypeFilterPlan(Quantifier.physical(childRef, this.inner.getAlias()), this.getRecordTypes(), this.resultType);
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        return QuantifiedObjectValue.of(this.inner.getAlias(), this.resultType);
    }

    public boolean equals(Object other) {
        return this.structuralEquals(other);
    }

    public int hashCode() {
        return this.structuralHashCode();
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return TypeFilterExpression.super.computeHashCodeWithoutChildren();
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: {
                return this.getInnerPlan().planHash(mode) + RecordQueryTypeFilterPlan.stringHashUnordered(this.recordTypes);
            }
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.getInnerPlan(), RecordQueryTypeFilterPlan.stringHashUnordered(this.recordTypes));
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    @Nonnull
    public RecordQueryPlan getInnerPlan() {
        return this.inner.getRangesOverPlan();
    }

    @Override
    @Nonnull
    public RecordQueryPlan getChild() {
        return this.getInnerPlan();
    }

    @Override
    @Nonnull
    public Collection<String> getRecordTypes() {
        return this.recordTypes;
    }

    @Override
    public void logPlanStructure(StoreTimer timer) {
        timer.increment(FDBStoreTimer.Counts.PLAN_TYPE_FILTER);
        this.getInnerPlan().logPlanStructure(timer);
    }

    @Override
    public int getComplexity() {
        return 1 + this.getInnerPlan().getComplexity();
    }

    @Override
    @Nonnull
    public PlannerGraph rewritePlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        return PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.OperatorNodeWithInfo(this, NodeInfo.TYPE_FILTER_OPERATOR, ImmutableList.of("WHERE record IS {{types}}"), ImmutableMap.of("types", Attribute.gml(this.getRecordTypes().stream().map(Attribute::gml).collect(ImmutableList.toImmutableList())))), childGraphs);
    }

    @Override
    @Nonnull
    public PRecordQueryTypeFilterPlan toProto(@Nonnull PlanSerializationContext serializationContext) {
        PRecordQueryTypeFilterPlan.Builder builder = PRecordQueryTypeFilterPlan.newBuilder().setInner(this.inner.toProto(serializationContext));
        for (String recordType : this.recordTypes) {
            builder.addRecordTypes(recordType);
        }
        builder.setResultType(this.resultType.toTypeProto(serializationContext));
        return builder.build();
    }

    @Override
    @Nonnull
    public PRecordQueryPlan toRecordQueryPlanProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryPlan.newBuilder().setTypeFilterPlan(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static RecordQueryTypeFilterPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryTypeFilterPlan recordQueryTypeFilterPlanProto) {
        Quantifier.Physical q = Quantifier.Physical.fromProto(serializationContext, Objects.requireNonNull(recordQueryTypeFilterPlanProto.getInner()));
        ImmutableSet.Builder recordTypesBuilder = ImmutableSet.builder();
        for (int i = 0; i < recordQueryTypeFilterPlanProto.getRecordTypesCount(); ++i) {
            recordTypesBuilder.add(recordQueryTypeFilterPlanProto.getRecordTypes(i));
        }
        return new RecordQueryTypeFilterPlan(q, recordTypesBuilder.build(), Type.fromTypeProto(serializationContext, Objects.requireNonNull(recordQueryTypeFilterPlanProto.getResultType())));
    }

    private static int stringHashUnordered(@Nonnull Iterable<String> strings) {
        ArrayList<Integer> hashes = new ArrayList<Integer>();
        for (String str : strings) {
            hashes.add(str != null ? str.hashCode() : 0);
        }
        hashes.sort(Comparator.naturalOrder());
        return PlanHashable.combineHashes(hashes);
    }

    public static class Deserializer
    implements PlanDeserializer<PRecordQueryTypeFilterPlan, RecordQueryTypeFilterPlan> {
        @Override
        @Nonnull
        public Class<PRecordQueryTypeFilterPlan> getProtoMessageClass() {
            return PRecordQueryTypeFilterPlan.class;
        }

        @Override
        @Nonnull
        public RecordQueryTypeFilterPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryTypeFilterPlan recordQueryTypeFilterPlanProto) {
            return RecordQueryTypeFilterPlan.fromProto(serializationContext, recordQueryTypeFilterPlanProto);
        }
    }
}

