/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.planprotos.PRecordQueryPlan;
import com.apple.foundationdb.record.planprotos.PRecordQueryUnionOnValuesPlan;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.OrderingPart;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifiers;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.DefaultValueSimplificationRuleSet;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithComparisonKeyValues;
import com.apple.foundationdb.record.query.plan.plans.RecordQuerySetPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnionPlan;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RecordQueryUnionOnValuesPlan
extends RecordQueryUnionPlan
implements RecordQueryPlanWithComparisonKeyValues {
    @Nullable
    private final List<OrderingPart.ProvidedOrderingPart> comparisonKeyOrderingParts;

    protected RecordQueryUnionOnValuesPlan(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryUnionOnValuesPlan recordQueryUnionOnValuesPlanProto) {
        super(serializationContext, Objects.requireNonNull(recordQueryUnionOnValuesPlanProto.getSuper()));
        this.comparisonKeyOrderingParts = null;
    }

    public RecordQueryUnionOnValuesPlan(@Nonnull List<Quantifier.Physical> quantifiers, @Nullable List<OrderingPart.ProvidedOrderingPart> comparisonKeyOrderingParts, @Nonnull List<? extends Value> comparisonKeyValues, boolean isReverse, boolean showComparisonKey) {
        super(quantifiers, new RecordQuerySetPlan.ComparisonKeyFunction.OnValues(Quantifier.current(), comparisonKeyValues), isReverse, showComparisonKey);
        this.comparisonKeyOrderingParts = comparisonKeyOrderingParts == null ? null : ImmutableList.copyOf(comparisonKeyOrderingParts);
    }

    @Override
    @Nonnull
    public RecordQuerySetPlan.ComparisonKeyFunction.OnValues getComparisonKeyFunction() {
        return (RecordQuerySetPlan.ComparisonKeyFunction.OnValues)super.getComparisonKeyFunction();
    }

    @Override
    @Nonnull
    public List<? extends Value> getRequiredValues(@Nonnull CorrelationIdentifier newBaseAlias, @Nonnull Type inputType) {
        DefaultValueSimplificationRuleSet ruleSet = DefaultValueSimplificationRuleSet.instance();
        return this.getComparisonKeyValues().stream().map(comparisonKeyValue -> comparisonKeyValue.rebase(AliasMap.ofAliases(Quantifier.current(), newBaseAlias)).simplify(ruleSet, EvaluationContext.empty(), AliasMap.emptyMap(), this.getCorrelatedTo())).collect(ImmutableList.toImmutableList());
    }

    @Override
    @Nonnull
    public Set<KeyExpression> getRequiredFields() {
        throw new RecordCoreException("this plan does not support this getRequiredFields()", new Object[0]);
    }

    @Override
    @Nonnull
    public List<OrderingPart.ProvidedOrderingPart> getComparisonKeyOrderingParts() {
        return Objects.requireNonNull(this.comparisonKeyOrderingParts);
    }

    @Override
    @Nonnull
    public List<? extends Value> getComparisonKeyValues() {
        return this.getComparisonKeyFunction().getComparisonKeyValues();
    }

    @Override
    @Nonnull
    public Set<Type> getDynamicTypes() {
        return this.getComparisonKeyValues().stream().flatMap(comparisonKeyValue -> comparisonKeyValue.getDynamicTypes().stream()).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    @Nonnull
    public RecordQueryUnionOnValuesPlan translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        return new RecordQueryUnionOnValuesPlan(Quantifiers.narrow(Quantifier.Physical.class, translatedQuantifiers), this.comparisonKeyOrderingParts, this.getComparisonKeyValues(), this.isReverse(), this.showComparisonKey);
    }

    @Override
    @Nonnull
    public RecordQueryUnionOnValuesPlan withChildrenReferences(@Nonnull List<? extends Reference> newChildren) {
        return new RecordQueryUnionOnValuesPlan(newChildren.stream().map(Quantifier::physical).collect(ImmutableList.toImmutableList()), this.comparisonKeyOrderingParts, this.getComparisonKeyValues(), this.isReverse(), this.showComparisonKey);
    }

    @Override
    @Nonnull
    public PRecordQueryUnionOnValuesPlan toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryUnionOnValuesPlan.newBuilder().setSuper(this.toRecordQueryUnionPlanProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PRecordQueryPlan toRecordQueryPlanProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryPlan.newBuilder().setUnionOnValuesPlan(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static RecordQueryUnionOnValuesPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryUnionOnValuesPlan recordQueryUnionOnValuesPlanProto) {
        return new RecordQueryUnionOnValuesPlan(serializationContext, recordQueryUnionOnValuesPlanProto);
    }

    @Nonnull
    public static RecordQueryUnionOnValuesPlan union(@Nonnull List<Quantifier.Physical> quantifiers, @Nonnull List<OrderingPart.ProvidedOrderingPart> comparisonKeyOrderingParts, boolean isReverse, boolean showComparisonKey) {
        return new RecordQueryUnionOnValuesPlan(quantifiers, comparisonKeyOrderingParts, OrderingPart.ProvidedOrderingPart.comparisonKeyValues(comparisonKeyOrderingParts, isReverse), isReverse, showComparisonKey);
    }

    public static class Deserializer
    implements PlanDeserializer<PRecordQueryUnionOnValuesPlan, RecordQueryUnionOnValuesPlan> {
        @Override
        @Nonnull
        public Class<PRecordQueryUnionOnValuesPlan> getProtoMessageClass() {
            return PRecordQueryUnionOnValuesPlan.class;
        }

        @Override
        @Nonnull
        public RecordQueryUnionOnValuesPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryUnionOnValuesPlan recordQueryUnionOnValuesPlanProto) {
            return RecordQueryUnionOnValuesPlan.fromProto(serializationContext, recordQueryUnionOnValuesPlanProto);
        }
    }
}

