/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.planprotos.PRecordQueryUnionPlan;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.cursors.UnionCursor;
import com.apple.foundationdb.record.query.plan.HeuristicPlanner;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.OrderingPart;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifiers;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.debug.Debugger;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQuerySetPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnionOnKeyExpressionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnionOnValuesPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnionPlanBase;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.INTERNAL)
public abstract class RecordQueryUnionPlan
extends RecordQueryUnionPlanBase {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Record-Query-Union-Plan");
    public static final Logger LOGGER = LoggerFactory.getLogger(RecordQueryUnionPlan.class);
    private static final StoreTimer.Count PLAN_COUNT = FDBStoreTimer.Counts.PLAN_UNION;
    @Nonnull
    private final RecordQuerySetPlan.ComparisonKeyFunction comparisonKeyFunction;
    protected final boolean showComparisonKey;

    protected RecordQueryUnionPlan(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryUnionPlan recordQueryUnionPlanProto) {
        super(serializationContext, Objects.requireNonNull(recordQueryUnionPlanProto.getSuper()));
        Verify.verify(recordQueryUnionPlanProto.hasShowComparisonKey());
        this.comparisonKeyFunction = RecordQuerySetPlan.ComparisonKeyFunction.fromComparisonKeyFunctionProto(serializationContext, Objects.requireNonNull(recordQueryUnionPlanProto.getComparisonKeyFunction()));
        this.showComparisonKey = recordQueryUnionPlanProto.getShowComparisonKey();
    }

    protected RecordQueryUnionPlan(@Nonnull List<Quantifier.Physical> quantifiers, @Nonnull RecordQuerySetPlan.ComparisonKeyFunction comparisonKeyFunction, boolean reverse, boolean showComparisonKey) {
        super(quantifiers, reverse);
        this.comparisonKeyFunction = comparisonKeyFunction;
        this.showComparisonKey = showComparisonKey;
    }

    @Override
    @Nonnull
    <M extends Message> RecordCursor<QueryResult> createUnionCursor(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nonnull List<Function<byte[], RecordCursor<QueryResult>>> childCursorFunctions, @Nullable byte[] continuation) {
        return UnionCursor.create(this.comparisonKeyFunction.apply(store, context), this.isReverse(), childCursorFunctions, continuation, store.getTimer());
    }

    @Nonnull
    public RecordQuerySetPlan.ComparisonKeyFunction getComparisonKeyFunction() {
        return this.comparisonKeyFunction;
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        return ImmutableSet.of();
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap equivalencesMap) {
        if (this == otherExpression) {
            return true;
        }
        if (!super.equalsWithoutChildren(otherExpression, equivalencesMap)) {
            return false;
        }
        RecordQueryUnionPlan other = (RecordQueryUnionPlan)otherExpression;
        return this.comparisonKeyFunction.equals(other.comparisonKeyFunction);
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return Objects.hash(super.computeHashCodeWithoutChildren(), this.comparisonKeyFunction, this.isReverse());
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: {
                return super.basePlanHash(mode, BASE_HASH, new Object[0]) + this.comparisonKeyFunction.planHash(mode);
            }
            case FOR_CONTINUATION: {
                return super.basePlanHash(mode, BASE_HASH, this.comparisonKeyFunction);
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    @Override
    @Nonnull
    public String getDelimiter() {
        return " \u222a" + (this.showComparisonKey ? this.comparisonKeyFunction.toString() : "") + " ";
    }

    @Override
    @Nonnull
    StoreTimer.Count getPlanCount() {
        return PLAN_COUNT;
    }

    @Nonnull
    protected PRecordQueryUnionPlan toRecordQueryUnionPlanProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryUnionPlan.newBuilder().setSuper(this.toRecordQueryUnionPlanBaseProto(serializationContext)).setComparisonKeyFunction(this.comparisonKeyFunction.toComparisonKeyFunctionProto(serializationContext)).setShowComparisonKey(this.showComparisonKey).build();
    }

    @Nonnull
    public static RecordQueryUnionOnKeyExpressionPlan fromQuantifiers(@Nonnull List<Quantifier.Physical> quantifiers, @Nonnull KeyExpression comparisonKey, boolean showComparisonKey) {
        return new RecordQueryUnionOnKeyExpressionPlan(quantifiers, comparisonKey, Quantifiers.isReversed(quantifiers), showComparisonKey);
    }

    @Nonnull
    public static RecordQueryUnionOnValuesPlan fromQuantifiers(@Nonnull List<Quantifier.Physical> quantifiers, @Nonnull List<OrderingPart.ProvidedOrderingPart> comparisonKeyOrderingParts, boolean isReverse, boolean showComparisonKey) {
        return RecordQueryUnionOnValuesPlan.union(quantifiers, comparisonKeyOrderingParts, isReverse, showComparisonKey);
    }

    @Nonnull
    @HeuristicPlanner
    public static RecordQueryUnionOnKeyExpressionPlan from(@Nonnull RecordQueryPlan left, @Nonnull RecordQueryPlan right, @Nonnull KeyExpression comparisonKey, boolean showComparisonKey) {
        Debugger.verifyHeuristicPlanner();
        if (left.isReverse() != right.isReverse()) {
            throw new RecordCoreArgumentException("left plan and right plan for union do not have same value for reverse field", new Object[0]);
        }
        ImmutableList<Reference> childRefs = ImmutableList.of(Reference.plannedOf(left), Reference.plannedOf(right));
        return new RecordQueryUnionOnKeyExpressionPlan(Quantifiers.fromPlans(childRefs), comparisonKey, left.isReverse(), showComparisonKey);
    }

    @Nonnull
    @HeuristicPlanner
    public static RecordQueryUnionOnKeyExpressionPlan from(@Nonnull List<? extends RecordQueryPlan> children, @Nonnull KeyExpression comparisonKey, boolean showComparisonKey) {
        Debugger.verifyHeuristicPlanner();
        if (children.size() < 2) {
            throw new RecordCoreArgumentException("fewer than two children given to union plan", new Object[0]);
        }
        boolean firstReverse = children.get(0).isReverse();
        if (!children.stream().allMatch(child -> child.isReverse() == firstReverse)) {
            throw new RecordCoreArgumentException("children of union plan do all have same value for reverse field", new Object[0]);
        }
        ImmutableList.Builder childRefsBuilder = ImmutableList.builder();
        for (RecordQueryPlan recordQueryPlan : children) {
            childRefsBuilder.add(Reference.plannedOf(recordQueryPlan));
        }
        return new RecordQueryUnionOnKeyExpressionPlan(Quantifiers.fromPlans(childRefsBuilder.build()), comparisonKey, firstReverse, showComparisonKey);
    }

    @Override
    @Nonnull
    public PlannerGraph rewritePlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        return PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.OperatorNodeWithInfo(this, NodeInfo.UNION_OPERATOR, ImmutableList.of("COMPARE BY {{comparisonKeyFunction}}"), ImmutableMap.of("comparisonKeyFunction", Attribute.gml(this.comparisonKeyFunction.toString()))), childGraphs);
    }
}

