/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.planprotos.PRecordQueryUnionPlanBase;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.AvailableFields;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.FinalMemoizer;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.explain.ExplainPlanVisitor;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.plans.QueryPlan;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithChildren;
import com.apple.foundationdb.record.query.plan.plans.RecordQuerySetPlan;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.INTERNAL)
public abstract class RecordQueryUnionPlanBase
extends AbstractRelationalExpressionWithChildren
implements RecordQueryPlanWithChildren,
RecordQuerySetPlan {
    public static final Logger LOGGER = LoggerFactory.getLogger(RecordQueryUnionPlanBase.class);
    protected static final String UNION = "\u222a";
    @Nonnull
    private final List<Quantifier.Physical> quantifiers;
    private final boolean reverse;
    @Nonnull
    private final Value resultValue;

    protected RecordQueryUnionPlanBase(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryUnionPlanBase recordQueryUnionPlanBaseProto) {
        Verify.verify(recordQueryUnionPlanBaseProto.getQuantifiersCount() > 0);
        Verify.verify(recordQueryUnionPlanBaseProto.hasReverse());
        ImmutableList.Builder quantifiersBuilder = ImmutableList.builder();
        for (int i = 0; i < recordQueryUnionPlanBaseProto.getQuantifiersCount(); ++i) {
            quantifiersBuilder.add(Quantifier.Physical.fromProto(serializationContext, recordQueryUnionPlanBaseProto.getQuantifiers(i)));
        }
        this.quantifiers = quantifiersBuilder.build();
        this.reverse = recordQueryUnionPlanBaseProto.getReverse();
        this.resultValue = RecordQuerySetPlan.mergeValues(this.quantifiers);
    }

    protected RecordQueryUnionPlanBase(@Nonnull List<Quantifier.Physical> quantifiers, boolean reverse) {
        Verify.verify(!quantifiers.isEmpty());
        this.quantifiers = ImmutableList.copyOf(quantifiers);
        this.reverse = reverse;
        this.resultValue = RecordQuerySetPlan.mergeValues(quantifiers);
    }

    @Nonnull
    abstract <M extends Message> RecordCursor<QueryResult> createUnionCursor(@Nonnull FDBRecordStoreBase<M> var1, @Nonnull EvaluationContext var2, @Nonnull List<Function<byte[], RecordCursor<QueryResult>>> var3, @Nullable byte[] var4);

    @Override
    @Nonnull
    public <M extends Message> RecordCursor<QueryResult> executePlan(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        ExecuteProperties childExecuteProperties = executeProperties.getSkip() > 0 ? executeProperties.clearSkipAndAdjustLimit() : executeProperties;
        List<Function<byte[], RecordCursor<QueryResult>>> childCursorFunctions = this.getChildStream().map(childPlan -> childContinuation -> childPlan.executePlan(store, context, (byte[])childContinuation, childExecuteProperties)).collect(Collectors.toList());
        return this.createUnionCursor(store, context, childCursorFunctions, continuation).skipThenLimit(executeProperties.getSkip(), executeProperties.getReturnedRowLimit());
    }

    @Override
    public boolean isReverse() {
        return this.reverse;
    }

    @Nonnull
    private Stream<RecordQueryPlan> getChildStream() {
        return this.quantifiers.stream().map(Quantifier.Physical::getRangesOverPlan);
    }

    @Override
    @Nonnull
    public List<RecordQueryPlan> getChildren() {
        return this.getChildStream().collect(Collectors.toList());
    }

    @Override
    @Nonnull
    public List<? extends Quantifier> getQuantifiers() {
        return this.quantifiers;
    }

    @Override
    @Nonnull
    public AvailableFields getAvailableFields() {
        return AvailableFields.intersection(this.quantifiers.stream().map(child -> child.getRangesOverPlan().getAvailableFields()).collect(Collectors.toList()));
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        return this.resultValue;
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap equivalencesMap) {
        if (this == otherExpression) {
            return true;
        }
        if (this.getClass() != otherExpression.getClass()) {
            return false;
        }
        return this.reverse == ((RecordQueryUnionPlanBase)otherExpression).reverse;
    }

    public boolean equals(Object other) {
        return this.structuralEquals(other);
    }

    public int hashCode() {
        return this.structuralHashCode();
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return Objects.hash(this.reverse);
    }

    protected int basePlanHash(@Nonnull PlanHashable.PlanHashMode mode, ObjectPlanHash baseHash, Object ... hashables) {
        switch (mode.getKind()) {
            case LEGACY: {
                return PlanHashable.planHash(mode, this.getQueryPlanChildren()) + (this.reverse ? 1 : 0);
            }
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, baseHash, this.getQueryPlanChildren(), this.reverse, hashables);
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    @Nonnull
    @API(value=API.Status.INTERNAL)
    public abstract String getDelimiter();

    @Nonnull
    public String toString() {
        return ExplainPlanVisitor.toStringForDebugging(this);
    }

    @Nonnull
    abstract StoreTimer.Count getPlanCount();

    @Override
    public void logPlanStructure(StoreTimer timer) {
        timer.increment(this.getPlanCount());
        for (Quantifier.Physical quantifier : this.quantifiers) {
            quantifier.getRangesOverPlan().logPlanStructure(timer);
        }
    }

    @Override
    public int getComplexity() {
        int complexity = 1;
        for (Quantifier.Physical quantifier : this.quantifiers) {
            complexity += quantifier.getRangesOverPlan().getComplexity();
        }
        return complexity;
    }

    @Override
    public int getRelationalChildCount() {
        return this.quantifiers.size();
    }

    @Override
    public boolean isStrictlySorted() {
        return this.getChildren().stream().allMatch(QueryPlan::isStrictlySorted);
    }

    @Override
    public RecordQuerySetPlan strictlySorted(@Nonnull FinalMemoizer memoizer) {
        return this.withChildrenReferences(this.getChildren().stream().map(p -> memoizer.memoizePlan(p.strictlySorted(memoizer))).collect(Collectors.toList()));
    }

    @Nonnull
    protected PRecordQueryUnionPlanBase toRecordQueryUnionPlanBaseProto(@Nonnull PlanSerializationContext serializationContext) {
        PRecordQueryUnionPlanBase.Builder builder = PRecordQueryUnionPlanBase.newBuilder();
        for (Quantifier.Physical quantifier : this.quantifiers) {
            builder.addQuantifiers(quantifier.toProto(serializationContext));
        }
        builder.setReverse(this.reverse);
        return builder.build();
    }
}

