/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.planprotos.PRecordQueryPlan;
import com.apple.foundationdb.record.planprotos.PRecordQueryUnorderedDistinctPlan;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.query.plan.HeuristicPlanner;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.debug.Debugger;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.apple.foundationdb.record.query.plan.cascades.explain.ExplainPlanVisitor;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithChild;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.protobuf.Message;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.INTERNAL)
public class RecordQueryUnorderedDistinctPlan
extends AbstractRelationalExpressionWithChildren
implements RecordQueryPlanWithChild {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Record-Query-Unordered-Distinct-Plan");
    public static final Logger LOGGER = LoggerFactory.getLogger(RecordQueryUnorderedDistinctPlan.class);
    @Nonnull
    private final Quantifier.Physical inner;
    @Nonnull
    private final KeyExpression comparisonKey;
    @Nonnull
    private static final Set<StoreTimer.Event> duringEvents = Collections.singleton(FDBStoreTimer.Events.QUERY_DISTINCT);
    @Nonnull
    private static final Set<StoreTimer.Count> uniqueCounts = Collections.singleton(FDBStoreTimer.Counts.QUERY_DISTINCT_PLAN_UNIQUES);
    @Nonnull
    private static final Set<StoreTimer.Count> duplicateCounts = ImmutableSet.of(FDBStoreTimer.Counts.QUERY_DISTINCT_PLAN_DUPLICATES, FDBStoreTimer.Counts.QUERY_DISCARDED);

    @HeuristicPlanner
    public RecordQueryUnorderedDistinctPlan(@Nonnull RecordQueryPlan plan, @Nonnull KeyExpression comparisonKey) {
        this(Quantifier.physical(Reference.plannedOf(Debugger.verifyHeuristicPlanner(plan))), comparisonKey);
    }

    private RecordQueryUnorderedDistinctPlan(@Nonnull Quantifier.Physical inner, @Nonnull KeyExpression comparisonKey) {
        this.inner = inner;
        this.comparisonKey = comparisonKey;
    }

    @Override
    @Nonnull
    public <M extends Message> RecordCursor<QueryResult> executePlan(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        HashSet seen = new HashSet();
        return this.getInner().executePlan(store, context, continuation, executeProperties.clearSkipAndLimit()).filterInstrumented(result -> seen.add(this.getComparisonKey().evaluateMessageSingleton(null, (Message)result.getMessage())), (StoreTimer)store.getTimer(), Collections.emptySet(), duringEvents, uniqueCounts, duplicateCounts).skipThenLimit(executeProperties.getSkip(), executeProperties.getReturnedRowLimit());
    }

    @Override
    public boolean isReverse() {
        return this.getInner().isReverse();
    }

    @Nonnull
    private RecordQueryPlan getInner() {
        return this.inner.getRangesOverPlan();
    }

    @Override
    @Nonnull
    public RecordQueryPlan getChild() {
        return this.getInner();
    }

    @Nonnull
    public KeyExpression getComparisonKey() {
        return this.comparisonKey;
    }

    @Override
    @Nonnull
    public List<? extends Quantifier> getQuantifiers() {
        return ImmutableList.of(this.inner);
    }

    public String toString() {
        return ExplainPlanVisitor.toStringForDebugging(this);
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        return ImmutableSet.of();
    }

    @Override
    @Nonnull
    public RecordQueryUnorderedDistinctPlan translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        return new RecordQueryUnorderedDistinctPlan(Iterables.getOnlyElement(translatedQuantifiers).narrow(Quantifier.Physical.class), this.getComparisonKey());
    }

    @Override
    @Nonnull
    public RecordQueryPlanWithChild withChild(@Nonnull Reference childRef) {
        return new RecordQueryUnorderedDistinctPlan(Quantifier.physical(childRef, this.inner.getAlias()), this.getComparisonKey());
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        return this.inner.getFlowedObjectValue();
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap equivalencesMap) {
        if (this == otherExpression) {
            return true;
        }
        if (this.getClass() != otherExpression.getClass()) {
            return false;
        }
        return this.comparisonKey.equals(((RecordQueryUnorderedDistinctPlan)otherExpression).comparisonKey);
    }

    public boolean equals(Object other) {
        return this.structuralEquals(other);
    }

    public int hashCode() {
        return this.structuralHashCode();
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return Objects.hash(this.getComparisonKey());
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: {
                return this.getInner().planHash(mode) + this.getComparisonKey().planHash(mode);
            }
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.getInner(), this.getComparisonKey());
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    @Override
    public void logPlanStructure(StoreTimer timer) {
        timer.increment(FDBStoreTimer.Counts.PLAN_DISTINCT);
        this.getInner().logPlanStructure(timer);
    }

    @Override
    public int getComplexity() {
        return 1 + this.getInner().getComplexity();
    }

    @Override
    @Nonnull
    public PlannerGraph rewritePlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        return PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.OperatorNodeWithInfo(this, NodeInfo.UNORDERED_DISTINCT_OPERATOR, ImmutableList.of("comparison key: {{comparisonKey}}"), ImmutableMap.of("comparisonKey", Attribute.gml(this.comparisonKey.toString()))), childGraphs);
    }

    @Override
    @Nonnull
    public PRecordQueryUnorderedDistinctPlan toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryUnorderedDistinctPlan.newBuilder().setInner(this.inner.toProto(serializationContext)).setComparisonKey(this.comparisonKey.toKeyExpression()).build();
    }

    @Override
    @Nonnull
    public PRecordQueryPlan toRecordQueryPlanProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryPlan.newBuilder().setUnorderedDistinctPlan(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static RecordQueryUnorderedDistinctPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryUnorderedDistinctPlan recordQueryUnorderedDistinctPlanProto) {
        return new RecordQueryUnorderedDistinctPlan(Quantifier.Physical.fromProto(serializationContext, Objects.requireNonNull(recordQueryUnorderedDistinctPlanProto.getInner())), KeyExpression.fromProto(Objects.requireNonNull(recordQueryUnorderedDistinctPlanProto.getComparisonKey())));
    }

    public static class Deserializer
    implements PlanDeserializer<PRecordQueryUnorderedDistinctPlan, RecordQueryUnorderedDistinctPlan> {
        @Override
        @Nonnull
        public Class<PRecordQueryUnorderedDistinctPlan> getProtoMessageClass() {
            return PRecordQueryUnorderedDistinctPlan.class;
        }

        @Override
        @Nonnull
        public RecordQueryUnorderedDistinctPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryUnorderedDistinctPlan recordQueryUnorderedDistinctPlanProto) {
            return RecordQueryUnorderedDistinctPlan.fromProto(serializationContext, recordQueryUnorderedDistinctPlanProto);
        }
    }
}

