/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.planprotos.PRecordQueryPlan;
import com.apple.foundationdb.record.planprotos.PRecordQueryUnorderedPrimaryKeyDistinctPlan;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.query.plan.HeuristicPlanner;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.debug.Debugger;
import com.apple.foundationdb.record.query.plan.cascades.explain.ExplainPlanVisitor;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithChild;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.protobuf.Message;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.INTERNAL)
public class RecordQueryUnorderedPrimaryKeyDistinctPlan
extends AbstractRelationalExpressionWithChildren
implements RecordQueryPlanWithChild {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Record-Query-Unordered-Primary-Key-Distinct-Plan");
    public static final Logger LOGGER = LoggerFactory.getLogger(RecordQueryUnorderedPrimaryKeyDistinctPlan.class);
    @Nonnull
    private final Quantifier.Physical inner;
    @Nonnull
    private static final Set<StoreTimer.Event> duringEvents = Collections.singleton(FDBStoreTimer.Events.QUERY_PK_DISTINCT);
    @Nonnull
    private static final Set<StoreTimer.Count> uniqueCounts = Collections.singleton(FDBStoreTimer.Counts.QUERY_PK_DISTINCT_PLAN_UNIQUES);
    @Nonnull
    private static final Set<StoreTimer.Count> duplicateCounts = ImmutableSet.of(FDBStoreTimer.Counts.QUERY_PK_DISTINCT_PLAN_DUPLICATES, FDBStoreTimer.Counts.QUERY_DISCARDED);

    @HeuristicPlanner
    public RecordQueryUnorderedPrimaryKeyDistinctPlan(@Nonnull RecordQueryPlan innerPlan) {
        this(Quantifier.physical(Reference.plannedOf(Debugger.verifyHeuristicPlanner(innerPlan))));
    }

    public RecordQueryUnorderedPrimaryKeyDistinctPlan(@Nonnull Quantifier.Physical inner) {
        this.inner = inner;
    }

    @Override
    @Nonnull
    public <M extends Message> RecordCursor<QueryResult> executePlan(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        HashSet seen = new HashSet();
        return this.getInner().executePlan(store, context, continuation, executeProperties.clearSkipAndLimit()).filterInstrumented(result -> seen.add(Objects.requireNonNull(result.getPrimaryKey())), (StoreTimer)store.getTimer(), Collections.emptySet(), duringEvents, uniqueCounts, duplicateCounts).skipThenLimit(executeProperties.getSkip(), executeProperties.getReturnedRowLimit());
    }

    @Override
    public boolean isReverse() {
        return this.getInner().isReverse();
    }

    @Nonnull
    private RecordQueryPlan getInner() {
        return this.inner.getRangesOverPlan();
    }

    @Override
    @Nonnull
    public RecordQueryPlan getChild() {
        return this.getInner();
    }

    @Override
    @Nonnull
    public List<? extends Quantifier> getQuantifiers() {
        return ImmutableList.of(this.inner);
    }

    public String toString() {
        return ExplainPlanVisitor.toStringForDebugging(this);
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        return ImmutableSet.of();
    }

    @Override
    @Nonnull
    public RecordQueryUnorderedPrimaryKeyDistinctPlan translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        return new RecordQueryUnorderedPrimaryKeyDistinctPlan(Iterables.getOnlyElement(translatedQuantifiers).narrow(Quantifier.Physical.class));
    }

    @Override
    @Nonnull
    public RecordQueryPlanWithChild withChild(@Nonnull Reference childRef) {
        return new RecordQueryUnorderedPrimaryKeyDistinctPlan(Quantifier.physical(childRef, this.inner.getAlias()));
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        return this.inner.getFlowedObjectValue();
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap equivalencesMap) {
        if (this == otherExpression) {
            return true;
        }
        return this.getClass() == otherExpression.getClass();
    }

    public boolean equals(Object other) {
        return this.structuralEquals(other);
    }

    public int hashCode() {
        return this.structuralHashCode();
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return BASE_HASH.hashCode();
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: {
                return this.getInner().planHash(mode) + 1;
            }
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.getInner());
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    @Override
    public void logPlanStructure(StoreTimer timer) {
        timer.increment(FDBStoreTimer.Counts.PLAN_PK_DISTINCT);
        this.getInner().logPlanStructure(timer);
    }

    @Override
    public int getComplexity() {
        return 1 + this.getInner().getComplexity();
    }

    @Override
    @Nonnull
    public PlannerGraph rewritePlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        return PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.OperatorNodeWithInfo(this, NodeInfo.UNORDERED_PRIMARY_KEY_DISTINCT_OPERATOR), childGraphs);
    }

    @Override
    @Nonnull
    public PRecordQueryUnorderedPrimaryKeyDistinctPlan toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryUnorderedPrimaryKeyDistinctPlan.newBuilder().setInner(this.inner.toProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PRecordQueryPlan toRecordQueryPlanProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryPlan.newBuilder().setUnorderedPrimaryKeyDistinctPlan(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static RecordQueryUnorderedPrimaryKeyDistinctPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryUnorderedPrimaryKeyDistinctPlan recordQueryUnorderedPrimaryKeyDistinctPlanProto) {
        return new RecordQueryUnorderedPrimaryKeyDistinctPlan(Quantifier.Physical.fromProto(serializationContext, Objects.requireNonNull(recordQueryUnorderedPrimaryKeyDistinctPlanProto.getInner())));
    }

    public static class Deserializer
    implements PlanDeserializer<PRecordQueryUnorderedPrimaryKeyDistinctPlan, RecordQueryUnorderedPrimaryKeyDistinctPlan> {
        @Override
        @Nonnull
        public Class<PRecordQueryUnorderedPrimaryKeyDistinctPlan> getProtoMessageClass() {
            return PRecordQueryUnorderedPrimaryKeyDistinctPlan.class;
        }

        @Override
        @Nonnull
        public RecordQueryUnorderedPrimaryKeyDistinctPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryUnorderedPrimaryKeyDistinctPlan recordQueryUnorderedPrimaryKeyDistinctPlanProto) {
            return RecordQueryUnorderedPrimaryKeyDistinctPlan.fromProto(serializationContext, recordQueryUnorderedPrimaryKeyDistinctPlanProto);
        }
    }
}

