/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.planprotos.PRecordQueryPlan;
import com.apple.foundationdb.record.planprotos.PRecordQueryUnorderedUnionPlan;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.cursors.UnorderedUnionCursor;
import com.apple.foundationdb.record.query.plan.HeuristicPlanner;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifiers;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.debug.Debugger;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnionPlanBase;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class RecordQueryUnorderedUnionPlan
extends RecordQueryUnionPlanBase {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Record-Query-Unordered-Union-Plan");

    protected RecordQueryUnorderedUnionPlan(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryUnorderedUnionPlan recordQueryUnorderedUnionPlanProto) {
        super(serializationContext, Objects.requireNonNull(recordQueryUnorderedUnionPlanProto.getSuper()));
    }

    private RecordQueryUnorderedUnionPlan(@Nonnull List<Quantifier.Physical> quantifiers, boolean reverse) {
        super(quantifiers, reverse);
    }

    @Override
    @Nonnull
    <M extends Message> RecordCursor<QueryResult> createUnionCursor(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nonnull List<Function<byte[], RecordCursor<QueryResult>>> childCursorFunctions, @Nullable byte[] continuation) {
        return UnorderedUnionCursor.create(childCursorFunctions, continuation, store.getTimer());
    }

    @Override
    @Nonnull
    public String getDelimiter() {
        return " \u222a ";
    }

    @Override
    @Nonnull
    StoreTimer.Count getPlanCount() {
        return FDBStoreTimer.Counts.PLAN_UNORDERED_UNION;
    }

    @Nonnull
    public static RecordQueryUnorderedUnionPlan fromQuantifiers(@Nonnull List<Quantifier.Physical> quantifiers) {
        return new RecordQueryUnorderedUnionPlan(quantifiers, Quantifiers.isReversed(quantifiers));
    }

    @Nonnull
    @HeuristicPlanner
    public static RecordQueryUnorderedUnionPlan from(@Nonnull List<? extends RecordQueryPlan> children) {
        Debugger.verifyHeuristicPlanner();
        boolean reverse = children.get(0).isReverse();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (RecordQueryPlan recordQueryPlan : children) {
            builder.add(Reference.plannedOf(recordQueryPlan));
        }
        return new RecordQueryUnorderedUnionPlan(Quantifiers.fromPlans(builder.build()), reverse);
    }

    @Nonnull
    @HeuristicPlanner
    public static RecordQueryUnorderedUnionPlan from(@Nonnull RecordQueryPlan left, @Nonnull RecordQueryPlan right) {
        Debugger.verifyHeuristicPlanner();
        return new RecordQueryUnorderedUnionPlan(Quantifiers.fromPlans(ImmutableList.of(Reference.plannedOf(left), Reference.plannedOf(right))), left.isReverse());
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        return ImmutableSet.of();
    }

    @Override
    @Nonnull
    public RecordQueryUnorderedUnionPlan translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        return new RecordQueryUnorderedUnionPlan(Quantifiers.narrow(Quantifier.Physical.class, translatedQuantifiers), this.isReverse());
    }

    @Override
    @Nonnull
    public RecordQueryUnorderedUnionPlan withChildrenReferences(@Nonnull List<? extends Reference> newChildren) {
        return new RecordQueryUnorderedUnionPlan(newChildren.stream().map(Quantifier::physical).collect(ImmutableList.toImmutableList()), this.isReverse());
    }

    @Override
    @Nonnull
    public Set<KeyExpression> getRequiredFields() {
        return ImmutableSet.of();
    }

    @Override
    @Nonnull
    public PlannerGraph rewritePlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        return PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.OperatorNodeWithInfo(this, NodeInfo.UNORDERED_UNION_OPERATOR), childGraphs);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return super.basePlanHash(mode, BASE_HASH, new Object[0]);
    }

    @Override
    @Nonnull
    public PRecordQueryUnorderedUnionPlan toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryUnorderedUnionPlan.newBuilder().setSuper(this.toRecordQueryUnionPlanBaseProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PRecordQueryPlan toRecordQueryPlanProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryPlan.newBuilder().setUnorderedUnionPlan(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static RecordQueryUnorderedUnionPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryUnorderedUnionPlan recordQueryUnorderedUnionPlanProto) {
        return new RecordQueryUnorderedUnionPlan(serializationContext, recordQueryUnorderedUnionPlanProto);
    }

    public static class Deserializer
    implements PlanDeserializer<PRecordQueryUnorderedUnionPlan, RecordQueryUnorderedUnionPlan> {
        @Override
        @Nonnull
        public Class<PRecordQueryUnorderedUnionPlan> getProtoMessageClass() {
            return PRecordQueryUnorderedUnionPlan.class;
        }

        @Override
        @Nonnull
        public RecordQueryUnorderedUnionPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryUnorderedUnionPlan recordQueryUnorderedUnionPlanProto) {
            return RecordQueryUnorderedUnionPlan.fromProto(serializationContext, recordQueryUnorderedUnionPlanProto);
        }
    }
}

