/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PipelineOperation;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.planprotos.PRecordQueryPlan;
import com.apple.foundationdb.record.planprotos.PRecordQueryUpdatePlan;
import com.apple.foundationdb.record.provider.foundationdb.FDBQueriedRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoredRecord;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.SemanticException;
import com.apple.foundationdb.record.query.plan.cascades.explain.ExplainPlanVisitor;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.FieldValue;
import com.apple.foundationdb.record.query.plan.cascades.values.MessageHelpers;
import com.apple.foundationdb.record.query.plan.cascades.values.PromoteValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryAbstractDataModificationPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithChild;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.google.protobuf.Message;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.INTERNAL)
public class RecordQueryUpdatePlan
extends RecordQueryAbstractDataModificationPlan {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Record-Query-Update-Plan");
    public static final Logger LOGGER = LoggerFactory.getLogger(RecordQueryUpdatePlan.class);

    protected RecordQueryUpdatePlan(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryUpdatePlan recordQueryUpdatePlanProto) {
        super(serializationContext, Objects.requireNonNull(recordQueryUpdatePlanProto.getSuper()));
    }

    private RecordQueryUpdatePlan(@Nonnull Quantifier.Physical inner, @Nonnull String targetRecordType, @Nonnull Type.Record targetType, @Nullable MessageHelpers.TransformationTrieNode transformationsTrie, @Nullable MessageHelpers.CoercionTrieNode coercionsTrie, @Nonnull Value computationValue) {
        super(inner, targetRecordType, targetType, transformationsTrie, coercionsTrie, computationValue, RecordQueryUpdatePlan.currentModifiedRecordAlias());
    }

    @Override
    public PipelineOperation getPipelineOperation() {
        return PipelineOperation.UPDATE;
    }

    @Override
    @Nonnull
    public <M extends Message> CompletableFuture<QueryResult> saveRecordAsync(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nonnull M message, boolean isDryRun) {
        CompletableFuture<FDBStoredRecord<M>> result = isDryRun ? store.dryRunSaveRecordAsync(message, FDBRecordStoreBase.RecordExistenceCheck.ERROR_IF_NOT_EXISTS_OR_RECORD_TYPE_CHANGED) : store.saveRecordAsync(message, FDBRecordStoreBase.RecordExistenceCheck.ERROR_IF_NOT_EXISTS_OR_RECORD_TYPE_CHANGED);
        return result.thenApply(fdbStoredRecord -> QueryResult.fromQueriedRecord(FDBQueriedRecord.stored(fdbStoredRecord)));
    }

    @Override
    @Nonnull
    public RecordQueryUpdatePlan translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        Value tranlatedComputationValue = this.getComputationValue().translateCorrelations(translationMap, shouldSimplifyValues);
        return new RecordQueryUpdatePlan(Iterables.getOnlyElement(translatedQuantifiers).narrow(Quantifier.Physical.class), this.getTargetRecordType(), this.getTargetType(), this.translateTransformationsTrie(translationMap, shouldSimplifyValues), this.getCoercionTrie(), tranlatedComputationValue);
    }

    @Nullable
    private MessageHelpers.TransformationTrieNode translateTransformationsTrie(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues) {
        MessageHelpers.TransformationTrieNode transformationsTrie = this.getTransformationsTrie();
        if (translationMap.definesOnlyIdentities()) {
            return transformationsTrie;
        }
        if (transformationsTrie == null) {
            return null;
        }
        return transformationsTrie.mapMaybe((current, childrenTries) -> {
            Value value = (Value)current.getValue();
            if (value != null) {
                Verify.verify(Iterables.isEmpty(childrenTries));
                return new MessageHelpers.TransformationTrieNode(value.translateCorrelations(translationMap, shouldSimplifyValues), null);
            }
            Map oldChildrenMap = Verify.verifyNotNull(current.getChildrenMap());
            Iterator childrenTriesIterator = childrenTries.iterator();
            ImmutableMap.Builder<Integer, MessageHelpers.TransformationTrieNode> resultBuilder = ImmutableMap.builder();
            for (Map.Entry oldEntry : oldChildrenMap.entrySet()) {
                Verify.verify(childrenTriesIterator.hasNext());
                MessageHelpers.TransformationTrieNode childTrie = (MessageHelpers.TransformationTrieNode)childrenTriesIterator.next();
                resultBuilder.put((Integer)oldEntry.getKey(), childTrie);
            }
            return new MessageHelpers.TransformationTrieNode(null, resultBuilder.build());
        }).orElseThrow(() -> new RecordCoreException("unable to translate correlations", new Object[0]));
    }

    @Override
    @Nonnull
    public RecordQueryPlanWithChild withChild(@Nonnull Reference childRef) {
        return new RecordQueryUpdatePlan(Quantifier.physical(childRef, this.getInner().getAlias()), this.getTargetRecordType(), this.getTargetType(), this.getTransformationsTrie(), this.getCoercionTrie(), this.getComputationValue());
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return Objects.hash(BASE_HASH, super.computeHashCodeWithoutChildren());
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, BASE_HASH, super.planHash(mode));
    }

    @Nonnull
    public String toString() {
        return ExplainPlanVisitor.toStringForDebugging(this);
    }

    @Override
    @Nonnull
    public PlannerGraph rewritePlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        Verify.verify(childGraphs.size() == 1);
        PlannerGraph graphForTarget = PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.DataNodeWithInfo(NodeInfo.BASE_DATA, this.getResultType(), ImmutableList.of(this.getTargetRecordType())), ImmutableList.of());
        return PlannerGraph.fromNodeInnerAndTargetForModifications(new PlannerGraph.ModificationOperatorNodeWithInfo(this, NodeInfo.MODIFICATION_OPERATOR, ImmutableList.of("UPDATE"), ImmutableMap.of()), Iterables.getOnlyElement(childGraphs), graphForTarget);
    }

    @Override
    @Nonnull
    public PRecordQueryUpdatePlan toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryUpdatePlan.newBuilder().setSuper(this.toRecordQueryAbstractModificationPlanProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PRecordQueryPlan toRecordQueryPlanProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryPlan.newBuilder().setUpdatePlan(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static RecordQueryUpdatePlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryUpdatePlan recordQueryUpdatePlanProto) {
        return new RecordQueryUpdatePlan(serializationContext, recordQueryUpdatePlanProto);
    }

    @Nonnull
    public static RecordQueryUpdatePlan updatePlan(@Nonnull Quantifier.Physical inner, @Nonnull String targetRecordType, @Nonnull Type.Record targetType, @Nonnull Map<FieldValue.FieldPath, Value> transformMap, @Nonnull Value computationValue) {
        MessageHelpers.TransformationTrieNode transformationsTrie = RecordQueryUpdatePlan.computeTrieForFieldPaths(RecordQueryUpdatePlan.checkAndPrepareOrderedFieldPaths(transformMap), transformMap);
        return new RecordQueryUpdatePlan(inner, targetRecordType, targetType, transformationsTrie, PromoteValue.computePromotionsTrie(targetType, inner.getFlowedObjectType(), transformationsTrie), computationValue);
    }

    @Nonnull
    public static List<FieldValue.FieldPath> checkAndPrepareOrderedFieldPaths(@Nonnull Map<FieldValue.FieldPath, ? extends Value> transformMap) {
        ImmutableList<FieldValue.FieldPath> orderedFieldPaths = transformMap.keySet().stream().sorted(FieldValue.FieldPath.comparator()).collect(ImmutableList.toImmutableList());
        FieldValue.FieldPath currentFieldPath = null;
        for (FieldValue.FieldPath fieldPath : orderedFieldPaths) {
            SemanticException.check(currentFieldPath == null || !currentFieldPath.isPrefixOf(fieldPath), SemanticException.ErrorCode.UPDATE_TRANSFORM_AMBIGUOUS);
            currentFieldPath = fieldPath;
        }
        return orderedFieldPaths;
    }

    @Nonnull
    public static MessageHelpers.TransformationTrieNode computeTrieForFieldPaths(@Nonnull Collection<FieldValue.FieldPath> orderedFieldPaths, @Nonnull Map<FieldValue.FieldPath, ? extends Value> transformMap) {
        return RecordQueryUpdatePlan.computeTrieForFieldPaths(new FieldValue.FieldPath(ImmutableList.of()), transformMap, Iterators.peekingIterator(orderedFieldPaths.iterator()));
    }

    @Nonnull
    private static MessageHelpers.TransformationTrieNode computeTrieForFieldPaths(@Nonnull FieldValue.FieldPath prefix, @Nonnull Map<FieldValue.FieldPath, ? extends Value> transformMap, @Nonnull PeekingIterator<FieldValue.FieldPath> orderedFieldPathIterator) {
        FieldValue.FieldPath fieldPath;
        if (transformMap.containsKey(prefix)) {
            orderedFieldPathIterator.next();
            return new MessageHelpers.TransformationTrieNode(Verify.verifyNotNull(transformMap.get(prefix)), null);
        }
        ImmutableMap.Builder<Integer, MessageHelpers.TransformationTrieNode> childrenMapBuilder = ImmutableMap.builder();
        while (orderedFieldPathIterator.hasNext() && prefix.isPrefixOf(fieldPath = orderedFieldPathIterator.peek())) {
            List<FieldValue.ResolvedAccessor> prefixAccessors = prefix.getFieldAccessors();
            FieldValue.ResolvedAccessor currentAccessor = fieldPath.getFieldAccessors().get(prefixAccessors.size());
            FieldValue.FieldPath nestedPrefix = new FieldValue.FieldPath((List<FieldValue.ResolvedAccessor>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(prefixAccessors)).add(currentAccessor)).build()));
            MessageHelpers.TransformationTrieNode currentTrie = RecordQueryUpdatePlan.computeTrieForFieldPaths(nestedPrefix, transformMap, orderedFieldPathIterator);
            childrenMapBuilder.put(currentAccessor.getOrdinal(), currentTrie);
        }
        return new MessageHelpers.TransformationTrieNode(null, childrenMapBuilder.build());
    }

    public static class Deserializer
    implements PlanDeserializer<PRecordQueryUpdatePlan, RecordQueryUpdatePlan> {
        @Override
        @Nonnull
        public Class<PRecordQueryUpdatePlan> getProtoMessageClass() {
            return PRecordQueryUpdatePlan.class;
        }

        @Override
        @Nonnull
        public RecordQueryUpdatePlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryUpdatePlan recordQueryUpdatePlanProto) {
            return RecordQueryUpdatePlan.fromProto(serializationContext, recordQueryUpdatePlanProto);
        }
    }
}

