/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.query.plan.plans.PlanSelector;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;

public class RelativeProbabilityPlanSelector
implements PlanSelector {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Relative-Probability-Plan-Selector");
    @Nonnull
    List<Integer> probabilities;
    @Nonnull
    Random random;

    public RelativeProbabilityPlanSelector(@Nonnull List<Integer> probabilities) {
        this(probabilities, ThreadLocalRandom.current());
    }

    @VisibleForTesting
    RelativeProbabilityPlanSelector(@Nonnull List<Integer> probabilities, @Nonnull Random random) {
        if (probabilities.isEmpty()) {
            throw new RecordCoreArgumentException("Probability selector should have at least one probability", new Object[0]);
        }
        this.probabilities = List.copyOf(probabilities);
        this.random = random;
        int sumAll = this.probabilities.stream().mapToInt(Integer::intValue).sum();
        if (sumAll != 100) {
            throw new RecordCoreArgumentException("Probabilities should all add up to 100", new Object[0]);
        }
    }

    @Override
    public int selectPlan(@Nonnull List<RecordQueryPlan> plans) {
        int rand = this.random.nextInt(100) + 1;
        int index = 0;
        for (int sum = this.probabilities.get(0).intValue(); sum < rand; sum += this.probabilities.get(++index).intValue()) {
        }
        return index;
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.probabilities);
    }

    public String toString() {
        return "RelativeProbabilityPlanSelector{probabilities=" + String.valueOf(this.probabilities) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelativeProbabilityPlanSelector that = (RelativeProbabilityPlanSelector)o;
        return this.probabilities.equals(that.probabilities);
    }

    public int hashCode() {
        return Objects.hash(this.probabilities);
    }
}

