/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PInSource;
import com.apple.foundationdb.record.planprotos.PSortedInComparandSource;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.plans.InComparandSource;
import com.apple.foundationdb.record.query.plan.plans.InSource;
import com.google.common.base.Verify;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class SortedInComparandSource
extends InComparandSource {
    @Nonnull
    private static final ObjectPlanHash OBJECT_PLAN_HASH_SORTED_IN_COMPARAND_SOURCE = new ObjectPlanHash("Sorted-In-Comparand");
    private final boolean reverse;

    protected SortedInComparandSource(@Nonnull PlanSerializationContext serializationContext, @Nonnull PSortedInComparandSource sortedInComparandSourceProto) {
        super(serializationContext, Objects.requireNonNull(sortedInComparandSourceProto.getSuper()));
        Verify.verify(sortedInComparandSourceProto.hasReverse());
        this.reverse = sortedInComparandSourceProto.getReverse();
    }

    public SortedInComparandSource(@Nonnull String bindingName, @Nonnull Comparisons.Comparison comparison, boolean reverse) {
        super(bindingName, comparison);
        this.reverse = reverse;
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, this.baseHash(mode, OBJECT_PLAN_HASH_SORTED_IN_COMPARAND_SOURCE), this.getComparison(), this.reverse);
    }

    @Override
    public boolean isSorted() {
        return true;
    }

    @Override
    public boolean isReverse() {
        return this.reverse;
    }

    @Override
    @Nonnull
    protected List<Object> getValues(@Nullable EvaluationContext context) {
        List<Object> unsortedValues = super.getValues(context);
        return Objects.requireNonNull(InSource.sortValues(unsortedValues, this.reverse));
    }

    @Override
    @Nonnull
    public String toString() {
        return super.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SortedInComparandSource inComparandSource = (SortedInComparandSource)o;
        if (!this.getBindingName().equals(inComparandSource.getBindingName())) {
            return false;
        }
        return super.equals(inComparandSource) && this.reverse == inComparandSource.reverse;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getComparison(), this.reverse);
    }

    @Override
    @Nonnull
    public PSortedInComparandSource toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PSortedInComparandSource.newBuilder().setSuper(this.toInComparandSourceProto(serializationContext)).setReverse(this.reverse).build();
    }

    @Override
    @Nonnull
    protected PInSource toInSourceProto(@Nonnull PlanSerializationContext serializationContext) {
        return PInSource.newBuilder().setSortedInComparandSource(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static SortedInComparandSource fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PSortedInComparandSource sortedInComparandSourceProto) {
        return new SortedInComparandSource(serializationContext, sortedInComparandSourceProto);
    }

    public static class Deserializer
    implements PlanDeserializer<PSortedInComparandSource, SortedInComparandSource> {
        @Override
        @Nonnull
        public Class<PSortedInComparandSource> getProtoMessageClass() {
            return PSortedInComparandSource.class;
        }

        @Override
        @Nonnull
        public SortedInComparandSource fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PSortedInComparandSource sortedInComparandSourceProto) {
            return SortedInComparandSource.fromProto(serializationContext, sortedInComparandSourceProto);
        }
    }
}

