/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PInSource;
import com.apple.foundationdb.record.planprotos.PSortedInParameterSource;
import com.apple.foundationdb.record.query.plan.plans.InParameterSource;
import com.apple.foundationdb.record.query.plan.plans.InSource;
import com.google.common.base.Verify;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class SortedInParameterSource
extends InParameterSource {
    @Nonnull
    private static final ObjectPlanHash OBJECT_PLAN_HASH_SORTED_IN_PARAMETER_SOURCE = new ObjectPlanHash("Sorted-In-Parameter");
    private final boolean isReverse;

    protected SortedInParameterSource(@Nonnull PlanSerializationContext serializationContext, @Nonnull PSortedInParameterSource sortedInParameterSourceProto) {
        super(serializationContext, Objects.requireNonNull(sortedInParameterSourceProto.getSuper()));
        Verify.verify(sortedInParameterSourceProto.hasReverse());
        this.isReverse = sortedInParameterSourceProto.getReverse();
    }

    public SortedInParameterSource(@Nonnull String bindingName, @Nonnull String parameterName, boolean isReverse) {
        super(bindingName, parameterName);
        this.isReverse = isReverse;
    }

    @Override
    public boolean isSorted() {
        return true;
    }

    @Override
    public boolean isReverse() {
        return this.isReverse;
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, this.baseHash(mode, OBJECT_PLAN_HASH_SORTED_IN_PARAMETER_SOURCE), super.planHash(mode), this.isReverse);
    }

    @Override
    protected int size(@Nonnull EvaluationContext context) {
        return this.getBoundValues(context).size();
    }

    @Override
    @Nonnull
    @SpotBugsSuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"})
    protected List<Object> getValues(@Nullable EvaluationContext context) {
        List<Object> values = this.getBoundValues(Objects.requireNonNull(context));
        return Objects.requireNonNull(InSource.sortValues(values, this.isReverse));
    }

    @Override
    @Nonnull
    public String toString() {
        return this.getBindingName() + " IN $" + this.getParameterName() + (this.isReverse() ? " DESC" : " ASC");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SortedInParameterSource sortedInParameterSource = (SortedInParameterSource)o;
        if (!super.equals(sortedInParameterSource)) {
            return false;
        }
        return this.isReverse == sortedInParameterSource.isReverse;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.isReverse);
    }

    @Override
    @Nonnull
    public PSortedInParameterSource toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PSortedInParameterSource.newBuilder().setSuper(this.toInParameterSourceProto(serializationContext)).setReverse(this.isReverse).build();
    }

    @Override
    @Nonnull
    protected PInSource toInSourceProto(@Nonnull PlanSerializationContext serializationContext) {
        return PInSource.newBuilder().setSortedInParameterSource(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static SortedInParameterSource fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PSortedInParameterSource sortedInParameterSourceProto) {
        return new SortedInParameterSource(serializationContext, sortedInParameterSourceProto);
    }

    public static class Deserializer
    implements PlanDeserializer<PSortedInParameterSource, SortedInParameterSource> {
        @Override
        @Nonnull
        public Class<PSortedInParameterSource> getProtoMessageClass() {
            return PSortedInParameterSource.class;
        }

        @Override
        @Nonnull
        public SortedInParameterSource fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PSortedInParameterSource sortedInParameterSourceProto) {
            return SortedInParameterSource.fromProto(serializationContext, sortedInParameterSourceProto);
        }
    }
}

