/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PInSource;
import com.apple.foundationdb.record.planprotos.PSortedInValuesSource;
import com.apple.foundationdb.record.query.plan.plans.InSource;
import com.apple.foundationdb.record.query.plan.plans.InValuesSource;
import com.google.common.base.Verify;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

@API(value=API.Status.INTERNAL)
public class SortedInValuesSource
extends InValuesSource {
    @Nonnull
    private static final ObjectPlanHash OBJECT_PLAN_HASH_IN_VALUES_SOURCE = new ObjectPlanHash("Sorted-In-Values");
    final boolean isReverse;

    protected SortedInValuesSource(@Nonnull PlanSerializationContext serializationContext, @Nonnull PSortedInValuesSource sortedInValuesSourceProto) {
        super(serializationContext, Objects.requireNonNull(sortedInValuesSourceProto.getSuper()));
        Verify.verify(sortedInValuesSourceProto.hasReverse());
        this.isReverse = sortedInValuesSourceProto.getReverse();
    }

    public SortedInValuesSource(@Nonnull String bindingName, @Nonnull List<Object> values, boolean isReverse) {
        super(bindingName, InSource.sortValues(values, isReverse));
        this.isReverse = isReverse;
    }

    @Override
    public boolean isSorted() {
        return true;
    }

    @Override
    public boolean isReverse() {
        return this.isReverse;
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, this.baseHash(mode, OBJECT_PLAN_HASH_IN_VALUES_SOURCE), super.planHash(mode), this.isReverse);
    }

    @Override
    @Nonnull
    public String toString() {
        return this.getBindingName() + " IN " + String.valueOf(this.getValues()) + (this.isReverse() ? " DESC" : " ASC");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SortedInValuesSource sortedInValuesSource = (SortedInValuesSource)o;
        if (!super.equals(sortedInValuesSource)) {
            return false;
        }
        return this.isReverse == sortedInValuesSource.isReverse;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.isReverse);
    }

    @Override
    @Nonnull
    public PSortedInValuesSource toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PSortedInValuesSource.newBuilder().setSuper(this.toInValuesSourceProto(serializationContext)).setReverse(this.isReverse).build();
    }

    @Override
    @Nonnull
    protected PInSource toInSourceProto(@Nonnull PlanSerializationContext serializationContext) {
        return PInSource.newBuilder().setSortedInValuesSource(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static SortedInValuesSource fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PSortedInValuesSource sortedInValuesSourceProto) {
        return new SortedInValuesSource(serializationContext, sortedInValuesSourceProto);
    }

    public static class Deserializer
    implements PlanDeserializer<PSortedInValuesSource, SortedInValuesSource> {
        @Override
        @Nonnull
        public Class<PSortedInValuesSource> getProtoMessageClass() {
            return PSortedInValuesSource.class;
        }

        @Override
        @Nonnull
        public SortedInValuesSource fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PSortedInValuesSource sortedInValuesSourceProto) {
            return SortedInValuesSource.fromProto(serializationContext, sortedInValuesSourceProto);
        }
    }
}

