/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.cursors.TempTableInsertCursor;
import com.apple.foundationdb.record.planprotos.PRecordQueryPlan;
import com.apple.foundationdb.record.planprotos.PTempTableInsertPlan;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.TempTable;
import com.apple.foundationdb.record.query.plan.cascades.explain.ExplainPlanVisitor;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraphRewritable;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.QueriedValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithChild;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.INTERNAL)
public class TempTableInsertPlan
extends AbstractRelationalExpressionWithChildren
implements RecordQueryPlanWithChild,
PlannerGraphRewritable {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Temp-Table-Insert-Plan");
    public static final Logger LOGGER = LoggerFactory.getLogger(TempTableInsertPlan.class);
    @Nonnull
    private final Quantifier.Physical inner;
    @Nonnull
    private final Value tempTableReferenceValue;
    private final boolean isOwningTempTable;

    protected TempTableInsertPlan(@Nonnull PlanSerializationContext serializationContext, @Nonnull PTempTableInsertPlan tempTableInsertPlanProto) {
        this.inner = Quantifier.Physical.fromProto(serializationContext, tempTableInsertPlanProto.getInner());
        this.tempTableReferenceValue = Value.fromValueProto(serializationContext, tempTableInsertPlanProto.getTempTableReferenceValue());
        this.isOwningTempTable = tempTableInsertPlanProto.getIsOwningTempTable();
    }

    private TempTableInsertPlan(@Nonnull Quantifier.Physical inner, @Nonnull Value tempTableReferenceValue, boolean isOwningTempTable) {
        this.inner = inner;
        this.tempTableReferenceValue = tempTableReferenceValue;
        this.isOwningTempTable = isOwningTempTable;
    }

    @Override
    @Nonnull
    public <M extends Message> RecordCursor<QueryResult> executePlan(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        if (this.isOwningTempTable) {
            Descriptors.Descriptor typeDescriptor = this.getInnerTypeDescriptor(context);
            return TempTableInsertCursor.from(continuation, proto -> {
                TempTable tempTable = Objects.requireNonNull((TempTable)this.getTempTableReferenceValue().eval(store, context));
                if (proto != null) {
                    TempTable deserialized = TempTable.from(proto, typeDescriptor);
                    deserialized.getIterator().forEachRemaining(tempTable::add);
                }
                return tempTable;
            }, childContinuation -> this.getChild().executePlan(store, context, (byte[])childContinuation, executeProperties.clearSkipAndLimit()));
        }
        return this.getChild().executePlan(store, context, continuation, executeProperties.clearSkipAndLimit()).map(queryResult -> {
            TempTable tempTable = Objects.requireNonNull((TempTable)this.getTempTableReferenceValue().eval(store, context));
            tempTable.add((QueryResult)queryResult);
            return queryResult;
        });
    }

    @Nullable
    private Descriptors.Descriptor getInnerTypeDescriptor(@Nonnull EvaluationContext context) {
        Descriptors.Descriptor typeDescriptor;
        if (this.tempTableReferenceValue.getResultType().isRelation() && ((Type.Relation)this.tempTableReferenceValue.getResultType()).getInnerType().isRecord()) {
            Type.Record type = (Type.Record)((Type.Relation)this.tempTableReferenceValue.getResultType()).getInnerType();
            typeDescriptor = context.getTypeRepository().getMessageDescriptor(type);
        } else {
            typeDescriptor = null;
        }
        return typeDescriptor;
    }

    @Override
    @Nonnull
    public RelationalExpression translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        Value translatedTableReferenceValue = this.getTempTableReferenceValue().translateCorrelations(translationMap);
        return new TempTableInsertPlan(Iterables.getOnlyElement(translatedQuantifiers).narrow(Quantifier.Physical.class), translatedTableReferenceValue, this.isOwningTempTable);
    }

    @Override
    public RecordQueryPlan getChild() {
        return this.inner.getRangesOverPlan();
    }

    @Override
    @Nonnull
    public TempTableInsertPlan withChild(@Nonnull Reference childRef) {
        return new TempTableInsertPlan(Quantifier.physical(childRef, this.inner.getAlias()), this.getTempTableReferenceValue(), this.isOwningTempTable);
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        return new QueriedValue(Objects.requireNonNull(((Type.Relation)this.tempTableReferenceValue.getResultType()).getInnerType()));
    }

    @Override
    @Nonnull
    public List<? extends Quantifier> getQuantifiers() {
        return ImmutableList.of(this.inner);
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap equivalences) {
        if (this == otherExpression) {
            return true;
        }
        if (this.getClass() != otherExpression.getClass()) {
            return false;
        }
        TempTableInsertPlan otherTempTableScan = (TempTableInsertPlan)otherExpression;
        return this.tempTableReferenceValue.semanticEquals((Object)otherTempTableScan.tempTableReferenceValue, equivalences);
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return Objects.hash(BASE_HASH.planHash(PlanHashable.CURRENT_FOR_CONTINUATION), this.getTempTableReferenceValue(), this.isOwningTempTable);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.getChild(), this.getTempTableReferenceValue(), this.isOwningTempTable);
    }

    @Nonnull
    public String toString() {
        return ExplainPlanVisitor.toStringForDebugging(this);
    }

    @Override
    @Nonnull
    public PlannerGraph rewritePlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        PlannerGraph graphForTarget = PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.TemporaryDataNodeWithInfo(this.getResultType(), ImmutableList.of(this.getTempTableReferenceValue().toString())), ImmutableList.of());
        return PlannerGraph.fromNodeInnerAndTargetForModifications(new PlannerGraph.ModificationOperatorNodeWithInfo(this, NodeInfo.MODIFICATION_OPERATOR, ImmutableList.of("TempTableInsert"), ImmutableMap.of()), Iterables.getOnlyElement(childGraphs), graphForTarget);
    }

    @Override
    @Nonnull
    public PTempTableInsertPlan toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PTempTableInsertPlan.newBuilder().setInner(this.inner.toProto(serializationContext)).setTempTableReferenceValue(this.getTempTableReferenceValue().toValueProto(serializationContext)).setIsOwningTempTable(this.isOwningTempTable).build();
    }

    @Override
    @Nonnull
    public PRecordQueryPlan toRecordQueryPlanProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryPlan.newBuilder().setTempTableInsertPlan(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static TempTableInsertPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PTempTableInsertPlan tempTableInsertPlanProto) {
        return new TempTableInsertPlan(serializationContext, tempTableInsertPlanProto);
    }

    @Nonnull
    public static TempTableInsertPlan insertPlan(@Nonnull Quantifier.Physical inner, @Nonnull Value tempTableReferenceValue, boolean isOwningTempTable) {
        return new TempTableInsertPlan(inner, tempTableReferenceValue, isOwningTempTable);
    }

    @Nonnull
    public Value getTempTableReferenceValue() {
        return this.tempTableReferenceValue;
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        return this.tempTableReferenceValue.getCorrelatedToWithoutChildren();
    }

    @Override
    public boolean isReverse() {
        return this.getChild().isReverse();
    }

    @Override
    public void logPlanStructure(StoreTimer timer) {
        this.getChild().logPlanStructure(timer);
    }

    @Override
    public int getComplexity() {
        return 1 + this.getChild().getComplexity();
    }

    public static class Deserializer
    implements PlanDeserializer<PTempTableInsertPlan, TempTableInsertPlan> {
        @Override
        @Nonnull
        public Class<PTempTableInsertPlan> getProtoMessageClass() {
            return PTempTableInsertPlan.class;
        }

        @Override
        @Nonnull
        public TempTableInsertPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PTempTableInsertPlan tempTableInsertPlanProto) {
            return TempTableInsertPlan.fromProto(serializationContext, tempTableInsertPlanProto);
        }
    }
}

