/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.serialization;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.query.plan.serialization.PlanSerializationRegistry;
import com.apple.foundationdb.record.util.ServiceLoaderProvider;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class DefaultPlanSerializationRegistry
implements PlanSerializationRegistry {
    public static final PlanSerializationRegistry INSTANCE = new DefaultPlanSerializationRegistry();
    private static final String TYPE_URL_PREFIX = "c.a.fdb.types";
    @Nonnull
    private final Map<Class<? extends Message>, PlanDeserializer<? extends Message, ?>> fromProtoClassDeserializerMap;
    @Nonnull
    private final Map<String, Class<? extends Message>> fromProtoTypeUrlClassMap;

    public DefaultPlanSerializationRegistry() {
        NonnullPair<Map<Class<Message>, PlanDeserializer<Message, ?>>, Map<String, Class<Message>>> methodMaps = this.loadFromProtoMethodMaps();
        this.fromProtoClassDeserializerMap = methodMaps.getLeft();
        this.fromProtoTypeUrlClassMap = methodMaps.getRight();
    }

    @Override
    @Nonnull
    public String getTypeUrlPrefix() {
        return TYPE_URL_PREFIX;
    }

    @Override
    @Nonnull
    public <M extends Message> PlanDeserializer<M, ?> lookUpFromProto(@Nonnull Class<M> messageClass) {
        PlanDeserializer<? extends Message, ?> deserializer = this.fromProtoClassDeserializerMap.get(messageClass);
        if (deserializer == null) {
            throw new RecordCoreException("unable to dispatch for message of class " + String.valueOf(messageClass), new Object[0]);
        }
        return deserializer;
    }

    @Override
    @Nonnull
    public Class<? extends Message> lookUpMessageClass(@Nonnull String typeUrl) {
        Class<? extends Message> protoMessageClass = this.fromProtoTypeUrlClassMap.get(typeUrl);
        if (protoMessageClass == null) {
            throw new RecordCoreException("unable to dispatch for type url " + typeUrl, new Object[0]);
        }
        return protoMessageClass;
    }

    private NonnullPair<Map<Class<? extends Message>, PlanDeserializer<? extends Message, ?>>, Map<String, Class<? extends Message>>> loadFromProtoMethodMaps() {
        Iterable<PlanDeserializer> planDeserializers = ServiceLoaderProvider.load(PlanDeserializer.class);
        ImmutableMap.Builder fromProtoClassDeserializerMapBuilder = ImmutableMap.builder();
        ImmutableMap.Builder fromProtoTypeUrlClassMapBuilder = ImmutableMap.builder();
        Streams.stream(planDeserializers).forEach(planDeserializer -> {
            Descriptors.Descriptor protoMessageDescriptor;
            Method getDescriptorMethod;
            Class protoMessageClass = planDeserializer.getProtoMessageClass();
            fromProtoClassDeserializerMapBuilder.put(protoMessageClass, planDeserializer);
            try {
                getDescriptorMethod = protoMessageClass.getMethod("getDescriptor", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RecordCoreException("unable to find getDescriptor() method", e);
            }
            try {
                protoMessageDescriptor = (Descriptors.Descriptor)getDescriptorMethod.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RecordCoreException("unable to invoke getDescriptor Method", e);
            }
            fromProtoTypeUrlClassMapBuilder.put(DefaultPlanSerializationRegistry.getTypeUrl(protoMessageDescriptor), protoMessageClass);
        });
        return NonnullPair.of(fromProtoClassDeserializerMapBuilder.build(), fromProtoTypeUrlClassMapBuilder.build());
    }

    @Nonnull
    private static String getTypeUrl(@Nonnull Descriptors.Descriptor descriptor) {
        return "c.a.fdb.types/" + descriptor.getFullName();
    }
}

