/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.serialization;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.metadata.expressions.LiteralKeyExpression;
import com.apple.foundationdb.record.planprotos.PComparableObject;
import com.apple.foundationdb.record.planprotos.PEnumLightValue;
import com.apple.foundationdb.record.planprotos.PFDBRecordVersion;
import com.apple.foundationdb.record.planprotos.PUUID;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordVersion;
import com.apple.foundationdb.record.query.plan.serialization.PlanSerializationRegistry;
import com.apple.foundationdb.record.util.ProtoUtils;
import com.google.common.base.Verify;
import com.google.common.collect.BiMap;
import com.google.common.collect.EnumBiMap;
import com.google.common.collect.Iterables;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class PlanSerialization {
    @Nonnull
    public static PComparableObject valueObjectToProto(@Nullable Object object) {
        PComparableObject.Builder builder = PComparableObject.newBuilder();
        if (object instanceof Internal.EnumLite) {
            builder.setEnumObject(PEnumLightValue.newBuilder().setName(object.toString()).setNumber(((Internal.EnumLite)object).getNumber()));
        } else if (object instanceof UUID) {
            UUID uuid = (UUID)object;
            builder.setUuid(PUUID.newBuilder().setMostSigBits(uuid.getMostSignificantBits()).setLeastSigBits(uuid.getLeastSignificantBits())).build();
        } else if (object instanceof FDBRecordVersion) {
            builder.setFdbRecordVersion(PFDBRecordVersion.newBuilder().setRawBytes(ByteString.copyFrom(((FDBRecordVersion)object).toBytes(false))).build());
        } else if (object instanceof ByteString) {
            builder.setBytesAsByteString((ByteString)object);
        } else {
            builder.setPrimitiveObject(LiteralKeyExpression.toProtoValue(object));
        }
        return builder.build();
    }

    @Nullable
    public static Object protoToValueObject(@Nonnull PComparableObject proto) {
        if (proto.hasEnumObject()) {
            PEnumLightValue enumProto = Objects.requireNonNull(proto.getEnumObject());
            Verify.verify(enumProto.hasNumber());
            return new ProtoUtils.DynamicEnum(enumProto.getNumber(), Objects.requireNonNull(enumProto.getName()));
        }
        if (proto.hasUuid()) {
            PUUID uuidProto = Objects.requireNonNull(proto.getUuid());
            return new UUID(uuidProto.getMostSigBits(), uuidProto.getLeastSigBits());
        }
        if (proto.hasFdbRecordVersion()) {
            PFDBRecordVersion fdbRecordVersion = Objects.requireNonNull(proto.getFdbRecordVersion());
            return FDBRecordVersion.fromBytes(fdbRecordVersion.getRawBytes().toByteArray(), false);
        }
        if (proto.hasBytesAsByteString()) {
            return proto.getBytesAsByteString();
        }
        return LiteralKeyExpression.fromProtoValue(Objects.requireNonNull(proto.getPrimitiveObject()));
    }

    @Nonnull
    public static Any protoObjectToAny(@Nonnull PlanSerializationContext serializationContext, @Nonnull Message proto) {
        return Any.pack(proto, serializationContext.getRegistry().getTypeUrlPrefix());
    }

    @Nonnull
    public static Object dispatchFromProtoContainer(@Nonnull PlanSerializationContext serializationContext, @Nonnull Message message) {
        Map<Descriptors.FieldDescriptor, Object> allFields = message.getAllFields();
        Verify.verify(allFields.size() == 1);
        Message field = (Message)Iterables.getOnlyElement(allFields.values());
        return PlanSerialization.dispatchFromProto(serializationContext, field);
    }

    @Nonnull
    private static Object dispatchFromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull Message message) {
        PlanSerializationRegistry registry = serializationContext.getRegistry();
        if (message instanceof Any) {
            Any any = (Any)message;
            Class<? extends Message> messageClass = registry.lookUpMessageClass(any.getTypeUrl());
            try {
                message = any.unpack(messageClass);
            }
            catch (InvalidProtocolBufferException e) {
                throw new RecordCoreException("corrupt any field", e);
            }
        }
        return PlanSerialization.invokeDeserializer(serializationContext, message);
    }

    private static <M extends Message> Object invokeDeserializer(@Nonnull PlanSerializationContext serializationContext, @Nonnull M message) {
        PlanDeserializer<?, ?> deserializer = serializationContext.getRegistry().lookUpFromProto(message.getClass());
        return deserializer.fromProto(serializationContext, message);
    }

    @Nonnull
    public static <M extends Message, T> T getFieldOrThrow(@Nonnull M message, @Nonnull Predicate<M> fieldSetPredicate, @Nonnull Function<M, T> fieldExtractor) {
        if (fieldSetPredicate.test(message)) {
            return fieldExtractor.apply(message);
        }
        throw new RecordCoreException("Field is expected to be set but message does not have field.", new Object[0]);
    }

    @Nullable
    public static <M extends Message, T> T getFieldOrNull(@Nonnull M message, @Nonnull Predicate<M> fieldSetPredicate, @Nonnull Function<M, T> fieldExtractor) {
        if (fieldSetPredicate.test(message)) {
            return fieldExtractor.apply(message);
        }
        return null;
    }

    @Nonnull
    public static <E1 extends Enum<E1>, E2 extends Enum<E2>> BiMap<E1, E2> protoEnumBiMap(@Nonnull Class<E1> domainEnumClass, @Nonnull Class<E2> protoEnumClass) {
        Verify.verify(domainEnumClass.isEnum());
        Verify.verify(protoEnumClass.isEnum());
        Enum[] javaEnumConstants = (Enum[])domainEnumClass.getEnumConstants();
        Enum[] protoEnumConstants = (Enum[])protoEnumClass.getEnumConstants();
        Verify.verify(javaEnumConstants.length == protoEnumConstants.length);
        EnumBiMap<E1, E2> enumBiMap = EnumBiMap.create(domainEnumClass, protoEnumClass);
        for (int i = 0; i < javaEnumConstants.length; ++i) {
            Enum e1 = javaEnumConstants[i];
            Enum e2 = protoEnumConstants[i];
            Verify.verify(e1.ordinal() == e2.ordinal());
            Verify.verify(e1.name().equals(e2.name()), "%s not equal to %s", (Object)e1, (Object)e2);
            enumBiMap.put(e1, e2);
        }
        return enumBiMap;
    }
}

