/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.sorting;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.planprotos.PRecordQueryDamPlan;
import com.apple.foundationdb.record.planprotos.PRecordQueryPlan;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBQueriedRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.query.plan.AvailableFields;
import com.apple.foundationdb.record.query.plan.HeuristicPlanner;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.debug.Debugger;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.values.QueriedValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithChild;
import com.apple.foundationdb.record.query.plan.sorting.RecordQuerySortAdapter;
import com.apple.foundationdb.record.query.plan.sorting.RecordQuerySortKey;
import com.apple.foundationdb.record.sorting.MemorySortCursor;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class RecordQueryDamPlan
extends AbstractRelationalExpressionWithChildren
implements RecordQueryPlanWithChild {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Record-Query-Dam-Plan");
    @Nonnull
    private final Quantifier.Physical inner;
    @Nonnull
    private final RecordQuerySortKey key;

    @HeuristicPlanner
    public RecordQueryDamPlan(@Nonnull RecordQueryPlan plan, @Nonnull RecordQuerySortKey key) {
        this(Quantifier.physical(Reference.plannedOf(Debugger.verifyHeuristicPlanner(plan))), key);
    }

    private RecordQueryDamPlan(@Nonnull Quantifier.Physical inner, @Nonnull RecordQuerySortKey key) {
        this.inner = inner;
        this.key = key;
    }

    @Override
    @Nonnull
    public <M extends Message> RecordCursor<QueryResult> executePlan(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        ExecuteProperties executeInner = executeProperties.clearSkipAndLimit();
        Function innerCursor = innerContinuation -> this.getChild().executePlan(store, context, (byte[])innerContinuation, executeInner).map(QueryResult::getQueriedRecord);
        int skip = executeProperties.getSkip();
        int limit = executeProperties.getReturnedRowLimitOrMax();
        RecordQuerySortAdapter<M> adapter = this.key.getAdapterForDam(store);
        FDBStoreTimer timer = store.getTimer();
        RecordCursor<FDBQueriedRecord> dammed = MemorySortCursor.createDam(adapter, innerCursor, timer, continuation).skipThenLimit(skip, limit);
        return dammed.map(QueryResult::fromQueriedRecord);
    }

    @Override
    @Nonnull
    public RecordQueryPlan getChild() {
        return this.inner.getRangesOverPlan();
    }

    @Nonnull
    public RecordQuerySortKey getKey() {
        return this.key;
    }

    @Override
    public boolean isReverse() {
        return this.key.isReverse();
    }

    @Override
    @Nonnull
    @API(value=API.Status.EXPERIMENTAL)
    public List<? extends Quantifier> getQuantifiers() {
        return ImmutableList.of(this.inner);
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        return new QueriedValue();
    }

    @Override
    @Nonnull
    public AvailableFields getAvailableFields() {
        return AvailableFields.ALL_FIELDS;
    }

    public String toString() {
        return "Dam(" + String.valueOf(this.getChild()) + ")";
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        return ImmutableSet.of();
    }

    @Override
    @Nonnull
    public RecordQueryDamPlan translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        return new RecordQueryDamPlan((Quantifier.Physical)Iterables.getOnlyElement(translatedQuantifiers), this.key);
    }

    @Override
    @Nonnull
    public RecordQueryPlanWithChild withChild(@Nonnull Reference childRef) {
        return new RecordQueryDamPlan(Quantifier.physical(childRef, this.inner.getAlias()), this.key);
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap equivalencesMap) {
        if (this == otherExpression) {
            return true;
        }
        if (this.getClass() != otherExpression.getClass()) {
            return false;
        }
        RecordQueryDamPlan other = (RecordQueryDamPlan)otherExpression;
        return this.key.equals(other.key);
    }

    public boolean equals(Object other) {
        return this.structuralEquals(other);
    }

    public int hashCode() {
        return this.structuralHashCode();
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return Objects.hash(this.key);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.getChild(), this.getKey());
    }

    @Override
    public void logPlanStructure(StoreTimer timer) {
        timer.increment(FDBStoreTimer.Counts.PLAN_DAM);
        this.getChild().logPlanStructure(timer);
    }

    @Override
    public int getComplexity() {
        return this.getChild().getComplexity();
    }

    @Override
    @Nonnull
    public PlannerGraph rewritePlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        return PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.OperatorNodeWithInfo(this, NodeInfo.DAM_OPERATOR), childGraphs);
    }

    @Override
    @Nonnull
    public PRecordQueryDamPlan toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryDamPlan.newBuilder().setInner(this.inner.toProto(serializationContext)).setKey(this.key.toProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PRecordQueryPlan toRecordQueryPlanProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryPlan.newBuilder().setDamPlan(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static RecordQueryDamPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryDamPlan recordQueryDamPlan) {
        return new RecordQueryDamPlan(Quantifier.Physical.fromProto(serializationContext, Objects.requireNonNull(recordQueryDamPlan.getInner())), RecordQuerySortKey.fromProto(serializationContext, Objects.requireNonNull(recordQueryDamPlan.getKey())));
    }

    public static class Deserializer
    implements PlanDeserializer<PRecordQueryDamPlan, RecordQueryDamPlan> {
        @Override
        @Nonnull
        public Class<PRecordQueryDamPlan> getProtoMessageClass() {
            return PRecordQueryDamPlan.class;
        }

        @Override
        @Nonnull
        public RecordQueryDamPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryDamPlan recordQueryDamPlanProto) {
            return RecordQueryDamPlan.fromProto(serializationContext, recordQueryDamPlanProto);
        }
    }
}

