/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.sorting;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.provider.common.RecordSerializer;
import com.apple.foundationdb.record.provider.common.TransformedRecordSerializer;
import com.apple.foundationdb.record.provider.foundationdb.FDBQueriedRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.SortedRecordSerializer;
import com.apple.foundationdb.record.query.plan.sorting.RecordQuerySortKey;
import com.apple.foundationdb.record.sorting.FileSortAdapter;
import com.apple.foundationdb.record.sorting.MemoryScratchpad;
import com.apple.foundationdb.record.sorting.MemorySortAdapter;
import com.apple.foundationdb.tuple.Tuple;
import com.google.common.base.Suppliers;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Message;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.KeyGenerator;

@API(value=API.Status.EXPERIMENTAL)
public class RecordQuerySortAdapter<M extends Message>
implements FileSortAdapter<Tuple, FDBQueriedRecord<M>> {
    public static final int DEFAULT_MAX_RECORD_COUNT_IN_MEMORY = 1000;
    public static final int DEFAULT_MAX_FILE_COUNT = 10;
    public static final int DEFAULT_RECORD_COUNT_PER_SECTION = 100;
    private final int memoryLimit;
    private final boolean memoryOnly;
    @Nonnull
    private final BiFunction<MemorySortAdapter<Tuple, FDBQueriedRecord<M>>, Tuple, MemorySortAdapter.MemorySortComparator<Tuple>> comparatorFunction;
    @Nonnull
    private final RecordQuerySortKey key;
    @Nonnull
    private final SortedRecordSerializer<M> serializer;
    private final int metaDataVersion;
    @Nullable
    private Key encryptionKey;
    private static final Supplier<SecureRandom> RANDOM = Suppliers.memoize(SecureRandom::new);

    protected RecordQuerySortAdapter(int memoryLimit, boolean memoryOnly, @Nonnull BiFunction<MemorySortAdapter<Tuple, FDBQueriedRecord<M>>, Tuple, MemorySortAdapter.MemorySortComparator<Tuple>> comparatorFunction, @Nonnull RecordQuerySortKey key, @Nonnull FDBRecordStoreBase<M> recordStore) {
        this.memoryLimit = memoryLimit;
        this.memoryOnly = memoryOnly;
        this.comparatorFunction = comparatorFunction;
        this.key = key;
        RecordSerializer<M> recordSerializer = recordStore.getSerializer();
        if (recordSerializer instanceof TransformedRecordSerializer) {
            recordSerializer = ((TransformedRecordSerializer)recordSerializer).untransformed();
        }
        RecordMetaData metaData = recordStore.getRecordMetaData();
        this.serializer = new SortedRecordSerializer<M>(recordSerializer, metaData, recordStore.getTimer());
        this.metaDataVersion = metaData.getVersion();
    }

    public boolean isMemoryOnly() {
        return this.memoryOnly;
    }

    @Override
    public int compare(@Nonnull Tuple o1, @Nonnull Tuple o2) {
        return this.key.isReverse() ? o2.compareTo(o1) : o1.compareTo(o2);
    }

    @Override
    @Nonnull
    public Tuple generateKey(@Nonnull FDBQueriedRecord<M> value) {
        return this.key.getKey().evaluateSingleton(value).toTuple();
    }

    @Override
    @Nonnull
    public byte[] serializeKey(Tuple key) {
        return key.pack();
    }

    @Override
    public boolean isSerializedOrderReversed() {
        return this.key.isReverse();
    }

    @Override
    @Nonnull
    public Tuple deserializeKey(@Nonnull byte[] key) {
        return Tuple.fromBytes(key);
    }

    @Override
    @Nonnull
    public byte[] serializeValue(FDBQueriedRecord<M> record) {
        return this.serializer.serialize(record);
    }

    @Override
    @Nonnull
    public FDBQueriedRecord<M> deserializeValue(@Nonnull byte[] bytes) {
        return this.serializer.deserialize(bytes);
    }

    @Override
    public int getMaxRecordCountInMemory() {
        return this.memoryOnly ? this.memoryLimit : 1000;
    }

    @Override
    @Nonnull
    public MemoryScratchpad.RecordCountInMemoryLimitMode getRecordCountInMemoryLimitMode() {
        return this.memoryOnly ? MemoryScratchpad.RecordCountInMemoryLimitMode.DISCARD : MemoryScratchpad.RecordCountInMemoryLimitMode.STOP;
    }

    @Override
    @Nonnull
    public File generateFilename() throws IOException {
        return File.createTempFile("fdb", ".bin");
    }

    @Override
    public int getMetaDataVersion() {
        return this.metaDataVersion;
    }

    @Override
    public void writeValue(@Nonnull FDBQueriedRecord<M> record, @Nonnull CodedOutputStream stream) throws IOException {
        this.serializer.write(record, stream);
    }

    @Override
    public FDBQueriedRecord<M> readValue(@Nonnull CodedInputStream stream) throws IOException {
        return this.serializer.read(stream);
    }

    @Override
    public int getMinFileRecordCount() {
        return 1000;
    }

    @Override
    public int getMaxFileCount() {
        return 10;
    }

    @Override
    public int getRecordCountPerSection() {
        return 100;
    }

    @Override
    public boolean isCompressed() {
        return true;
    }

    @Override
    @Nullable
    public String getEncryptionCipherName() {
        return "AES/CBC/PKCS5Padding";
    }

    @Override
    @Nullable
    public synchronized Key getEncryptionKey() {
        if (this.encryptionKey == null) {
            try {
                KeyGenerator keyGen = KeyGenerator.getInstance("AES");
                keyGen.init(128, RANDOM.get());
                this.encryptionKey = keyGen.generateKey();
            }
            catch (GeneralSecurityException ex) {
                throw new RecordCoreException(ex);
            }
        }
        return this.encryptionKey;
    }

    @Override
    @Nullable
    public SecureRandom getSecureRandom() {
        return RANDOM.get();
    }

    @Override
    @Nonnull
    public MemorySortAdapter.MemorySortComparator<Tuple> getComparator(@Nullable Tuple minimumKey) {
        return this.comparatorFunction.apply(this, minimumKey);
    }
}

