/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.sorting;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.planprotos.PRecordQuerySortKey;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.sorting.RecordQuerySortAdapter;
import com.apple.foundationdb.record.sorting.MemorySortAdapter;
import com.google.common.base.Verify;
import com.google.protobuf.Message;
import java.util.Objects;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class RecordQuerySortKey
implements PlanHashable,
PlanSerializable {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Record-Query-Sort-Key");
    @Nonnull
    private final KeyExpression key;
    private final boolean reverse;

    public RecordQuerySortKey(@Nonnull KeyExpression key, boolean reverse) {
        this.key = key;
        this.reverse = reverse;
    }

    @Nonnull
    public KeyExpression getKey() {
        return this.key;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    @Nonnull
    public <M extends Message> RecordQuerySortAdapter<M> getAdapter(@Nonnull FDBRecordStoreBase<M> recordStore, int maxRecordsToRead) {
        int memoryLimit = Math.min(maxRecordsToRead, 1000);
        boolean memoryOnly = memoryLimit == maxRecordsToRead;
        return new RecordQuerySortAdapter(memoryLimit, memoryOnly, MemorySortAdapter.OrderComparator::new, this, recordStore);
    }

    @Nonnull
    public <M extends Message> RecordQuerySortAdapter<M> getAdapterForDam(@Nonnull FDBRecordStoreBase<M> recordStore) {
        return new RecordQuerySortAdapter(1000, true, MemorySortAdapter.InsertionOrderComparator::new, this, recordStore);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.key, this.reverse);
    }

    public String toString() {
        return this.reverse ? String.valueOf(this.key) + " DESC" : this.key.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecordQuerySortKey that = (RecordQuerySortKey)o;
        if (this.reverse != that.reverse) {
            return false;
        }
        return this.key.equals(that.key);
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + (this.reverse ? 1 : 0);
        return result;
    }

    @Override
    @Nonnull
    public PRecordQuerySortKey toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQuerySortKey.newBuilder().setKey(this.key.toKeyExpression()).setReverse(this.reverse).build();
    }

    @Nonnull
    public static RecordQuerySortKey fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQuerySortKey recordQuerySortKeyProto) {
        Verify.verify(recordQuerySortKeyProto.hasReverse());
        return new RecordQuerySortKey(KeyExpression.fromProto(Objects.requireNonNull(recordQuerySortKeyProto.getKey())), recordQuerySortKeyProto.getReverse());
    }
}

