/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.synthetic;

import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.EvaluationContextBuilder;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PipelineOperation;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.metadata.JoinedRecordType;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoredRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBSyntheticRecord;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.synthetic.SyntheticRecordFromStoredRecordPlan;
import com.google.protobuf.Message;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class JoinedRecordPlan
implements SyntheticRecordFromStoredRecordPlan {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Joined-Record-Plan");
    @Nonnull
    private final JoinedRecordType joinedRecordType;
    @Nonnull
    private final List<JoinedType> joinedTypes;
    @Nonnull
    private final List<RecordQueryPlan> queries;

    public JoinedRecordPlan(@Nonnull JoinedRecordType joinedRecordType, @Nonnull List<JoinedType> joinedTypes, @Nonnull List<RecordQueryPlan> queries) {
        if (joinedTypes.size() != joinedRecordType.getConstituents().size()) {
            throw new RecordCoreArgumentException("should join all constituents", new Object[0]);
        }
        for (JoinedType joinedType : joinedTypes) {
            if (joinedRecordType.getConstituents().contains(joinedType.constituent)) continue;
            throw new RecordCoreArgumentException("constituent " + String.valueOf(joinedType.constituent) + " does not come from joined record type", new Object[0]);
        }
        if (queries.size() != joinedTypes.size() - 1) {
            throw new RecordCoreArgumentException("should have one query for each join", new Object[0]);
        }
        this.joinedRecordType = joinedRecordType;
        this.joinedTypes = joinedTypes;
        this.queries = queries;
    }

    @Override
    @Nonnull
    public Set<String> getStoredRecordTypes() {
        return Collections.singleton(this.joinedTypes.get((int)0).constituent.getRecordType().getName());
    }

    @Override
    @Nonnull
    public Set<String> getSyntheticRecordTypes() {
        return Collections.singleton(this.joinedRecordType.getName());
    }

    @Override
    @Nonnull
    public <M extends Message> RecordCursor<FDBSyntheticRecord> execute(@Nonnull FDBRecordStore store, @Nonnull FDBStoredRecord<M> record, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        RecordCursor<EvaluationContext> joinedContexts;
        EvaluationContext context = this.joinedTypes.get(0).bind(EvaluationContext.EMPTY, record);
        if (this.queries.size() == 1) {
            joinedContexts = this.query(0, store, context, continuation, executeProperties);
        } else {
            ExecuteProperties baseProperties = executeProperties.clearSkipAndLimit();
            joinedContexts = this.nest(0, store.getPipelineSize(PipelineOperation.SYNTHETIC_RECORD_JOIN), store, context, continuation, baseProperties).skipThenLimit(executeProperties.getSkip(), executeProperties.getReturnedRowLimit());
        }
        return joinedContexts.map(this::toSyntheticRecord);
    }

    private RecordCursor<EvaluationContext> query(int depth, @Nonnull FDBRecordStore store, @Nonnull EvaluationContext context, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        JoinedType joinedType = this.joinedTypes.get(depth + 1);
        RecordCursor<Object> records = joinedType.constituent.isOuterJoined() ? RecordCursor.orElse(innerContinuation -> this.queries.get(depth).execute(store, context, (byte[])innerContinuation, executeProperties), (executor, elseContinuation) -> RecordCursor.fromFuture(executor, CompletableFuture.completedFuture(null), elseContinuation), continuation) : this.queries.get(depth).execute(store, context, continuation, executeProperties);
        return records.map(qr -> joinedType.bind(context, qr == null ? null : qr.getStoredRecord()));
    }

    private RecordCursor<EvaluationContext> nest(int depth, int pipelineSize, @Nonnull FDBRecordStore store, @Nonnull EvaluationContext context, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        if (depth == this.queries.size() - 1) {
            return this.query(depth, store, context, continuation, executeProperties);
        }
        return RecordCursor.flatMapPipelined(outerContinuation -> this.query(depth, store, context, (byte[])outerContinuation, executeProperties), (innerContext, innerContination) -> this.nest(depth + 1, pipelineSize, store, (EvaluationContext)innerContext, (byte[])innerContination, executeProperties), continuation, pipelineSize);
    }

    private FDBSyntheticRecord toSyntheticRecord(@Nonnull EvaluationContext context) {
        HashMap<String, FDBStoredRecord<? extends Message>> records = new HashMap<String, FDBStoredRecord<? extends Message>>();
        for (JoinedRecordType.JoinConstituent joinConstituent : this.joinedRecordType.getConstituents()) {
            records.put(joinConstituent.getName(), (FDBStoredRecord)context.getBinding(joinConstituent.getName()));
        }
        return FDBSyntheticRecord.of(this.joinedRecordType, records);
    }

    @Nonnull
    public JoinedRecordType getJoinedRecordType() {
        return this.joinedRecordType;
    }

    @Nonnull
    public List<JoinedType> getJoinedTypes() {
        return this.joinedTypes;
    }

    @Nonnull
    public List<RecordQueryPlan> getQueries() {
        return this.queries;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < this.joinedTypes.size(); ++i) {
            JoinedType joinedType = this.joinedTypes.get(i);
            str.append(joinedType.constituent.getName());
            str.append(":");
            if (i == 0) {
                str.append("?");
            } else {
                str.append(this.queries.get(i - 1));
            }
            for (BindingPlan bindingPlan : joinedType.bindingPlans) {
                str.append(", ").append(bindingPlan);
            }
            str.append(" => ");
        }
        str.append(this.joinedRecordType.getName());
        return str.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoinedRecordPlan that = (JoinedRecordPlan)o;
        return Objects.equals(this.joinedRecordType, that.joinedRecordType) && Objects.equals(this.joinedTypes, that.joinedTypes) && Objects.equals(this.queries, that.queries);
    }

    public int hashCode() {
        return Objects.hash(this.joinedRecordType, this.joinedTypes, this.queries);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: {
                return PlanHashable.objectsPlanHash(mode, this.joinedRecordType.getName(), this.joinedTypes, this.queries);
            }
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.joinedRecordType.getName(), this.joinedTypes, this.queries);
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    protected static class JoinedType
    implements PlanHashable {
        private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Joined-Type");
        @Nonnull
        protected final JoinedRecordType.JoinConstituent constituent;
        @Nonnull
        protected final List<BindingPlan> bindingPlans;

        public JoinedType(@Nonnull JoinedRecordType.JoinConstituent constituent, @Nonnull List<BindingPlan> bindingPlans) {
            this.constituent = constituent;
            this.bindingPlans = bindingPlans;
        }

        public <M extends Message> EvaluationContext bind(@Nonnull EvaluationContext context, @Nullable FDBStoredRecord<M> record) {
            EvaluationContextBuilder builder = context.childBuilder();
            builder.setBinding(this.constituent.getName(), record);
            for (BindingPlan bindingPlan : this.bindingPlans) {
                builder.setBinding(bindingPlan.name, bindingPlan.evaluate(record));
            }
            return builder.build(context.getTypeRepository());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JoinedType that = (JoinedType)o;
            return Objects.equals(this.constituent, that.constituent) && Objects.equals(this.bindingPlans, that.bindingPlans);
        }

        public int hashCode() {
            return Objects.hash(this.constituent, this.bindingPlans);
        }

        @Override
        public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
            switch (mode.getKind()) {
                case LEGACY: {
                    return this.constituent.getName().hashCode() + PlanHashable.planHash(mode, this.bindingPlans);
                }
                case FOR_CONTINUATION: {
                    return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.constituent.getName(), this.bindingPlans);
                }
            }
            throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
        }
    }

    protected static class BindingPlan
    implements PlanHashable {
        private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Binding-Plan");
        @Nonnull
        protected final String name;
        @Nonnull
        protected final KeyExpression expression;
        protected final boolean singleton;

        public BindingPlan(@Nonnull String name, @Nonnull KeyExpression expression, boolean singleton) {
            this.name = name;
            this.expression = expression;
            this.singleton = singleton;
        }

        public <M extends Message> Object evaluate(@Nullable FDBStoredRecord<M> record) {
            if (this.singleton) {
                return BindingPlan.toValue(this.expression.evaluateSingleton(record));
            }
            return this.expression.evaluate(record).stream().map(BindingPlan::toValue).collect(Collectors.toList());
        }

        protected static Object toValue(@Nonnull Key.Evaluated evaluated) {
            if (evaluated.size() != 1) {
                throw new RecordCoreException("binding expression should evaluate to scalar values", new Object[0]);
            }
            return evaluated.getObject(0);
        }

        @Nonnull
        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name + ":" + String.valueOf(this.expression);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BindingPlan bindingPlan = (BindingPlan)o;
            return this.singleton == bindingPlan.singleton && Objects.equals(this.name, bindingPlan.name) && Objects.equals(this.expression, bindingPlan.expression);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.expression, this.singleton);
        }

        @Override
        public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
            switch (mode.getKind()) {
                case LEGACY: {
                    return this.name.hashCode() + this.expression.planHash(mode) + (this.singleton ? 1 : 0);
                }
                case FOR_CONTINUATION: {
                    return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.name, this.expression, this.singleton);
                }
            }
            throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
        }
    }
}

