/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.synthetic;

import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.metadata.JoinedRecordType;
import com.apple.foundationdb.record.metadata.expressions.FieldKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.InvertibleFunctionKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.NestingKeyExpression;
import com.apple.foundationdb.record.query.RecordQuery;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.expressions.FieldWithComparison;
import com.apple.foundationdb.record.query.expressions.NestedField;
import com.apple.foundationdb.record.query.expressions.OneOfThemWithComparison;
import com.apple.foundationdb.record.query.expressions.OneOfThemWithComponent;
import com.apple.foundationdb.record.query.expressions.Query;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.plan.RecordQueryPlanner;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.synthetic.JoinedRecordPlan;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

class JoinedRecordPlanner {
    @Nonnull
    private final JoinedRecordType joinedRecordType;
    @Nonnull
    private final RecordQueryPlanner queryPlanner;
    @Nonnull
    private final List<PendingType> pendingTypes;
    @Nonnull
    private final Set<PendingJoin> pendingJoins;
    @Nonnull
    private final List<JoinedRecordPlan.JoinedType> joinedTypes;
    @Nonnull
    private final List<RecordQueryPlan> queries;
    private int bindingCounter;

    static RecordCoreException notFoundEitherSide() {
        return new RecordCoreException("did not find pending join on either side", new Object[0]);
    }

    JoinedRecordPlanner(@Nonnull JoinedRecordType joinedRecordType, @Nonnull RecordQueryPlanner queryPlanner) {
        this.joinedRecordType = joinedRecordType;
        this.queryPlanner = queryPlanner;
        this.pendingTypes = joinedRecordType.getConstituents().stream().map(this::createPendingType).collect(Collectors.toCollection(ArrayList::new));
        this.pendingJoins = joinedRecordType.getJoins().stream().map(this::createPendingJoin).collect(Collectors.toCollection(HashSet::new));
        this.joinedTypes = new ArrayList<JoinedRecordPlan.JoinedType>(this.pendingTypes.size());
        this.queries = new ArrayList<RecordQueryPlan>(this.pendingTypes.size() - 1);
    }

    @Nonnull
    private PendingType createPendingType(@Nonnull JoinedRecordType.JoinConstituent joinConstituent) {
        return new PendingType(joinConstituent);
    }

    @Nonnull
    private PendingJoin createPendingJoin(@Nonnull JoinedRecordType.Join join) {
        PendingType pendingLeft = this.findPendingType(join.getLeft());
        PendingType pendingRight = this.findPendingType(join.getRight());
        PendingJoin pendingJoin = new PendingJoin(join, pendingLeft, pendingRight, "_j" + ++this.bindingCounter);
        pendingLeft.pendingJoins.add(pendingJoin);
        pendingRight.pendingJoins.add(pendingJoin);
        return pendingJoin;
    }

    @Nonnull
    private PendingType findPendingType(@Nonnull JoinedRecordType.JoinConstituent joinConstituent) {
        return this.pendingTypes.get(this.joinedRecordType.getConstituents().indexOf(joinConstituent));
    }

    @Nonnull
    public JoinedRecordPlan plan(@Nonnull JoinedRecordType.JoinConstituent joinConstituent) {
        PendingType pendingType = this.findPendingType(joinConstituent);
        this.bindAndRemove(pendingType);
        while (!this.pendingTypes.isEmpty()) {
            pendingType = this.pendingTypes.size() == 1 ? this.pendingTypes.get(0) : this.pendingTypes.stream().filter(PendingType::allJoinsBound).findFirst().orElseGet(() -> this.pendingTypes.stream().max(Comparator.comparing(PendingType::countJoinsBound)).orElseThrow(() -> new RecordCoreException("did not find any pending types", new Object[0])));
            this.queries.add(this.queryPlanner.plan(this.buildQuery(pendingType)));
            this.bindAndRemove(pendingType);
        }
        if (!this.pendingJoins.isEmpty()) {
            throw new RecordCoreException("did not perform all joins", new Object[0]);
        }
        return new JoinedRecordPlan(this.joinedRecordType, this.joinedTypes, this.queries);
    }

    private void bindAndRemove(@Nonnull PendingType pendingType) {
        ArrayList<JoinedRecordPlan.BindingPlan> bindingPlans = new ArrayList<JoinedRecordPlan.BindingPlan>();
        for (PendingJoin pendingJoin : pendingType.pendingJoins) {
            KeyExpression expression;
            if (!this.pendingJoins.contains(pendingJoin)) continue;
            if (pendingJoin.pendingLeft == pendingType) {
                expression = pendingJoin.join.getLeftExpression();
                pendingJoin.leftBound = true;
            } else if (pendingJoin.pendingRight == pendingType) {
                expression = pendingJoin.join.getRightExpression();
                pendingJoin.rightBound = true;
            } else {
                throw JoinedRecordPlanner.notFoundEitherSide();
            }
            pendingJoin.singleton = !expression.createsDuplicates();
            bindingPlans.add(new JoinedRecordPlan.BindingPlan(pendingJoin.bindingName, expression, pendingJoin.singleton));
        }
        bindingPlans.sort(Comparator.comparing(JoinedRecordPlan.BindingPlan::getName));
        this.joinedTypes.add(new JoinedRecordPlan.JoinedType(pendingType.joinConstituent, bindingPlans));
        this.pendingTypes.remove(pendingType);
    }

    @Nonnull
    private RecordQuery buildQuery(@Nonnull PendingType pendingType) {
        ArrayList<QueryComponent> conditions = new ArrayList<QueryComponent>();
        for (PendingJoin pendingJoin : pendingType.pendingJoins) {
            KeyExpression expression;
            boolean bound;
            if (pendingJoin.pendingLeft == pendingType) {
                bound = pendingJoin.rightBound;
                expression = pendingJoin.join.getLeftExpression();
            } else if (pendingJoin.pendingRight == pendingType) {
                bound = pendingJoin.leftBound;
                expression = pendingJoin.join.getRightExpression();
            } else {
                throw JoinedRecordPlanner.notFoundEitherSide();
            }
            if (!bound) continue;
            Comparisons.ParameterComparison comparison = new Comparisons.ParameterComparison(pendingJoin.singleton ? Comparisons.Type.EQUALS : Comparisons.Type.IN, pendingJoin.bindingName);
            conditions.add(JoinedRecordPlanner.buildCondition(expression, comparison));
            this.pendingJoins.remove(pendingJoin);
        }
        RecordQuery.Builder builder = RecordQuery.newBuilder();
        builder.setRecordType(pendingType.joinConstituent.getRecordType().getName());
        if (!conditions.isEmpty()) {
            builder.setFilter(conditions.size() > 1 ? Query.and(conditions) : (QueryComponent)conditions.get(0));
        }
        builder.setRemoveDuplicates(true);
        return builder.build();
    }

    @Nonnull
    private static QueryComponent buildCondition(@Nonnull KeyExpression expression, @Nonnull Comparisons.Comparison comparison) {
        if (expression instanceof FieldKeyExpression) {
            FieldKeyExpression field = (FieldKeyExpression)expression;
            switch (field.getFanType()) {
                case None: {
                    return new FieldWithComparison(field.getFieldName(), comparison);
                }
                case FanOut: {
                    return new OneOfThemWithComparison(field.getFieldName(), comparison);
                }
            }
            throw new RecordCoreException("unsupported fan type in join key expression: " + String.valueOf(expression), new Object[0]);
        }
        if (expression instanceof NestingKeyExpression) {
            NestingKeyExpression nesting = (NestingKeyExpression)expression;
            QueryComponent condition = JoinedRecordPlanner.buildCondition(nesting.getChild(), comparison);
            String fieldName = nesting.getParent().getFieldName();
            switch (nesting.getParent().getFanType()) {
                case None: {
                    return new NestedField(fieldName, condition);
                }
                case FanOut: {
                    return new OneOfThemWithComponent(fieldName, condition);
                }
            }
            throw new RecordCoreException("unsupported fan type in join key expression: " + String.valueOf(expression), new Object[0]);
        }
        if (expression instanceof InvertibleFunctionKeyExpression) {
            InvertibleFunctionKeyExpression function = (InvertibleFunctionKeyExpression)expression;
            Comparisons.InvertedFunctionComparison inverted = Comparisons.InvertedFunctionComparison.from(function, comparison);
            return JoinedRecordPlanner.buildCondition(function.getArguments(), inverted);
        }
        throw new RecordCoreException("unsupported join key expression: " + String.valueOf(expression), new Object[0]);
    }

    static class PendingType {
        protected final JoinedRecordType.JoinConstituent joinConstituent;
        protected final List<PendingJoin> pendingJoins;

        PendingType(JoinedRecordType.JoinConstituent joinConstituent) {
            this.joinConstituent = joinConstituent;
            this.pendingJoins = new ArrayList<PendingJoin>();
        }

        public boolean allJoinsBound() {
            return this.pendingJoins.stream().allMatch(this::isJoinBound);
        }

        public long countJoinsBound() {
            return this.pendingJoins.stream().filter(this::isJoinBound).count();
        }

        public boolean isJoinBound(@Nonnull PendingJoin pendingJoin) {
            if (pendingJoin.pendingLeft == this) {
                return pendingJoin.rightBound;
            }
            if (pendingJoin.pendingRight == this) {
                return pendingJoin.leftBound;
            }
            throw JoinedRecordPlanner.notFoundEitherSide();
        }
    }

    static class PendingJoin {
        protected final JoinedRecordType.Join join;
        protected final PendingType pendingLeft;
        protected final PendingType pendingRight;
        protected final String bindingName;
        protected boolean singleton;
        protected boolean leftBound;
        protected boolean rightBound;

        PendingJoin(JoinedRecordType.Join join, PendingType pendingLeft, PendingType pendingRight, String bindingName) {
            this.join = join;
            this.pendingLeft = pendingLeft;
            this.pendingRight = pendingRight;
            this.bindingName = bindingName;
        }
    }
}

