/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.synthetic;

import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoredRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBSyntheticRecord;
import com.apple.foundationdb.record.query.plan.synthetic.SyntheticRecordFromStoredRecordPlan;
import com.google.protobuf.Message;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class SyntheticRecordByTypePlan
implements SyntheticRecordFromStoredRecordPlan {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Synthetic-Record-By-Type-Plan");
    @Nonnull
    private final Map<String, SyntheticRecordFromStoredRecordPlan> subPlans;
    @Nonnull
    private final Set<String> syntheticRecordTypes;

    public SyntheticRecordByTypePlan(@Nonnull Map<String, SyntheticRecordFromStoredRecordPlan> subPlans) {
        this.subPlans = subPlans;
        this.syntheticRecordTypes = new HashSet<String>();
        for (SyntheticRecordFromStoredRecordPlan subPlan : subPlans.values()) {
            this.syntheticRecordTypes.addAll(subPlan.getSyntheticRecordTypes());
        }
    }

    @Nonnull
    public Map<String, SyntheticRecordFromStoredRecordPlan> getSubPlans() {
        return this.subPlans;
    }

    @Override
    @Nonnull
    public Set<String> getStoredRecordTypes() {
        return this.subPlans.keySet();
    }

    @Override
    @Nonnull
    public Set<String> getSyntheticRecordTypes() {
        return this.syntheticRecordTypes;
    }

    @Override
    @Nonnull
    public <M extends Message> RecordCursor<FDBSyntheticRecord> execute(@Nonnull FDBRecordStore store, @Nonnull FDBStoredRecord<M> record, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        SyntheticRecordFromStoredRecordPlan subPlan = this.subPlans.get(record.getRecordType().getName());
        if (subPlan == null) {
            return RecordCursor.empty();
        }
        return subPlan.execute(store, record, continuation, executeProperties);
    }

    public String toString() {
        return this.subPlans.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyntheticRecordByTypePlan that = (SyntheticRecordByTypePlan)o;
        return Objects.equals(this.subPlans, that.subPlans);
    }

    public int hashCode() {
        return Objects.hash(this.subPlans);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: {
                int hash = 1;
                for (Map.Entry<String, SyntheticRecordFromStoredRecordPlan> entry : this.subPlans.entrySet()) {
                    hash += entry.getKey().hashCode() * 31 + entry.getValue().planHash(mode);
                }
                return hash;
            }
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.subPlans.keySet(), this.subPlans.values());
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }
}

