/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.synthetic;

import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PipelineOperation;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoredRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBSyntheticRecord;
import com.apple.foundationdb.record.query.plan.synthetic.SyntheticRecordFromStoredRecordPlan;
import com.google.protobuf.Message;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class SyntheticRecordConcatPlan
implements SyntheticRecordFromStoredRecordPlan {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Synthetic-Record-Concat-Plan");
    @Nonnull
    private final List<SyntheticRecordFromStoredRecordPlan> subPlans;
    private final boolean needDistinct;
    @Nonnull
    private final Set<String> storedRecordTypes;
    @Nonnull
    private final Set<String> syntheticRecordTypes;

    public SyntheticRecordConcatPlan(@Nonnull List<SyntheticRecordFromStoredRecordPlan> subPlans, boolean needDistinct) {
        this.subPlans = subPlans;
        this.needDistinct = needDistinct;
        this.storedRecordTypes = new HashSet<String>();
        this.syntheticRecordTypes = new HashSet<String>();
        for (SyntheticRecordFromStoredRecordPlan subPlan : subPlans) {
            this.storedRecordTypes.addAll(subPlan.getStoredRecordTypes());
            this.syntheticRecordTypes.addAll(subPlan.getSyntheticRecordTypes());
        }
    }

    @Nonnull
    public List<SyntheticRecordFromStoredRecordPlan> getSubPlans() {
        return this.subPlans;
    }

    public boolean isNeedDistinct() {
        return this.needDistinct;
    }

    @Override
    @Nonnull
    public Set<String> getStoredRecordTypes() {
        return this.storedRecordTypes;
    }

    @Override
    @Nonnull
    public Set<String> getSyntheticRecordTypes() {
        return this.syntheticRecordTypes;
    }

    @Override
    @Nonnull
    public <M extends Message> RecordCursor<FDBSyntheticRecord> execute(@Nonnull FDBRecordStore store, @Nonnull FDBStoredRecord<M> record, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        ExecuteProperties baseProperties = executeProperties.clearSkipAndLimit();
        RecordCursor<FDBSyntheticRecord> cursor = RecordCursor.flatMapPipelined(outerContinuation -> RecordCursor.fromList(store.getExecutor(), this.subPlans, outerContinuation), (subPlan, innerContinuation) -> subPlan.execute(store, record, (byte[])innerContinuation, baseProperties), continuation, store.getPipelineSize(PipelineOperation.SYNTHETIC_RECORD_JOIN));
        if (this.needDistinct) {
            cursor = SyntheticRecordConcatPlan.addDistinct(cursor);
        }
        cursor = cursor.skipThenLimit(executeProperties.getSkip(), executeProperties.getReturnedRowLimit());
        return cursor;
    }

    public static RecordCursor<FDBSyntheticRecord> addDistinct(RecordCursor<FDBSyntheticRecord> cursor) {
        HashSet seen = new HashSet();
        return cursor.filter(r -> seen.add(r.getPrimaryKey()));
    }

    public String toString() {
        return this.subPlans.stream().map(Object::toString).collect(Collectors.joining(" + "));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyntheticRecordConcatPlan that = (SyntheticRecordConcatPlan)o;
        return this.needDistinct == that.needDistinct && Objects.equals(this.subPlans, that.subPlans);
    }

    public int hashCode() {
        return Objects.hash(this.subPlans, this.needDistinct);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: {
                return PlanHashable.planHash(mode, this.subPlans) + (this.needDistinct ? 1 : 0);
            }
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.subPlans, this.needDistinct);
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }
}

