/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.synthetic;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.JoinedRecordType;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.SyntheticRecordType;
import com.apple.foundationdb.record.metadata.UnnestedRecordType;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.query.RecordQuery;
import com.apple.foundationdb.record.query.plan.RecordQueryPlanner;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.synthetic.JoinedRecordPlanner;
import com.apple.foundationdb.record.query.plan.synthetic.SyntheticRecordByTypePlan;
import com.apple.foundationdb.record.query.plan.synthetic.SyntheticRecordConcatPlan;
import com.apple.foundationdb.record.query.plan.synthetic.SyntheticRecordFromStoredRecordPlan;
import com.apple.foundationdb.record.query.plan.synthetic.SyntheticRecordPlan;
import com.apple.foundationdb.record.query.plan.synthetic.SyntheticRecordScanPlan;
import com.apple.foundationdb.record.query.plan.synthetic.UnnestStoredRecordPlan;
import com.apple.foundationdb.record.query.plan.synthetic.UnnestedRecordPlanner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class SyntheticRecordPlanner {
    @Nonnull
    private final FDBRecordStore recordStore;
    @Nonnull
    private final RecordMetaData recordMetaData;
    @Nonnull
    private final RecordQueryPlanner queryPlanner;
    @Nullable
    private final FDBStoreTimer timer;

    public SyntheticRecordPlanner(@Nonnull FDBRecordStore store, @Nonnull RecordQueryPlanner planner) {
        this.recordStore = store;
        this.recordMetaData = store.getRecordMetaData();
        this.queryPlanner = planner;
        this.timer = store.getTimer();
    }

    public SyntheticRecordPlanner(@Nonnull FDBRecordStore store) {
        this(store, new RecordQueryPlanner(store.getRecordMetaData(), store.getRecordStoreState()));
    }

    @Nonnull
    public SyntheticRecordPlan scanForType(@Nonnull SyntheticRecordType<?> syntheticRecordType) {
        SyntheticRecordFromStoredRecordPlan fromRecord = this.forType(syntheticRecordType);
        RecordQueryPlan query = this.queryPlanner.plan(RecordQuery.newBuilder().setRecordTypes(fromRecord.getStoredRecordTypes()).build());
        return new SyntheticRecordScanPlan(query, fromRecord, true);
    }

    @Nonnull
    public SyntheticRecordFromStoredRecordPlan forType(@Nonnull SyntheticRecordType<?> syntheticRecordType) {
        if (syntheticRecordType.getRecordMetaData() != this.recordMetaData) {
            throw SyntheticRecordPlanner.mismatchedMetaData();
        }
        if (syntheticRecordType instanceof JoinedRecordType) {
            return this.forType((JoinedRecordType)syntheticRecordType);
        }
        if (syntheticRecordType instanceof UnnestedRecordType) {
            return this.forType((UnnestedRecordType)syntheticRecordType);
        }
        throw SyntheticRecordPlanner.unknownSyntheticType(syntheticRecordType);
    }

    @Nonnull
    public SyntheticRecordFromStoredRecordPlan forType(@Nonnull JoinedRecordType joinedRecordType) {
        if (joinedRecordType.getRecordMetaData() != this.recordMetaData) {
            throw SyntheticRecordPlanner.mismatchedMetaData();
        }
        Optional<JoinedRecordType.JoinConstituent> maybeConstituent = joinedRecordType.getConstituents().stream().filter(c -> !c.isOuterJoined()).findFirst();
        if (maybeConstituent.isPresent()) {
            return this.forJoinConstituent(joinedRecordType, maybeConstituent.get());
        }
        ArrayListMultimap<String, SyntheticRecordFromStoredRecordPlan> byType = ArrayListMultimap.create();
        for (JoinedRecordType.JoinConstituent joinConstituent : joinedRecordType.getConstituents()) {
            this.addToByType(byType, joinedRecordType, joinConstituent);
        }
        return this.createByType(byType);
    }

    @Nonnull
    public SyntheticRecordFromStoredRecordPlan forType(@Nonnull UnnestedRecordType unnestedRecordType) {
        if (unnestedRecordType.getRecordMetaData() != this.recordMetaData) {
            throw SyntheticRecordPlanner.mismatchedMetaData();
        }
        UnnestedRecordType.NestedConstituent parentConstituent = unnestedRecordType.getParentConstituent();
        return new UnnestStoredRecordPlan(unnestedRecordType, parentConstituent.getRecordType());
    }

    @Nullable
    public SyntheticRecordFromStoredRecordPlan fromStoredType(@Nonnull RecordType storedRecordType, boolean onlyIfIndexed) {
        if (storedRecordType.getRecordMetaData() != this.recordMetaData) {
            throw SyntheticRecordPlanner.mismatchedMetaData();
        }
        if (storedRecordType.isSynthetic()) {
            throw new RecordCoreArgumentException("Record type is not a stored record type", new Object[0]);
        }
        ArrayList<SyntheticRecordFromStoredRecordPlan> subPlans = new ArrayList<SyntheticRecordFromStoredRecordPlan>();
        HashSet<String> syntheticRecordTypes = new HashSet<String>();
        boolean needDistinct = false;
        for (SyntheticRecordType<?> syntheticRecordType : this.recordMetaData.getSyntheticRecordTypes().values()) {
            if (onlyIfIndexed && this.allIndexesDisabled(syntheticRecordType)) continue;
            if (this.timer != null) {
                this.timer.increment(FDBStoreTimer.Counts.PLAN_SYNTHETIC_TYPE);
            }
            for (SyntheticRecordType.Constituent constituent : syntheticRecordType.getConstituents()) {
                SyntheticRecordFromStoredRecordPlan subPlan;
                if (constituent.getRecordType() != storedRecordType) continue;
                if (syntheticRecordType instanceof JoinedRecordType) {
                    subPlan = this.forJoinConstituent((JoinedRecordType)syntheticRecordType, (JoinedRecordType.JoinConstituent)constituent);
                } else if (syntheticRecordType instanceof UnnestedRecordType) {
                    subPlan = this.forUnnestedConstituent((UnnestedRecordType)syntheticRecordType, (UnnestedRecordType.NestedConstituent)constituent);
                } else {
                    throw SyntheticRecordPlanner.unknownSyntheticType(syntheticRecordType);
                }
                subPlans.add(subPlan);
                if (syntheticRecordTypes.add(syntheticRecordType.getName())) continue;
                needDistinct = true;
            }
        }
        if (subPlans.isEmpty()) {
            return null;
        }
        if (subPlans.size() == 1) {
            return (SyntheticRecordFromStoredRecordPlan)subPlans.get(0);
        }
        return new SyntheticRecordConcatPlan(subPlans, needDistinct);
    }

    private boolean allIndexesDisabled(SyntheticRecordType<?> syntheticRecordType) {
        return this.allIndexesDisabled(syntheticRecordType.getIndexes()) && this.allIndexesDisabled(syntheticRecordType.getMultiTypeIndexes());
    }

    private boolean allIndexesDisabled(@Nonnull Collection<Index> indexes) {
        if (indexes.isEmpty()) {
            return true;
        }
        return indexes.stream().allMatch(this.recordStore::isIndexDisabled);
    }

    public static Set<RecordType> storedRecordTypesForIndex(@Nonnull RecordMetaData recordMetaData, @Nonnull Index index, @Nullable Collection<RecordType> recordTypes) {
        if (recordTypes == null) {
            recordTypes = recordMetaData.recordTypesForIndex(index);
        }
        HashSet<RecordType> result = new HashSet<RecordType>();
        for (RecordType recordType : recordTypes) {
            if (recordType instanceof JoinedRecordType) {
                JoinedRecordType joinedRecordType = (JoinedRecordType)recordType;
                Optional<JoinedRecordType.JoinConstituent> maybeConstituent = joinedRecordType.getConstituents().stream().filter(c -> !c.isOuterJoined()).findFirst();
                if (maybeConstituent.isPresent()) {
                    result.add(maybeConstituent.get().getRecordType());
                    continue;
                }
                for (JoinedRecordType.JoinConstituent joinConstituent : joinedRecordType.getConstituents()) {
                    result.add(joinConstituent.getRecordType());
                }
                continue;
            }
            if (recordType instanceof UnnestedRecordType) {
                UnnestedRecordType unnestedRecordType = (UnnestedRecordType)recordType;
                result.add(unnestedRecordType.getParentConstituent().getRecordType());
                continue;
            }
            throw SyntheticRecordPlanner.unknownSyntheticType(recordType);
        }
        return result;
    }

    public Set<RecordType> storedRecordTypesForIndex(@Nonnull Index index, @Nullable Collection<RecordType> recordTypes) {
        return SyntheticRecordPlanner.storedRecordTypesForIndex(this.recordMetaData, index, recordTypes);
    }

    @Nonnull
    public SyntheticRecordFromStoredRecordPlan forIndex(@Nonnull Index index) {
        Collection<RecordType> recordTypes = this.recordMetaData.recordTypesForIndex(index);
        if (recordTypes.size() == 1) {
            RecordType recordType = recordTypes.iterator().next();
            if (!recordType.isSynthetic()) {
                throw new RecordCoreException("Index does not apply to synthetic record types " + String.valueOf(index), new Object[0]);
            }
            return this.forType((SyntheticRecordType)recordType);
        }
        ArrayListMultimap<String, SyntheticRecordFromStoredRecordPlan> byType = ArrayListMultimap.create();
        for (RecordType recordType : recordTypes) {
            if (!(recordType instanceof JoinedRecordType)) {
                throw SyntheticRecordPlanner.unknownSyntheticType(recordType);
            }
            JoinedRecordType joinedRecordType = (JoinedRecordType)recordType;
            Optional<JoinedRecordType.JoinConstituent> maybeConstituent = joinedRecordType.getConstituents().stream().filter(c -> !c.isOuterJoined()).findFirst();
            if (maybeConstituent.isPresent()) {
                this.addToByType(byType, joinedRecordType, maybeConstituent.get());
                continue;
            }
            for (JoinedRecordType.JoinConstituent joinConstituent : joinedRecordType.getConstituents()) {
                this.addToByType(byType, joinedRecordType, joinConstituent);
            }
        }
        return this.createByType(byType);
    }

    @Nonnull
    public SyntheticRecordFromStoredRecordPlan forJoinConstituent(@Nonnull JoinedRecordType joinedRecordType, @Nonnull JoinedRecordType.JoinConstituent joinConstituent) {
        if (joinedRecordType.getRecordMetaData() != this.recordMetaData) {
            throw SyntheticRecordPlanner.mismatchedMetaData();
        }
        if (!joinedRecordType.getConstituents().contains(joinConstituent)) {
            throw new RecordCoreArgumentException("Join constituent is not from record type", new Object[0]);
        }
        return new JoinedRecordPlanner(joinedRecordType, this.queryPlanner).plan(joinConstituent);
    }

    @Nonnull
    public SyntheticRecordFromStoredRecordPlan forUnnestedConstituent(@Nonnull UnnestedRecordType unnestedRecordType, @Nonnull UnnestedRecordType.NestedConstituent constituent) {
        if (unnestedRecordType.getRecordMetaData() != this.recordMetaData) {
            throw SyntheticRecordPlanner.mismatchedMetaData();
        }
        if (!unnestedRecordType.getConstituents().contains(constituent)) {
            throw new RecordCoreArgumentException("Constituent is not from record type", new Object[0]);
        }
        return new UnnestedRecordPlanner(unnestedRecordType).plan(constituent);
    }

    private void addToByType(@Nonnull Multimap<String, SyntheticRecordFromStoredRecordPlan> byType, @Nonnull JoinedRecordType joinedRecordType, @Nonnull JoinedRecordType.JoinConstituent joinConstituent) {
        byType.put(joinConstituent.getRecordType().getName(), this.forJoinConstituent(joinedRecordType, joinConstituent));
    }

    @Nonnull
    private SyntheticRecordByTypePlan createByType(@Nonnull Multimap<String, SyntheticRecordFromStoredRecordPlan> byType) {
        HashMap<String, SyntheticRecordFromStoredRecordPlan> map = new HashMap<String, SyntheticRecordFromStoredRecordPlan>();
        for (Map.Entry<String, Collection<SyntheticRecordFromStoredRecordPlan>> entry : byType.asMap().entrySet()) {
            map.put(entry.getKey(), entry.getValue().size() == 1 ? entry.getValue().iterator().next() : new SyntheticRecordConcatPlan(new ArrayList<SyntheticRecordFromStoredRecordPlan>(entry.getValue()), false));
        }
        return new SyntheticRecordByTypePlan(map);
    }

    static RecordCoreException mismatchedMetaData() {
        return new RecordCoreArgumentException("Record type does not belong to same meta-data", new Object[0]);
    }

    static RecordCoreException unknownSyntheticType(@Nonnull RecordType syntheticRecordType) {
        return new RecordCoreException("Do not know how to generate synthetic records for " + String.valueOf(syntheticRecordType), new Object[0]);
    }
}

