/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.synthetic;

import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PipelineOperation;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBSyntheticRecord;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.synthetic.SyntheticRecordConcatPlan;
import com.apple.foundationdb.record.query.plan.synthetic.SyntheticRecordFromStoredRecordPlan;
import com.apple.foundationdb.record.query.plan.synthetic.SyntheticRecordPlan;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class SyntheticRecordScanPlan
implements SyntheticRecordPlan {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Synthetic-Record-Scan-Plan");
    @Nonnull
    private final RecordQueryPlan seedPlan;
    @Nonnull
    private final SyntheticRecordFromStoredRecordPlan fromSeedPlan;
    private final boolean needDistinct;

    public SyntheticRecordScanPlan(@Nonnull RecordQueryPlan seedPlan, @Nonnull SyntheticRecordFromStoredRecordPlan fromSeedPlan, boolean needDistinct) {
        this.seedPlan = seedPlan;
        this.fromSeedPlan = fromSeedPlan;
        this.needDistinct = needDistinct;
    }

    @Nonnull
    public RecordQueryPlan getSeedPlan() {
        return this.seedPlan;
    }

    @Nonnull
    public SyntheticRecordFromStoredRecordPlan getFromSeedPlan() {
        return this.fromSeedPlan;
    }

    public boolean isNeedDistinct() {
        return this.needDistinct;
    }

    @Override
    @Nonnull
    public RecordCursor<FDBSyntheticRecord> execute(@Nonnull FDBRecordStore store, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        ExecuteProperties baseProperties = executeProperties.clearSkipAndLimit();
        RecordCursor<FDBSyntheticRecord> cursor = RecordCursor.flatMapPipelined(outerContinuation -> store.executeQuery(this.seedPlan, (byte[])outerContinuation, baseProperties), (queriedRecord, innerContinuation) -> this.fromSeedPlan.execute(store, queriedRecord.getStoredRecord(), (byte[])innerContinuation, baseProperties), continuation, store.getPipelineSize(PipelineOperation.SYNTHETIC_RECORD_JOIN));
        if (this.needDistinct) {
            cursor = SyntheticRecordConcatPlan.addDistinct(cursor);
        }
        cursor = cursor.skipThenLimit(executeProperties.getSkip(), executeProperties.getReturnedRowLimit());
        return cursor;
    }

    public String toString() {
        return String.valueOf(this.seedPlan) + " | " + String.valueOf(this.fromSeedPlan);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyntheticRecordScanPlan that = (SyntheticRecordScanPlan)o;
        return this.needDistinct == that.needDistinct && Objects.equals(this.seedPlan, that.seedPlan) && Objects.equals(this.fromSeedPlan, that.fromSeedPlan);
    }

    public int hashCode() {
        return Objects.hash(this.seedPlan, this.fromSeedPlan, this.needDistinct);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: {
                return this.seedPlan.planHash(mode) + this.fromSeedPlan.planHash(mode) + (this.needDistinct ? 1 : 0);
            }
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.seedPlan, this.fromSeedPlan, this.needDistinct);
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }
}

