/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.synthetic;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.UnnestedRecordType;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoredRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBSyntheticRecord;
import com.apple.foundationdb.record.query.plan.synthetic.SyntheticRecordFromStoredRecordPlan;
import com.apple.foundationdb.tuple.Tuple;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.protobuf.Message;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
class UnnestStoredRecordPlan
implements SyntheticRecordFromStoredRecordPlan {
    @Nonnull
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("UnnestStoredRecordPlan");
    @Nonnull
    private final UnnestedRecordType recordType;
    @Nonnull
    private final RecordType storedRecordType;

    UnnestStoredRecordPlan(@Nonnull UnnestedRecordType recordType, @Nonnull RecordType storedRecordType) {
        this.recordType = recordType;
        this.storedRecordType = storedRecordType;
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode hashMode) {
        return PlanHashable.objectsPlanHash(hashMode, BASE_HASH, this.recordType.getName(), this.storedRecordType.getName());
    }

    @Override
    @Nonnull
    public Set<String> getStoredRecordTypes() {
        return Collections.singleton(this.storedRecordType.getName());
    }

    @Override
    @Nonnull
    public Set<String> getSyntheticRecordTypes() {
        return Collections.singleton(this.recordType.getName());
    }

    @Override
    @Nonnull
    public <M extends Message> RecordCursor<FDBSyntheticRecord> execute(@Nonnull FDBRecordStore store, @Nonnull FDBStoredRecord<M> rec, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        NestingNode root = new NestingNode(this.recordType.getParentConstituent(), rec);
        ArrayDeque<NestingNode> toProcess = new ArrayDeque<NestingNode>();
        toProcess.add(root);
        while (!toProcess.isEmpty()) {
            NestingNode next = (NestingNode)toProcess.pollFirst();
            for (UnnestedRecordType.NestedConstituent nesting : this.recordType.getConstituents()) {
                next.processNesting(nesting, toProcess);
            }
        }
        List<FDBSyntheticRecord> resultRecords = this.iterateTree(root);
        return RecordCursor.fromList(store.getExecutor(), resultRecords);
    }

    private List<FDBSyntheticRecord> iterateTree(@Nonnull NestingNode root) {
        ArrayList<FDBSyntheticRecord> records = new ArrayList<FDBSyntheticRecord>();
        do {
            this.addRecord(records, root);
        } while (root.incrementState());
        return records;
    }

    private void addRecord(@Nonnull List<FDBSyntheticRecord> records, @Nonnull NestingNode node) {
        FDBSyntheticRecord syntheticRecord = this.constructRecord(node);
        if (syntheticRecord != null) {
            records.add(syntheticRecord);
        }
    }

    @Nullable
    private FDBSyntheticRecord constructRecord(@Nonnull NestingNode node) {
        ImmutableMap.Builder<String, FDBStoredRecord<?>> mapBuilder = ImmutableMap.builderWithExpectedSize(this.recordType.getConstituents().size());
        node.collectConstituents(mapBuilder);
        ImmutableMap<String, FDBStoredRecord<? extends Message>> constituentMap = mapBuilder.build();
        if (constituentMap.size() == this.recordType.getConstituents().size()) {
            return FDBSyntheticRecord.of(this.recordType, constituentMap);
        }
        return null;
    }

    private static class NestingNode {
        @Nonnull
        private final UnnestedRecordType.NestedConstituent constituent;
        @Nonnull
        private final FDBStoredRecord<?> storedRecord;
        @Nullable
        private Map<String, List<NestingNode>> children;
        @Nullable
        private Map<String, Integer> state;
        @Nullable
        private List<String> keys;

        public NestingNode(@Nonnull UnnestedRecordType.NestedConstituent constituent, @Nonnull FDBStoredRecord<?> storedRecord) {
            this.constituent = constituent;
            this.storedRecord = storedRecord;
        }

        public boolean processNesting(@Nonnull UnnestedRecordType.NestedConstituent nesting, Deque<NestingNode> toProcess) {
            if (!this.constituent.getName().equals(nesting.getParentName())) {
                return false;
            }
            List<Key.Evaluated> evaluatedList = nesting.getNestingExpression().evaluate(this.storedRecord);
            for (int i = 0; i < evaluatedList.size(); ++i) {
                Key.Evaluated evaluated = evaluatedList.get(i);
                Message childMessage = evaluated.getObject(0, Message.class);
                FDBStoredRecord<Message> childRecord = FDBStoredRecord.newBuilder(childMessage).setRecordType(nesting.getRecordType()).setPrimaryKey(Tuple.from(i)).build();
                this.addChild(nesting, childRecord, toProcess);
            }
            return true;
        }

        private void addChild(UnnestedRecordType.NestedConstituent childConstituent, FDBStoredRecord<?> childRecord, Deque<NestingNode> toProcess) {
            List<Object> childList;
            String childName;
            if (this.children == null) {
                this.children = new HashMap<String, List<NestingNode>>();
            }
            if (this.children.containsKey(childName = childConstituent.getName())) {
                childList = this.children.get(childName);
            } else {
                childList = new ArrayList();
                this.children.put(childName, childList);
                this.keys = null;
            }
            NestingNode newChild = new NestingNode(childConstituent, childRecord);
            childList.add(newChild);
            toProcess.addLast(newChild);
        }

        @Nonnull
        public List<String> getKeys() {
            if (this.children == null) {
                return Collections.emptyList();
            }
            if (this.keys == null) {
                ArrayList<String> keyList = new ArrayList<String>(this.children.size());
                keyList.addAll(this.children.keySet());
                keyList.sort(Comparator.naturalOrder());
                this.keys = keyList;
            }
            return this.keys;
        }

        private void initializeState() {
            if (this.children != null && this.state == null) {
                this.state = Maps.newHashMapWithExpectedSize(this.children.size());
                for (String key : this.getKeys()) {
                    this.state.put(key, 0);
                }
            }
        }

        public boolean incrementState() {
            if (this.children == null) {
                return false;
            }
            if (this.state == null) {
                throw new RecordCoreException("cannot increment un-initialized state", new Object[0]);
            }
            for (String key : this.getKeys()) {
                int pos = this.state.get(key);
                List<NestingNode> keyChildren = this.children.get(key);
                NestingNode child = keyChildren.get(pos);
                if (child.incrementState()) {
                    return true;
                }
                if (pos + 1 < keyChildren.size()) {
                    this.state.put(key, pos + 1);
                    return true;
                }
                this.state.put(key, 0);
            }
            return false;
        }

        void collectConstituents(@Nonnull ImmutableMap.Builder<String, FDBStoredRecord<?>> mapBuilder) {
            mapBuilder.put(this.constituent.getName(), this.storedRecord);
            if (this.children != null) {
                this.initializeState();
                for (String key : this.getKeys()) {
                    int childPos = this.state.get(key);
                    NestingNode child = this.children.get(key).get(childPos);
                    child.collectConstituents(mapBuilder);
                }
            }
        }
    }
}

