/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.synthetic;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.UnnestedRecordType;
import com.apple.foundationdb.record.query.plan.synthetic.SyntheticRecordFromStoredRecordPlan;
import com.apple.foundationdb.record.query.plan.synthetic.UnnestStoredRecordPlan;
import javax.annotation.Nonnull;

@API(value=API.Status.INTERNAL)
class UnnestedRecordPlanner {
    @Nonnull
    private final UnnestedRecordType recordType;

    UnnestedRecordPlanner(@Nonnull UnnestedRecordType recordType) {
        this.recordType = recordType;
    }

    public SyntheticRecordFromStoredRecordPlan plan(UnnestedRecordType.NestedConstituent constituent) {
        if (!constituent.isParent()) {
            throw new RecordCoreArgumentException("Can only create synthetic records for parent constituent", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.EXPECTED, this.recordType.getParentConstituent().getName()}).addLogInfo(new Object[]{LogMessageKeys.ACTUAL, constituent.getName()});
        }
        return new UnnestStoredRecordPlan(this.recordType, constituent.getRecordType());
    }
}

