/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.visitor;

import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.FieldKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.FunctionKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.LiteralKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.QueryableKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.ThenKeyExpression;
import com.apple.foundationdb.record.query.expressions.AndOrComponent;
import com.apple.foundationdb.record.query.expressions.FieldWithComparison;
import com.apple.foundationdb.record.query.expressions.NestedField;
import com.apple.foundationdb.record.query.expressions.NotComponent;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.expressions.QueryKeyExpressionWithComparison;
import com.apple.foundationdb.record.query.expressions.QueryKeyExpressionWithOneOfComparison;
import com.apple.foundationdb.record.query.plan.AvailableFields;
import com.apple.foundationdb.record.query.plan.PlannableIndexTypes;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFetchFromPartialRecordPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFilterPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.TranslateValueFunction;
import com.apple.foundationdb.record.query.plan.visitor.RecordQueryPlannerSubstitutionVisitor;
import com.google.common.base.Verify;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FilterVisitor
extends RecordQueryPlannerSubstitutionVisitor {
    public FilterVisitor(@Nonnull RecordMetaData recordMetadata, @Nonnull PlannableIndexTypes indexTypes, @Nullable KeyExpression commonPrimaryKey) {
        super(recordMetadata, indexTypes, commonPrimaryKey);
    }

    @Override
    @Nonnull
    public RecordQueryPlan postVisit(@Nonnull RecordQueryPlan recordQueryPlan) {
        if (recordQueryPlan instanceof RecordQueryFilterPlan) {
            RecordQueryFilterPlan filterPlan = (RecordQueryFilterPlan)recordQueryPlan;
            List<QueryComponent> filters = filterPlan.getFilters();
            AvailableFields availableFields = this.availableFields(((RecordQueryFilterPlan)recordQueryPlan).getInnerPlan());
            ArrayList<QueryComponent> indexFilters = Lists.newArrayListWithCapacity(filters.size());
            ArrayList<QueryComponent> residualFilters = Lists.newArrayListWithCapacity(filters.size());
            HashSet<KeyExpression> allReferencedFields = new HashSet<KeyExpression>();
            FilterVisitor.partitionFilters(filters, availableFields, indexFilters, residualFilters, allReferencedFields);
            Verify.verify(indexFilters.size() + residualFilters.size() == filters.size());
            if (indexFilters.isEmpty()) {
                return recordQueryPlan;
            }
            RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords fetchIndexRecords = FilterVisitor.resolveFetchIndexRecordsFromPlan(filterPlan.getChild());
            if (fetchIndexRecords == null) {
                return recordQueryPlan;
            }
            RecordQueryPlan removedFetchPlan = this.removeIndexFetch(filterPlan.getChild(), allReferencedFields);
            if (removedFetchPlan == null) {
                return recordQueryPlan;
            }
            recordQueryPlan = new RecordQueryFetchFromPartialRecordPlan(new RecordQueryFilterPlan(removedFetchPlan, indexFilters), TranslateValueFunction.unableToTranslate(), (Type)new Type.Any(), fetchIndexRecords);
            if (!residualFilters.isEmpty()) {
                recordQueryPlan = new RecordQueryFilterPlan(recordQueryPlan, residualFilters);
            }
        }
        return recordQueryPlan;
    }

    public static void partitionFilters(@Nonnull List<QueryComponent> filters, @Nonnull AvailableFields availableFields, @Nonnull List<QueryComponent> indexFilters, @Nonnull List<QueryComponent> residualFilters, @Nullable Set<KeyExpression> allReferencedFields) {
        for (QueryComponent filter : filters) {
            HashSet<KeyExpression> referencedFields;
            if (FilterVisitor.findFilterReferencedFields(filter, referencedFields = new HashSet<KeyExpression>()) && availableFields.containsAll(referencedFields)) {
                indexFilters.add(filter);
                if (allReferencedFields == null) continue;
                allReferencedFields.addAll(referencedFields);
                continue;
            }
            residualFilters.add(filter);
        }
    }

    public static boolean findFilterReferencedFields(@Nonnull QueryComponent filter, @Nonnull Set<KeyExpression> filterFields) {
        if (filter instanceof FieldWithComparison) {
            filterFields.add(Key.Expressions.field(((FieldWithComparison)filter).getFieldName()));
            return true;
        }
        if (filter instanceof AndOrComponent) {
            for (QueryComponent child : ((AndOrComponent)filter).getChildren()) {
                if (FilterVisitor.findFilterReferencedFields(child, filterFields)) continue;
                return false;
            }
            return true;
        }
        if (filter instanceof NotComponent) {
            QueryComponent child = ((NotComponent)filter).getChild();
            return FilterVisitor.findFilterReferencedFields(child, filterFields);
        }
        if (filter instanceof QueryKeyExpressionWithComparison) {
            QueryableKeyExpression keyExpression = ((QueryKeyExpressionWithComparison)filter).getKeyExpression();
            return FilterVisitor.findFilterReferencedFields(keyExpression, filterFields);
        }
        if (filter instanceof QueryKeyExpressionWithOneOfComparison) {
            QueryableKeyExpression keyExpression = ((QueryKeyExpressionWithOneOfComparison)filter).getKeyExpression();
            return FilterVisitor.findFilterReferencedFields(keyExpression, filterFields);
        }
        if (filter instanceof NestedField) {
            HashSet<KeyExpression> childFilterFields = new HashSet<KeyExpression>();
            if (FilterVisitor.findFilterReferencedFields(((NestedField)filter).getChild(), childFilterFields)) {
                FieldKeyExpression parent = Key.Expressions.field(((NestedField)filter).getFieldName());
                for (KeyExpression childFilterField : childFilterFields) {
                    filterFields.add(parent.nest(childFilterField));
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private static boolean findFilterReferencedFields(@Nonnull KeyExpression expression, @Nonnull Set<KeyExpression> filterFields) {
        if (expression instanceof ThenKeyExpression) {
            for (KeyExpression child : ((ThenKeyExpression)expression).getChildren()) {
                if (FilterVisitor.findFilterReferencedFields(child, filterFields)) continue;
                return false;
            }
            return true;
        }
        if (expression instanceof FunctionKeyExpression) {
            return FilterVisitor.findFilterReferencedFields(((FunctionKeyExpression)expression).getArguments(), filterFields);
        }
        if (expression instanceof LiteralKeyExpression) {
            return true;
        }
        filterFields.add(expression);
        return true;
    }
}

