/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.visitor;

import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.query.plan.PlannableIndexTypes;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFetchFromPartialRecordPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.TranslateValueFunction;
import com.apple.foundationdb.record.query.plan.visitor.RecordQueryPlannerSubstitutionVisitor;
import com.google.common.collect.Sets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class InJoinVisitor
extends RecordQueryPlannerSubstitutionVisitor {
    public InJoinVisitor(@Nonnull RecordMetaData recordMetadata, @Nonnull PlannableIndexTypes indexTypes, @Nullable KeyExpression commonPrimaryKey) {
        super(recordMetadata, indexTypes, commonPrimaryKey);
    }

    @Override
    @Nonnull
    public RecordQueryPlan postVisit(@Nonnull RecordQueryPlan recordQueryPlan) {
        if (recordQueryPlan instanceof RecordQueryInJoinPlan) {
            RecordQueryInJoinPlan inJoinPlan = (RecordQueryInJoinPlan)recordQueryPlan;
            RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords fetchIndexRecords = InJoinVisitor.resolveFetchIndexRecordsFromPlan(inJoinPlan.getChild());
            if (fetchIndexRecords == null) {
                return recordQueryPlan;
            }
            RecordQueryPlan removedFetchPlan = this.removeIndexFetch(inJoinPlan.getChild(), Sets.newHashSet());
            if (removedFetchPlan == null) {
                return recordQueryPlan;
            }
            recordQueryPlan = new RecordQueryFetchFromPartialRecordPlan(inJoinPlan.withChild(Reference.plannedOf(removedFetchPlan)), TranslateValueFunction.unableToTranslate(), (Type)new Type.Any(), fetchIndexRecords);
        }
        return recordQueryPlan;
    }
}

