/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.visitor;

import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.query.plan.PlannableIndexTypes;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFetchFromPartialRecordPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIntersectionOnKeyExpressionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIntersectionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.TranslateValueFunction;
import com.apple.foundationdb.record.query.plan.visitor.RecordQueryPlannerSubstitutionVisitor;
import com.google.common.base.Verify;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IntersectionVisitor
extends RecordQueryPlannerSubstitutionVisitor {
    public IntersectionVisitor(@Nonnull RecordMetaData recordMetadata, @Nonnull PlannableIndexTypes indexTypes, @Nullable KeyExpression commonPrimaryKey) {
        super(recordMetadata, indexTypes, commonPrimaryKey);
    }

    @Override
    @Nonnull
    public RecordQueryPlan postVisit(@Nonnull RecordQueryPlan recordQueryPlan) {
        if (recordQueryPlan instanceof RecordQueryIntersectionPlan) {
            RecordQueryIntersectionOnKeyExpressionPlan intersectionPlan = (RecordQueryIntersectionOnKeyExpressionPlan)recordQueryPlan;
            Set<KeyExpression> requiredFields = intersectionPlan.getRequiredFields();
            ArrayList<RecordQueryPlan> newChildren = new ArrayList<RecordQueryPlan>(intersectionPlan.getChildren().size());
            RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords fetchIndexRecords = null;
            for (RecordQueryPlan plan : intersectionPlan.getChildren()) {
                RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords currentFetchIndexRecords = IntersectionVisitor.resolveFetchIndexRecordsFromPlan(plan);
                if (currentFetchIndexRecords == null) {
                    return recordQueryPlan;
                }
                if (fetchIndexRecords == null) {
                    fetchIndexRecords = currentFetchIndexRecords;
                } else if (fetchIndexRecords != currentFetchIndexRecords) {
                    return recordQueryPlan;
                }
                RecordQueryPlan newPlan = this.removeIndexFetch(plan, requiredFields);
                if (newPlan == null) {
                    return recordQueryPlan;
                }
                newChildren.add(newPlan);
            }
            return new RecordQueryFetchFromPartialRecordPlan(RecordQueryIntersectionPlan.from(newChildren, intersectionPlan.getComparisonKeyExpression()), TranslateValueFunction.unableToTranslate(), (Type)new Type.Any(), (RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords)Verify.verifyNotNull(fetchIndexRecords));
        }
        return recordQueryPlan;
    }
}

